/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.recipe;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ExtraOutputChancePair;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IRecipeMatrixMatcher;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ToolEntry;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.recipe.ArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktablesConfig;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTArtisanIngredient;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTArtisanRecipe;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import crafttweaker.mc1120.item.VanillaIngredient;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import crafttweaker.mc1120.recipes.MCRecipeShaped;
import crafttweaker.mc1120.recipes.MCRecipeShapeless;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class VanillaRecipeCache {
    private static final ThreadLocal<Map<ResourceLocation, IArtisanRecipe>> CACHE = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<IRecipe[]> LAST_RECIPE = ThreadLocal.withInitial(() -> new IRecipe[1]);
    private static MethodHandle mcRecipeBase$recipeFunctionGetter;

    @Nullable
    public static synchronized IArtisanRecipe getArtisanRecipe(InventoryWrapper inventoryWrapper, World world) {
        if (inventoryWrapper.func_191420_l()) {
            return null;
        }
        IRecipe recipe = LAST_RECIPE.get()[0];
        if (recipe == null || !recipe.func_77569_a((InventoryCrafting)inventoryWrapper, world)) {
            recipe = CraftingManager.func_192413_b((InventoryCrafting)inventoryWrapper, (World)world);
        }
        if (recipe == null || ModuleWorktablesConfig.isRecipeBlacklisted(recipe.getRegistryName())) {
            return null;
        }
        VanillaRecipeCache.LAST_RECIPE.get()[0] = recipe;
        return VanillaRecipeCache.getArtisanRecipeWrapped(recipe);
    }

    @Nullable
    private static IArtisanRecipe getArtisanRecipeWrapped(IRecipe recipe) {
        IArtisanRecipe artisanRecipe;
        ResourceLocation resourceLocation = recipe.getRegistryName();
        if (resourceLocation == null) {
            return null;
        }
        IArtisanRecipe cachedRecipe = CACHE.get().get(resourceLocation);
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        NonNullList ingredients = recipe.func_192400_c();
        ArrayList<IArtisanIngredient> artisanIngredients = new ArrayList<IArtisanIngredient>(ingredients.size());
        Object[] extraOutputChancePairs = new ExtraOutputChancePair[3];
        Arrays.fill(extraOutputChancePairs, new ExtraOutputChancePair(ArtisanItemStack.EMPTY, 0.0f));
        if (recipe instanceof MCRecipeShaped) {
            MCRecipeShaped recipeShaped = (MCRecipeShaped)recipe;
            int recipeWidth = recipeShaped.getRecipeWidth();
            int recipeHeight = recipeShaped.getRecipeHeight();
            for (Ingredient ingredient : ingredients) {
                if (ingredient instanceof VanillaIngredient) {
                    artisanIngredients.add(CTArtisanIngredient.from(((VanillaIngredient)ingredient).getIngredient()));
                    continue;
                }
                artisanIngredients.add(ArtisanIngredient.from(ingredient));
            }
            artisanRecipe = VanillaRecipeCache.createCTArtisanRecipe((MCRecipeBase)recipeShaped, artisanIngredients, (ExtraOutputChancePair[])extraOutputChancePairs, true, recipeWidth, recipeHeight, (MCRecipeBase)recipeShaped);
            if (artisanRecipe == null) {
                return null;
            }
        } else if (recipe instanceof MCRecipeShapeless) {
            MCRecipeShapeless recipeShapeless = (MCRecipeShapeless)recipe;
            for (Ingredient ingredient : ingredients) {
                if (ingredient instanceof VanillaIngredient) {
                    artisanIngredients.add(CTArtisanIngredient.from(((VanillaIngredient)ingredient).getIngredient()));
                    continue;
                }
                artisanIngredients.add(ArtisanIngredient.from(ingredient));
            }
            artisanRecipe = VanillaRecipeCache.createCTArtisanRecipe((MCRecipeBase)recipeShapeless, artisanIngredients, (ExtraOutputChancePair[])extraOutputChancePairs, false, 0, 0, (MCRecipeBase)recipeShapeless);
            if (artisanRecipe == null) {
                return null;
            }
        } else {
            for (Ingredient ingredient : ingredients) {
                artisanIngredients.add(ArtisanIngredient.from(ingredient));
            }
            boolean isShaped = recipe instanceof IShapedRecipe;
            if (isShaped) {
                int recipeWidth = ((IShapedRecipe)recipe).getRecipeWidth();
                int recipeHeight = ((IShapedRecipe)recipe).getRecipeHeight();
                artisanRecipe = VanillaRecipeCache.createArtisanRecipe(recipe, artisanIngredients, (ExtraOutputChancePair[])extraOutputChancePairs, true, recipeWidth, recipeHeight);
            } else {
                artisanRecipe = VanillaRecipeCache.createArtisanRecipe(recipe, artisanIngredients, (ExtraOutputChancePair[])extraOutputChancePairs, false, 0, 0);
            }
        }
        CACHE.get().put(resourceLocation, artisanRecipe);
        return artisanRecipe;
    }

    private static IArtisanRecipe createCTArtisanRecipe(MCRecipeBase recipe, List<IArtisanIngredient> artisanIngredients, ExtraOutputChancePair[] extraOutputChancePairs, boolean isShaped, int recipeWidth, int recipeHeight, MCRecipeBase mcRecipeBase) {
        CTArtisanRecipe artisanRecipe;
        try {
            artisanRecipe = new CTArtisanRecipe(null, Collections.emptyMap(), Collections.singletonList(new OutputWeightPair(ArtisanItemStack.from(recipe.func_77571_b().func_77946_l()), 1)), new ToolEntry[]{}, artisanIngredients, Collections.emptyList(), false, null, 0, 0, false, extraOutputChancePairs, isShaped ? IRecipeMatrixMatcher.SHAPED : IRecipeMatrixMatcher.SHAPELESS, true, recipeWidth, recipeHeight, EnumTier.WORKTABLE.getId(), EnumTier.WORKSHOP.getId(), mcRecipeBase.getRecipeAction(), mcRecipeBase$recipeFunctionGetter == null ? null : mcRecipeBase$recipeFunctionGetter.invokeExact(recipe), false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        return artisanRecipe;
    }

    private static ArtisanRecipe createArtisanRecipe(IRecipe recipe, List<IArtisanIngredient> artisanIngredients, ExtraOutputChancePair[] extraOutputChancePairs, boolean isShaped, int recipeWidth, int recipeHeight) {
        return new ArtisanRecipe(null, Collections.emptyMap(), Collections.singletonList(new OutputWeightPair(ArtisanItemStack.from(recipe.func_77571_b().func_77946_l()), 1)), new ToolEntry[]{}, artisanIngredients, Collections.emptyList(), false, null, 0, 0, false, extraOutputChancePairs, isShaped ? IRecipeMatrixMatcher.SHAPED : IRecipeMatrixMatcher.SHAPELESS, true, recipeWidth, recipeHeight, EnumTier.WORKTABLE.getId(), EnumTier.WORKSHOP.getId(), false);
    }

    private VanillaRecipeCache() {
    }

    static {
        try {
            Field recipeFunction = MCRecipeBase.class.getDeclaredField("recipeFunction");
            recipeFunction.setAccessible(true);
            mcRecipeBase$recipeFunctionGetter = MethodHandles.lookup().unreflectGetter(recipeFunction);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static class InventoryWrapper
    extends InventoryCrafting {
        private final TileEntityBase tile;

        public InventoryWrapper(TileEntityBase tile) {
            super(new Container(){

                public boolean func_75145_c(@Nonnull EntityPlayer player) {
                    return true;
                }
            }, tile.getTier() == EnumTier.WORKSHOP ? 5 : 3, tile.getTier() == EnumTier.WORKSHOP ? 5 : 3);
            this.tile = tile;
        }

        public boolean func_191420_l() {
            int slotCount = this.func_174922_i() * this.func_174923_h();
            for (int i = 0; i < slotCount; ++i) {
                if (this.tile.getCraftingMatrixHandler().getStackInSlot(i).func_190926_b()) continue;
                return false;
            }
            return true;
        }

        @Nonnull
        public ItemStack func_70301_a(int index) {
            if (index >= this.func_70302_i_()) {
                return ItemStack.field_190927_a;
            }
            return this.tile.getCraftingMatrixHandler().getStackInSlot(index);
        }

        public void func_70299_a(int index, @Nonnull ItemStack stack) {
            this.tile.getCraftingMatrixHandler().setStackInSlot(index, stack);
        }

        @Nonnull
        public ItemStack func_70463_b(int x, int y) {
            int size;
            int n = size = this.tile.getTier() == EnumTier.WORKSHOP ? 5 : 3;
            if (x >= 0 && x < size && y >= 0 && y < size) {
                int index = x + y * size;
                return this.tile.getCraftingMatrixHandler().getStackInSlot(index);
            }
            return ItemStack.field_190927_a;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }
    }
}

