/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.recipe;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingContext;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.artisanworktables.modules.toolbox.tile.TileEntityMechanicalToolbox;
import com.codetaylor.mc.artisanworktables.modules.toolbox.tile.TileEntityToolbox;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CraftingContextFactory {
    public static ICraftingContext createContext(final TileEntityBase tile, final EntityPlayer player, final @Nullable IItemHandlerModifiable secondaryIngredientHandler) {
        return new ICraftingContext(){

            @Override
            public World getWorld() {
                return tile.func_145831_w();
            }

            @Override
            public Optional<EntityPlayer> getPlayer() {
                return Optional.of(player);
            }

            @Override
            public ICraftingMatrixStackHandler getCraftingMatrixHandler() {
                return tile.getCraftingMatrixHandler();
            }

            @Override
            public IItemHandlerModifiable getToolHandler() {
                return tile.getToolHandler();
            }

            @Override
            public IItemHandler getSecondaryOutputHandler() {
                return tile.getSecondaryOutputHandler();
            }

            @Override
            @Nullable
            public IItemHandlerModifiable getSecondaryIngredientHandler() {
                return secondaryIngredientHandler;
            }

            @Override
            public IFluidHandler getFluidHandler() {
                return tile.getTank();
            }

            @Override
            @Nullable
            public IItemHandler getToolReplacementHandler() {
                TileEntityToolbox adjacentToolbox = tile.getAdjacentToolbox();
                if (!(adjacentToolbox instanceof TileEntityMechanicalToolbox)) {
                    return null;
                }
                return (IItemHandler)adjacentToolbox.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            }

            @Override
            public EnumType getType() {
                return tile.getType();
            }

            @Override
            public EnumTier getTier() {
                return tile.getTier();
            }

            @Override
            public BlockPos getPosition() {
                return tile.func_174877_v();
            }
        };
    }

    private CraftingContextFactory() {
    }
}

