/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei;

import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.event.ArtisanUpdateJEIRecipeVisibilityEvent;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeRegistry;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.artisanworktables.api.recipe.ArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirement;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktables;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktablesConfig;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.JEICategoryFactory;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.JEIRecipeTransferInfoVanilla;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.JEIRecipeTransferInfoWorktable;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.JEIRecipeWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PluginJEI
implements IModPlugin {
    public static IRecipeRegistry RECIPE_REGISTRY;
    private IIngredientRegistry ingredientRegistry;

    public PluginJEI() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        JEICategoryFactory categoryFactory = new JEICategoryFactory(registry.getJeiHelpers().getGuiHelper());
        for (EnumTier tier : EnumTier.values()) {
            if (!ModuleWorktablesConfig.isTierEnabled(tier)) continue;
            for (String name : ArtisanAPI.getWorktableNames()) {
                registry.addRecipeCategories(new IRecipeCategory[]{categoryFactory.createCategory(name, tier)});
            }
        }
    }

    public void register(IModRegistry registry) {
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModuleWorktables.Blocks.TAB_ICON));
        this.ingredientRegistry = registry.getIngredientRegistry();
        for (EnumTier tier : EnumTier.values()) {
            if (!ModuleWorktablesConfig.isTierEnabled(tier)) continue;
            for (String name : ArtisanAPI.getWorktableNames()) {
                registry.addRecipeCatalyst((Object)this.getWorktableAsItemStack(name, tier), new String[]{PluginJEI.createUID(name, tier)});
            }
            for (String name : ArtisanAPI.getWorktableNames()) {
                registry.handleRecipes(ArtisanRecipe.class, JEIRecipeWrapper::new, PluginJEI.createUID(name, tier));
            }
            IRecipeTransferRegistry transferRegistry = registry.getRecipeTransferRegistry();
            for (String name : ArtisanAPI.getWorktableNames()) {
                transferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new JEIRecipeTransferInfoWorktable(name, PluginJEI.createUID(name, tier), tier));
            }
            transferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new JEIRecipeTransferInfoVanilla());
            for (String name : ArtisanAPI.getWorktableNames()) {
                List<IArtisanRecipe> recipeList = new ArrayList<IArtisanRecipe>();
                RecipeRegistry recipeRegistry = ArtisanAPI.getWorktableRecipeRegistry(name);
                recipeList = recipeRegistry.getRecipeListByTier(tier, recipeList);
                registry.addRecipes(recipeList, PluginJEI.createUID(name, tier));
            }
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        RECIPE_REGISTRY = jeiRuntime.getRecipeRegistry();
        this.hideTables();
        this.hideRecipes();
    }

    private void hideTables() {
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        for (Map.Entry<String, Boolean> entry : ModuleWorktablesConfig.ENABLE_TABLE_TYPE.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            for (EnumTier tier : EnumTier.values()) {
                if (!ModuleWorktablesConfig.isTierEnabled(tier)) continue;
                toRemove.add(this.getWorktableAsItemStack(entry.getKey(), tier));
            }
        }
        if (!toRemove.isEmpty()) {
            this.ingredientRegistry.removeIngredientsAtRuntime(ItemStack.class, toRemove);
        }
    }

    private void hideRecipes() {
        for (String name : ArtisanAPI.getWorktableNames()) {
            RecipeRegistry registry = ArtisanAPI.getWorktableRecipeRegistry(name);
            if (registry == null) continue;
            for (EnumTier tier : EnumTier.values()) {
                List<IArtisanRecipe> recipeList = registry.getRecipeListByTier(tier, new ArrayList<IArtisanRecipe>());
                for (IArtisanRecipe recipe : recipeList) {
                    String uid;
                    IRecipeWrapper recipeWrapper;
                    if (!recipe.isHidden() && !this.shouldHideRecipe(recipe) || (recipeWrapper = RECIPE_REGISTRY.getRecipeWrapper((Object)recipe, uid = PluginJEI.createUID(name, tier))) == null) continue;
                    RECIPE_REGISTRY.hideRecipe(recipeWrapper, uid);
                }
            }
        }
    }

    private boolean shouldHideRecipe(IArtisanRecipe recipe) {
        Collection<IRequirement> values = recipe.getRequirements().values();
        for (IRequirement requirement : values) {
            if (!requirement.shouldJEIHideOnLoad()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void on(ArtisanUpdateJEIRecipeVisibilityEvent event) {
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (RECIPE_REGISTRY == null) {
            return;
        }
        for (String name : ArtisanAPI.getWorktableNames()) {
            RecipeRegistry registry = ArtisanAPI.getWorktableRecipeRegistry(name);
            if (registry == null) continue;
            for (EnumTier tier : EnumTier.values()) {
                List<IArtisanRecipe> recipeList = registry.getRecipeListByTier(tier, new ArrayList<IArtisanRecipe>());
                String uid = PluginJEI.createUID(name, tier);
                for (IArtisanRecipe recipe : recipeList) {
                    IRecipeWrapper recipeWrapper = RECIPE_REGISTRY.getRecipeWrapper((Object)recipe, uid);
                    if (recipeWrapper == null) continue;
                    boolean shouldHide = recipe.isHidden();
                    if (!shouldHide) {
                        for (IRequirement requirement : recipe.getRequirements().values()) {
                            if (!requirement.shouldJEIHideOnUpdate()) continue;
                            shouldHide = true;
                            break;
                        }
                    }
                    if (shouldHide) {
                        RECIPE_REGISTRY.hideRecipe(recipeWrapper, uid);
                        continue;
                    }
                    RECIPE_REGISTRY.unhideRecipe(recipeWrapper, uid);
                }
            }
        }
    }

    public static String createUID(String name, EnumTier tier) {
        return "artisanworktables_" + name + "_" + tier.getName();
    }

    private ItemStack getWorktableAsItemStack(String name, EnumTier tier) {
        return this.getWorktableAsItemStack(EnumType.fromName(name), tier);
    }

    private ItemStack getWorktableAsItemStack(EnumType type, EnumTier tier) {
        switch (tier) {
            case WORKTABLE: {
                return new ItemStack((Block)ModuleWorktables.Blocks.WORKTABLE, 1, type.getMeta());
            }
            case WORKSTATION: {
                return new ItemStack((Block)ModuleWorktables.Blocks.WORKSTATION, 1, type.getMeta());
            }
            case WORKSHOP: {
                return new ItemStack((Block)ModuleWorktables.Blocks.WORKSHOP, 1, type.getMeta());
            }
        }
        throw new IllegalArgumentException("Unknown tier: " + (Object)((Object)tier));
    }
}

