/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker;

import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktables;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTActionAdd;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.IRecipeAdditionQueue;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.RecipeBuilderInternal;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.copy.EnumCopyPhase;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.copy.IRecipeBuilderCopyStrategyInternal;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.events.ActionApplyEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CTRecipeAdditionQueue
implements IRecipeAdditionQueue {
    private final List<RecipeBuilderInternal> recipeBuilderList = new ArrayList<RecipeBuilderInternal>();
    private final List<RecipeBuilderInternal> recipeBuilderWithCopyList = new ArrayList<RecipeBuilderInternal>();

    @Override
    public void offer(RecipeBuilderInternal recipeBuilder) {
        this.recipeBuilderList.add(recipeBuilder);
    }

    @Override
    public void offerWithCopy(RecipeBuilderInternal recipeBuilder) {
        this.recipeBuilderWithCopyList.add(recipeBuilder);
    }

    @SubscribeEvent
    public void on(ActionApplyEvent.Pre event) {
        this.doCopyForPhase(EnumCopyPhase.Pre);
        for (RecipeBuilderInternal builder : this.recipeBuilderList) {
            CraftTweaker.LATE_ACTIONS.add(new CTActionAdd(builder.getTableName(), builder));
        }
        this.recipeBuilderList.clear();
    }

    @SubscribeEvent
    public void on(ActionApplyEvent.Post event) {
        this.doCopyForPhase(EnumCopyPhase.Post);
        for (RecipeBuilderInternal builder : this.recipeBuilderList) {
            CraftTweakerAPI.apply((IAction)new CTActionAdd(builder.getTableName(), builder));
        }
        this.recipeBuilderList.clear();
        this.recipeBuilderWithCopyList.clear();
    }

    private void doCopyForPhase(EnumCopyPhase copyPhase) {
        for (RecipeBuilderInternal builder : this.recipeBuilderWithCopyList) {
            try {
                IRecipeBuilderCopyStrategyInternal recipeCopyStrategy = builder.getRecipeCopyStrategy();
                if (recipeCopyStrategy == null || recipeCopyStrategy.getCopyPhase() != copyPhase) continue;
                recipeCopyStrategy.apply(builder, this.recipeBuilderList);
            }
            catch (Exception e) {
                ModuleWorktables.LOG.error("", (Throwable)e);
            }
        }
    }
}

