/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.craftingtweaks;

import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.AWContainer;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.GuiContainerWorkshop;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.VanillaRecipeCache;
import java.util.List;
import javax.annotation.Nonnull;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.DefaultProviderV2;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingTweaksPlugin {
    public static void init() {
        CraftingTweaksAPI.registerProvider(AWContainer.class, (TweakProvider)new AWTweakProvider());
    }

    public static class AWTweakProvider
    implements TweakProvider<AWContainer> {
        private DefaultProviderV2 defaultProvider = CraftingTweaksAPI.createDefaultProviderV2();

        AWTweakProvider() {
        }

        @Nonnull
        public String getModId() {
            return "artisanworktables";
        }

        public boolean load() {
            return true;
        }

        public int getCraftingGridStart(EntityPlayer entityPlayer, AWContainer container, int id) {
            return container.slotIndexCraftingMatrixStart;
        }

        public int getCraftingGridSize(EntityPlayer entityPlayer, AWContainer container, int id) {
            return container.getTile().getTier() == EnumTier.WORKSHOP ? 25 : 9;
        }

        public void clearGrid(EntityPlayer entityPlayer, AWContainer container, int id, boolean forced) {
            this.defaultProvider.clearGrid((TweakProvider)this, id, entityPlayer, (Container)container, false, forced);
        }

        public void rotateGrid(EntityPlayer entityPlayer, AWContainer container, int id, boolean counterClockwise) {
            EnumTier tier = container.getTile().getTier();
            if (tier != EnumTier.WORKSHOP) {
                this.defaultProvider.rotateGrid((TweakProvider)this, id, entityPlayer, (Container)container, counterClockwise);
            }
        }

        public void balanceGrid(EntityPlayer entityPlayer, AWContainer container, int id) {
            this.defaultProvider.balanceGrid((TweakProvider)this, id, entityPlayer, (Container)container);
        }

        public void spreadGrid(EntityPlayer entityPlayer, AWContainer container, int id) {
            this.defaultProvider.spreadGrid((TweakProvider)this, id, entityPlayer, (Container)container);
        }

        public boolean canTransferFrom(EntityPlayer entityPlayer, AWContainer container, int id, Slot sourceSlot) {
            return this.defaultProvider.canTransferFrom(entityPlayer, (Container)container, sourceSlot);
        }

        public boolean transferIntoGrid(EntityPlayer entityPlayer, AWContainer container, int id, Slot sourceSlot) {
            return this.defaultProvider.transferIntoGrid((TweakProvider)this, id, entityPlayer, (Container)container, sourceSlot);
        }

        public ItemStack putIntoGrid(EntityPlayer entityPlayer, AWContainer container, int id, ItemStack itemStack, int index) {
            return this.defaultProvider.putIntoGrid((TweakProvider)this, id, entityPlayer, (Container)container, itemStack, index);
        }

        public IInventory getCraftMatrix(EntityPlayer entityPlayer, AWContainer container, int id) {
            return new VanillaRecipeCache.InventoryWrapper(container.getTile());
        }

        @SideOnly(value=Side.CLIENT)
        public void initGui(GuiContainer guiContainer, List<GuiButton> buttonList) {
            int buttonY;
            int buttonX;
            if (!(guiContainer instanceof GuiContainerWorkshop)) {
                buttonX = -10;
                buttonY = 17;
                buttonList.add(CraftingTweaksAPI.createRotateButtonRelative((int)0, (GuiContainer)guiContainer, (int)buttonX, (int)buttonY));
            }
            buttonX = -10;
            buttonY = 35;
            buttonList.add(CraftingTweaksAPI.createBalanceButtonRelative((int)0, (GuiContainer)guiContainer, (int)buttonX, (int)buttonY));
            buttonX = -10;
            buttonY = 53;
            buttonList.add(CraftingTweaksAPI.createClearButtonRelative((int)0, (GuiContainer)guiContainer, (int)buttonX, (int)buttonY));
        }
    }
}

