/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.api.internal.recipe;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.recipe.IToolHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ToolEntry {
    private static final ThreadLocal<List<ItemStack>> TOOL_CACHE = ThreadLocal.withInitial(ArrayList::new);
    private final IArtisanIngredient tool;
    private final ItemStack[] toolItemStacks;
    private final int damage;

    private static ItemStack cache(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack;
        }
        List<ItemStack> list = TOOL_CACHE.get();
        for (ItemStack stack : list) {
            if (stack.func_77973_b() != itemStack.func_77973_b() || stack.func_77960_j() != itemStack.func_77960_j()) continue;
            return stack;
        }
        list.add(itemStack);
        return itemStack;
    }

    public ToolEntry(IArtisanIngredient tool, int damage) {
        this.tool = tool;
        this.damage = damage;
        IArtisanItemStack[] toolMatchingStacks = tool.getMatchingStacks();
        this.toolItemStacks = new ItemStack[toolMatchingStacks.length];
        for (int i = 0; i < toolMatchingStacks.length; ++i) {
            this.toolItemStacks[i] = ToolEntry.cache(toolMatchingStacks[i].toItemStack());
        }
    }

    public ItemStack[] getToolStacks() {
        return this.toolItemStacks;
    }

    public IArtisanIngredient getTool() {
        return this.tool;
    }

    public int getDamage() {
        return this.damage;
    }

    public boolean matches(IToolHandler handler, ItemStack tool) {
        for (int i = 0; i < this.toolItemStacks.length; ++i) {
            if (!handler.matches(tool, this.toolItemStacks[i])) continue;
            return true;
        }
        return false;
    }
}

