/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.proxy;

import ejektaflex.bountiful.ContentRegistry;
import ejektaflex.bountiful.api.BountifulAPI;
import ejektaflex.bountiful.api.data.IBountyData;
import ejektaflex.bountiful.api.enum.EnumBountyRarity;
import ejektaflex.bountiful.item.ItemBounty;
import ejektaflex.bountiful.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u0010"}, d2={"Lejektaflex/bountiful/proxy/ClientProxy;", "Lejektaflex/bountiful/proxy/CommonProxy;", "()V", "registerBountyRenderer", "", "item", "Lnet/minecraft/item/Item;", "meta", "", "id", "", "registerItemRenderer", "registerModels", "event", "Lnet/minecraftforge/client/event/ModelRegistryEvent;", "BountyItemDefinition", "Bountiful"})
public final class ClientProxy
extends CommonProxy {
    private final void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("bountiful:" + id, "inventory"));
    }

    /*
     * WARNING - void declaration
     */
    private final void registerBountyRenderer(Item item, int meta, String id) {
        void $receiver$iv$iv;
        EnumBountyRarity[] $receiver$iv;
        EnumBountyRarity[] enumBountyRarityArray = $receiver$iv = EnumBountyRarity.values();
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var9_7 = $receiver$iv$iv;
        int n = ((void)var9_7).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void it;
            String string2;
            void item$iv$iv;
            void var13_11 = item$iv$iv = var9_7[i];
            Collection collection = destination$iv$iv;
            String string3 = string2 = it.name();
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            collection.add(string);
        }
        for (String rarity : (List)destination$iv$iv) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("bountiful:" + id + '-' + rarity)});
        }
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new BountyItemDefinition(id));
    }

    @SubscribeEvent
    public final void registerModels(@NotNull ModelRegistryEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Iterable $receiver$iv = ContentRegistry.INSTANCE.getItems();
        for (Object element$iv : $receiver$iv) {
            Item it = (Item)element$iv;
            if (it instanceof ItemBounty) {
                ResourceLocation resourceLocation = ((ItemBounty)it).getRegistryName();
                if (resourceLocation == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"it.registryName!!");
                String string = resourceLocation.func_110623_a();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.registryName!!.path");
                this.registerBountyRenderer(it, 0, string);
                continue;
            }
            ResourceLocation resourceLocation = it.getRegistryName();
            if (resourceLocation == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"it.registryName!!");
            String string = resourceLocation.func_110623_a();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.registryName!!.path");
            this.registerItemRenderer(it, 0, string);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lejektaflex/bountiful/proxy/ClientProxy$BountyItemDefinition;", "Lnet/minecraft/client/renderer/ItemMeshDefinition;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getModelLocation", "Lnet/minecraft/client/renderer/block/model/ModelResourceLocation;", "stack", "Lnet/minecraft/item/ItemStack;", "Bountiful"})
    private static final class BountyItemDefinition
    implements ItemMeshDefinition {
        @NotNull
        private final String id;

        @NotNull
        public ModelResourceLocation func_178113_a(@NotNull ItemStack stack) {
            ModelResourceLocation modelResourceLocation;
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            String locid = "bountiful:" + this.id;
            try {
                IBountyData data = BountifulAPI.INSTANCE.toBountyData(stack);
                EnumBountyRarity rarity = EnumBountyRarity.Companion.getRarityFromInt(data.getRarity());
                String string = rarity.name();
                StringBuilder stringBuilder = new StringBuilder().append(locid).append('-');
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                String string5 = "inventory";
                String string6 = stringBuilder.append(string4).toString();
                modelResourceLocation = new ModelResourceLocation(string6, string5);
            }
            catch (Exception e) {
                String string = EnumBountyRarity.Common.name();
                StringBuilder stringBuilder = new StringBuilder().append(locid).append('-');
                String string7 = string;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
                String string9 = string8;
                String string10 = "inventory";
                String string11 = stringBuilder.append(string9).toString();
                modelResourceLocation = new ModelResourceLocation(string11, string10);
            }
            return modelResourceLocation;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public BountyItemDefinition(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.id = id;
        }
    }
}

