/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.ModConfigs;
import com.ferreusveritas.dynamictreesphc.blocks.BlockBranchPamPaper;
import com.ferreusveritas.dynamictreesphc.trees.TreeFamilyPHC;
import com.pam.harvestcraft.blocks.FruitRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreePaperBark
extends TreeFamilyPHC {
    public static final String speciesName = "paperbark";
    public static BlockBranchPamPaper paperbarkBranch;
    public static BlockBranchPamPaper paperbarkCutBranch;

    public TreePaperBark() {
        super(new ResourceLocation("dynamictreesphc", speciesName));
        this.setPrimitiveLog(FruitRegistry.getLog((String)speciesName).func_176223_P());
        ModBlocks.paperBarkLeavesProperties.setTree((TreeFamily)this);
    }

    public void createSpecies() {
        this.setCommonSpecies(new TreePaperBarkSpecies(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        paperbarkCutBranch = new BlockBranchPamPaper(this.getName() + "cutbranch", speciesName, ModConfigs.treePaperbarkYieldPerLog, true);
        paperbarkCutBranch.setFamily(this);
        blockList.add((Block)paperbarkCutBranch);
        return super.getRegisterableBlocks(blockList);
    }

    public BlockBranch createBranch() {
        paperbarkBranch = new BlockBranchPamPaper(this.getName() + "branch", speciesName, ModConfigs.treePaperbarkYieldPerLog, false);
        return paperbarkBranch;
    }

    public class TreePaperBarkSpecies
    extends Species {
        public TreePaperBarkSpecies(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, (ILeavesProperties)ModBlocks.paperBarkLeavesProperties);
            this.setBasicGrowingParameters(0.2f, 16.0f, 4, 5, 1.0f);
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        public boolean useDefaultWailaBody() {
            return false;
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
        }
    }
}

