/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.blocks.BlockPamFruitPalm;
import com.ferreusveritas.dynamictreesphc.dropcreators.FeatureGenFruitPalm;
import com.ferreusveritas.dynamictreesphc.trees.SpeciesPalm;
import com.ferreusveritas.dynamictreesphc.trees.TreePalm;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import net.minecraft.block.SoundType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreeDragonfruit
extends TreePalm {
    public TreeDragonfruit() {
        super(new ResourceLocation("dynamictreesphc", "dragonfruit"));
        ModBlocks.dragonfruitLeavesProperties.setTree((TreeFamily)this);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesDragonfruit(this));
    }

    public class SpeciesDragonfruit
    extends SpeciesPalm {
        public SpeciesDragonfruit(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, (ILeavesProperties)ModBlocks.dragonfruitLeavesProperties, "dragonfruit", BlockPamSapling.SaplingType.WARM);
        }

        @Override
        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) - (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 2);
        }

        @Override
        public void setFruitBlock(BlockFruit fruitBlock) {
            this.fruitBlockState = fruitBlock.func_176223_P();
            FeatureGenFruitPalm featureGen = new FeatureGenFruitPalm(fruitBlock, 2, fruitBlock instanceof BlockPamFruitPalm);
            featureGen.setFruitingRadius(this.fruitingRadius);
            this.addGenFeature((IGenFeature)featureGen);
        }

        public boolean canBoneMeal() {
            return false;
        }

        @Override
        public ResourceLocation getSaplingName() {
            return new ResourceLocation("dynamictreesphc", "dragonfruit");
        }

        public SoundType getSaplingSound() {
            return SoundType.field_185854_g;
        }

        public AxisAlignedBB getSaplingBoundingBox() {
            return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625);
        }

        @Override
        protected void fruitTreeDefaults(String name) {
            this.setBasicGrowingParameters(1.0f, 2.0f, 1, 4, 0.2f, 2);
        }

        @Override
        public void addJoCodes() {
            this.joCodeStore.addCodesFromFile((Species)this, "assets/" + this.getRegistryName().func_110624_b() + "/trees/dragonfruit.txt");
        }
    }
}

