/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.dropcreators;

import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictreesphc.dropcreators.NodeDripSyrup;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FeatureGenSyrup
implements IPostGrowFeature {
    private final float baseSyrupChance;
    private final float outOfSeasonSyrupChance;

    public FeatureGenSyrup(float baseSyrupChance, float outOfSeasonSyrupChance) {
        this.baseSyrupChance = baseSyrupChance;
        this.outOfSeasonSyrupChance = outOfSeasonSyrupChance;
    }

    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, Species species, int soilLife, boolean natural) {
        if (natural && TreeHelper.getRadius((IBlockAccess)world, (BlockPos)treePos) >= 7 && (double)world.field_73012_v.nextFloat() <= this.getSyrupChance(world, rootPos)) {
            this.dripSyrup(world, rootPos);
        }
        return false;
    }

    public double getSyrupChance(World world, BlockPos pos) {
        Float season = SeasonHelper.getSeasonValue((World)world, (BlockPos)pos);
        return MathHelper.func_76131_a((float)(season == null || SeasonHelper.isSeasonBetween((float)season.floatValue(), (float)3.5f, (float)0.5f) ? this.baseSyrupChance : this.outOfSeasonSyrupChance), (float)0.0f, (float)1.0f);
    }

    private void dripSyrup(World world, BlockPos rootPos) {
        TreeHelper.startAnalysisFromRoot((World)world, (BlockPos)rootPos, (MapSignal)new MapSignal(new INodeInspector[]{new NodeDripSyrup()}));
    }
}

