/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.compat;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.compat.WailaBranchHandler;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeNetVolume;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictreesphc.blocks.BlockBranchPamSpecial;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WailaBranchHandlerPHC
extends WailaBranchHandler {
    private BlockPos lastPos = BlockPos.field_177992_a;
    private Species lastSpecies = Species.NULLSPECIES;
    private float lastVolume = 0.0f;

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        tooltip.clear();
        NBTTagCompound nbtData = accessor.getNBTData();
        BlockPos pos = accessor.getPosition();
        Species species = Species.NULLSPECIES;
        if (nbtData.func_74764_b("species")) {
            species = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation(nbtData.func_74779_i("species")));
        }
        if (species == Species.NULLSPECIES && this.lastPos.equals((Object)pos)) {
            species = this.lastSpecies;
        }
        if (species == Species.NULLSPECIES) {
            species = this.getWailaSpecies(accessor.getWorld(), pos);
        }
        if (!this.lastPos.equals((Object)pos)) {
            this.lastVolume = this.getTreeVolume(accessor.getWorld(), pos);
        }
        this.lastSpecies = species;
        this.lastPos = pos;
        if (species != Species.NULLSPECIES) {
            tooltip.add("Species: " + species.getRegistryName().func_110623_a());
            StringBuilder renderString = new StringBuilder();
            ItemStack seedStack = species.getSeedStack(1);
            String seedName = seedStack.func_77973_b().getRegistryName().toString();
            renderString.append(SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", seedName, String.valueOf(1), String.valueOf(seedStack.func_77952_i())}));
            if (this.lastVolume > 0.0f) {
                boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)accessor.getPlayer().func_184614_ca()) >= 1;
                BlockBranch log = TreeHelper.getBranch((Block)accessor.getBlock());
                if (log instanceof BlockBranchPamSpecial) {
                    List<ItemStack> logs = ((BlockBranchPamSpecial)TreeHelper.getBranch((Block)accessor.getBlock())).getLogDrops(accessor.getWorld(), accessor.getPosition(), species, this.lastVolume, silkTouch);
                    for (ItemStack logStack : logs) {
                        if (logStack.func_190926_b()) continue;
                        String stickName = logStack.func_77973_b().getRegistryName().toString();
                        renderString.append(SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", stickName, String.valueOf(logStack.func_190916_E()), String.valueOf(logStack.func_77952_i())}));
                    }
                }
            }
            tooltip.add(renderString.toString());
        }
        return tooltip;
    }

    private float getTreeVolume(World world, BlockPos pos) {
        BlockTrunkShell.ShellMuse muse;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockTrunkShell && (muse = ((BlockTrunkShell)block).getMuse((IBlockAccess)world, pos)) != null) {
            state = muse.state;
            block = state.func_177230_c();
            pos = muse.pos;
        }
        if (block instanceof BlockBranch) {
            BlockBranch branch = (BlockBranch)block;
            NodeNetVolume volumeSum = new NodeNetVolume();
            branch.analyse(state, world, pos, null, new MapSignal(new INodeInspector[]{volumeSum}));
            return volumeSum.getVolume() * ModConfigs.treeHarvestMultiplier;
        }
        return 0.0f;
    }

    private Species getWailaSpecies(World world, BlockPos pos) {
        BlockTrunkShell.ShellMuse muse;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockTrunkShell && (muse = ((BlockTrunkShell)block).getMuse((IBlockAccess)world, pos)) != null) {
            state = muse.state;
            block = state.func_177230_c();
            pos = muse.pos;
        }
        if (block instanceof BlockBranch) {
            BlockBranch branch = (BlockBranch)state.func_177230_c();
            Species species = TreeHelper.getExactSpecies((World)world, (BlockPos)pos);
            if (species == Species.NULLSPECIES) {
                species = branch.getFamily().getCommonSpecies();
            }
            return species;
        }
        return Species.NULLSPECIES;
    }
}

