/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.blocks;

import com.ferreusveritas.dynamictrees.ModTabs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.ModConstants;
import com.pam.harvestcraft.blocks.FruitRegistry;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockVinePassionfruit
extends BlockVine {
    private static final float baseFruitingChance = 0.002f;
    private static final float fruitGrowChance = 0.2f;
    private static final int maxLength = 3;

    public BlockVinePassionfruit(ResourceLocation name) {
        this.setRegistryName(name);
        this.func_149663_c(name.toString());
        this.func_149647_a(ModTabs.dynamicTreesTab);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.4f);
    }

    private float getFruitingChance(World world, BlockPos pos) {
        float fruitFactor = SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)ModConstants.fruitOffset.get("passionfruit").floatValue());
        return 0.002f * Math.max(fruitFactor + 0.25f, 1.0f);
    }

    private void changeVineWithProperties(World world, BlockPos pos, IBlockState stateWithWantedProperties) {
        this.changeVineWithProperties(world, pos, this.getStateFromAge(0), stateWithWantedProperties);
    }

    private void changeVineWithProperties(World world, BlockPos pos, IBlockState baseState, IBlockState stateWithWantedProperties) {
        IBlockState state = baseState.func_177226_a((IProperty)field_176277_a, stateWithWantedProperties.func_177229_b((IProperty)field_176277_a)).func_177226_a((IProperty)field_176273_b, stateWithWantedProperties.func_177229_b((IProperty)field_176273_b)).func_177226_a((IProperty)field_176280_O, stateWithWantedProperties.func_177229_b((IProperty)field_176280_O)).func_177226_a((IProperty)field_176279_N, stateWithWantedProperties.func_177229_b((IProperty)field_176279_N)).func_177226_a((IProperty)field_176278_M, stateWithWantedProperties.func_177229_b((IProperty)field_176278_M));
        world.func_180501_a(pos, state, 2);
    }

    private boolean recheckGrownSides(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState iblockstate = state;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate1;
            PropertyBool propertybool = BlockVinePassionfruit.func_176267_a((EnumFacing)enumfacing);
            if (!((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue() || this.func_193395_a(worldIn, pos, enumfacing.func_176734_d()) || (iblockstate1 = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c() == this && ((Boolean)iblockstate1.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
            state = state.func_177226_a((IProperty)propertybool, (Comparable)Boolean.valueOf(false));
        }
        if (BlockVinePassionfruit.func_176268_d((IBlockState)state) == 0) {
            return false;
        }
        if (iblockstate != state) {
            worldIn.func_180501_a(pos, state, 2);
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && !this.recheckGrownSides(worldIn, pos, state)) {
            this.spawnItemFruitIfRipe(worldIn, pos);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextInt(4) == 0 && worldIn.func_175697_a(pos, 4)) {
            int vineLimit = 5;
            boolean tooManyVinesAround = false;
            block0: for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        if (!(worldIn.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c() instanceof BlockVinePassionfruit) || --vineLimit > 0) continue;
                        tooManyVinesAround = true;
                        break block0;
                    }
                }
            }
            EnumFacing randomDir = EnumFacing.func_176741_a((Random)rand);
            BlockPos upPos = pos.func_177984_a();
            if (randomDir == EnumFacing.UP && pos.func_177956_o() < 255 && worldIn.func_175623_d(upPos)) {
                IBlockState newUpState = state;
                for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
                    if (rand.nextBoolean() && this.func_193395_a(worldIn, upPos, dir.func_176734_d())) {
                        newUpState = newUpState.func_177226_a((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)dir), (Comparable)Boolean.valueOf(true));
                        continue;
                    }
                    newUpState = newUpState.func_177226_a((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)dir), (Comparable)Boolean.valueOf(false));
                }
                if (((Boolean)newUpState.func_177229_b((IProperty)field_176273_b)).booleanValue() || ((Boolean)newUpState.func_177229_b((IProperty)field_176278_M)).booleanValue() || ((Boolean)newUpState.func_177229_b((IProperty)field_176279_N)).booleanValue() || ((Boolean)newUpState.func_177229_b((IProperty)field_176280_O)).booleanValue()) {
                    this.changeVineWithProperties(worldIn, upPos, newUpState);
                }
            } else if (randomDir.func_176740_k().func_176722_c() && !((Boolean)state.func_177229_b((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)randomDir))).booleanValue()) {
                if (!tooManyVinesAround) {
                    BlockPos randomDirPos = pos.func_177972_a(randomDir);
                    IBlockState randomDirState = worldIn.func_180495_p(randomDirPos);
                    Block sideBlock = randomDirState.func_177230_c();
                    if (sideBlock.isAir(randomDirState, (IBlockAccess)worldIn, randomDirPos)) {
                        EnumFacing randomDirRight = randomDir.func_176746_e();
                        EnumFacing randomDirLeft = randomDir.func_176735_f();
                        boolean flag1 = (Boolean)state.func_177229_b((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)randomDirRight));
                        boolean flag2 = (Boolean)state.func_177229_b((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)randomDirLeft));
                        BlockPos randomRightPos = randomDirPos.func_177972_a(randomDirRight);
                        BlockPos randomLeftPos = randomDirPos.func_177972_a(randomDirLeft);
                        if (flag1 && this.func_193395_a(worldIn, randomRightPos.func_177972_a(randomDirRight), randomDirRight)) {
                            this.changeVineWithProperties(worldIn, randomDirPos, this.func_176223_P().func_177226_a((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)randomDirRight), (Comparable)Boolean.valueOf(true)));
                        } else if (flag2 && this.func_193395_a(worldIn, randomLeftPos.func_177972_a(randomDirLeft), randomDirLeft)) {
                            this.changeVineWithProperties(worldIn, randomDirPos, this.func_176223_P().func_177226_a((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)randomDirLeft), (Comparable)Boolean.valueOf(true)));
                        } else if (flag1 && worldIn.func_175623_d(randomRightPos) && this.func_193395_a(worldIn, randomRightPos, randomDir)) {
                            this.changeVineWithProperties(worldIn, randomRightPos, this.func_176223_P().func_177226_a((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)randomDir.func_176734_d()), (Comparable)Boolean.valueOf(true)));
                        } else if (flag2 && worldIn.func_175623_d(randomLeftPos) && this.func_193395_a(worldIn, randomLeftPos, randomDir)) {
                            this.changeVineWithProperties(worldIn, randomLeftPos, this.func_176223_P().func_177226_a((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)randomDir.func_176734_d()), (Comparable)Boolean.valueOf(true)));
                        }
                    } else if (randomDirState.func_193401_d((IBlockAccess)worldIn, randomDirPos, randomDir) == BlockFaceShape.SOLID) {
                        this.changeVineWithProperties(worldIn, pos, state, state.func_177226_a((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)randomDir), (Comparable)Boolean.valueOf(true)));
                    }
                }
            } else if (pos.func_177956_o() > 1 && !(worldIn.func_180495_p(pos.func_177981_b(3)).func_177230_c() instanceof BlockVinePassionfruit)) {
                BlockPos downPos = pos.func_177977_b();
                IBlockState downState = worldIn.func_180495_p(downPos);
                if (downState.func_185904_a() == Material.field_151579_a) {
                    IBlockState iblockstate1 = state;
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        if (!rand.nextBoolean()) continue;
                        iblockstate1 = iblockstate1.func_177226_a((IProperty)BlockVinePassionfruit.func_176267_a((EnumFacing)enumfacing), (Comparable)Boolean.valueOf(false));
                    }
                    if (((Boolean)iblockstate1.func_177229_b((IProperty)field_176273_b)).booleanValue() || ((Boolean)iblockstate1.func_177229_b((IProperty)field_176278_M)).booleanValue() || ((Boolean)iblockstate1.func_177229_b((IProperty)field_176279_N)).booleanValue() || ((Boolean)iblockstate1.func_177229_b((IProperty)field_176280_O)).booleanValue()) {
                        this.changeVineWithProperties(worldIn, downPos, iblockstate1);
                    }
                } else if (downState.func_177230_c() instanceof BlockVinePassionfruit) {
                    IBlockState newDownState = downState;
                    for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
                        PropertyBool propertySide = BlockVinePassionfruit.func_176267_a((EnumFacing)dir);
                        if (!rand.nextBoolean() || !((Boolean)state.func_177229_b((IProperty)propertySide)).booleanValue()) continue;
                        newDownState = newDownState.func_177226_a((IProperty)propertySide, (Comparable)Boolean.valueOf(true));
                    }
                    if (((Boolean)newDownState.func_177229_b((IProperty)field_176273_b)).booleanValue() || ((Boolean)newDownState.func_177229_b((IProperty)field_176278_M)).booleanValue() || ((Boolean)newDownState.func_177229_b((IProperty)field_176279_N)).booleanValue() || ((Boolean)newDownState.func_177229_b((IProperty)field_176280_O)).booleanValue()) {
                        this.changeVineWithProperties(worldIn, downPos, downState, newDownState);
                    }
                }
            }
        }
        this.growFruit(worldIn, pos, state, rand);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        Integer age = this.getAgeFromState(worldIn.func_180495_p(pos));
        return age != null && age == 0;
    }

    protected void growFruit(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        Integer age = this.getAgeFromState(state);
        if (age == null) {
            return;
        }
        if (age == 0 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextFloat() <= this.getFruitingChance(worldIn, pos) ? 1 : 0) != 0) || age > 0 && age < 4 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextFloat() <= 0.2f ? 1 : 0) != 0)) {
            int fruitFoundAround = 0;
            for (EnumFacing dir : EnumFacing.values()) {
                Integer sideAge = this.getAgeFromState(worldIn.func_180495_p(pos.func_177972_a(dir)));
                if (sideAge == null || sideAge <= 0) continue;
                ++fruitFoundAround;
            }
            if (fruitFoundAround >= 2) {
                this.changeVineWithProperties(worldIn, pos, this.getStateFromAge(0), state);
                return;
            }
            this.changeVineWithProperties(worldIn, pos, this.getStateFromAge(age + 1), state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    private Integer getAgeFromState(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == ModBlocks.passionfruitVine) {
            return 0;
        }
        if (block == ModBlocks.passionfruitVine0) {
            return 1;
        }
        if (block == ModBlocks.passionfruitVine1) {
            return 2;
        }
        if (block == ModBlocks.passionfruitVine2) {
            return 3;
        }
        if (block == ModBlocks.passionfruitVine3) {
            return 4;
        }
        return null;
    }

    @Nonnull
    private IBlockState getStateFromAge(int age) {
        switch (age) {
            case 0: {
                return ModBlocks.passionfruitVine.func_176223_P();
            }
            case 1: {
                return ModBlocks.passionfruitVine0.func_176223_P();
            }
            case 2: {
                return ModBlocks.passionfruitVine1.func_176223_P();
            }
            case 3: {
                return ModBlocks.passionfruitVine2.func_176223_P();
            }
            case 4: {
                return ModBlocks.passionfruitVine3.func_176223_P();
            }
        }
        throw new IllegalArgumentException();
    }

    private ItemStack getFruit() {
        return new ItemStack(FruitRegistry.getFood((String)"passionfruit"));
    }

    private boolean spawnItemFruitIfRipe(World world, BlockPos pos) {
        return this.spawnItemFruitIfRipe(world, pos, world.func_180495_p(pos));
    }

    private boolean spawnItemFruitIfRipe(World world, BlockPos pos, IBlockState state) {
        Integer age = this.getAgeFromState(state);
        if (!world.field_72995_K && age != null && age == 4) {
            world.func_72838_d((Entity)new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), this.getFruit()));
            return true;
        }
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.spawnItemFruitIfRipe(worldIn, pos)) {
            this.changeVineWithProperties(worldIn, pos, state);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemShears) {
            return 1.0f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public boolean func_193395_a(World world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return BlockVinePassionfruit.isAcceptableNeighbor(world, pos.func_177972_a(facing.func_176734_d()), facing) && (block == Blocks.field_150350_a || block instanceof BlockVinePassionfruit || TreeHelper.isBranch((Block)block) || BlockVinePassionfruit.isAcceptableNeighbor(world, pos.func_177984_a(), EnumFacing.UP));
    }

    public static boolean isAcceptableNeighbor(World world, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = world.func_180495_p(pos);
        if (TreeHelper.isBranch((IBlockState)iblockstate) && TreeHelper.getRadius((IBlockAccess)world, (BlockPos)pos) == 8) {
            return true;
        }
        return iblockstate.func_193401_d((IBlockAccess)world, pos, facing) == BlockFaceShape.SOLID && !BlockVinePassionfruit.func_193397_e((Block)iblockstate.func_177230_c());
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Integer age = this.getAgeFromState(state);
        if (age != null && age == 0) {
            return new ItemStack((Block)ModBlocks.passionfruitVine);
        }
        return this.getFruit();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        LinkedList<ItemStack> stack = new LinkedList<ItemStack>();
        stack.add(new ItemStack((Block)ModBlocks.passionfruitVine));
        Integer age = this.getAgeFromState(world.func_180495_p(pos));
        if (age != null && age == 4) {
            stack.add(this.getFruit());
        }
        return stack;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        this.spawnItemFruitIfRipe(worldIn, pos, state);
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(Objects.requireNonNull(StatList.func_188055_a((Block)this)));
            BlockVinePassionfruit.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)ModBlocks.passionfruitVine));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }
}

