/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.blocks.BlockMapleSpileBucket;
import com.pam.harvestcraft.blocks.FruitRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMapleSpile
extends BlockHorizontal {
    public static final PropertyBool FILLED = PropertyBool.func_177716_a((String)"filled");
    private static final double chanceToBreak = 0.02;
    protected static final AxisAlignedBB SPILE_EAST_AABB = new AxisAlignedBB(-0.0625, 0.625, 0.4375, 0.375, 0.75, 0.5625);
    protected static final AxisAlignedBB SPILE_WEST_AABB = new AxisAlignedBB(0.625, 0.625, 0.4375, 1.0625, 0.75, 0.5625);
    protected static final AxisAlignedBB SPILE_NORTH_AABB = new AxisAlignedBB(0.4375, 0.625, 0.625, 0.5625, 0.75, 1.0625);
    protected static final AxisAlignedBB SPILE_SOUTH_AABB = new AxisAlignedBB(0.4375, 0.625, -0.0625, 0.5625, 0.75, 0.375);

    public BlockMapleSpile(ResourceLocation name) {
        super(Material.field_151573_f);
        this.defaultState();
        this.setRegistryName(name);
        this.func_149663_c(name.toString());
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.5f);
        this.func_149675_a(true);
    }

    protected void defaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FILLED, field_185512_D});
    }

    public IBlockState func_176203_a(int meta) {
        boolean isFilled = meta >= 8;
        EnumFacing face = EnumFacing.field_176754_o[meta % 4];
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)face.func_176734_d()).func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(isFilled));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d().func_176736_b() + ((Boolean)state.func_177229_b((IProperty)FILLED) != false ? 8 : 0);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.dropBlock(worldIn, pos, state);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177228_b().containsKey((Object)FILLED)) {
            if (!((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)FILLED)).booleanValue() && playerIn.func_70093_af()) {
                worldIn.func_175698_g(pos);
                if ((double)worldIn.field_73012_v.nextFloat() <= 0.02) {
                    worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    playerIn.func_191521_c(new ItemStack(Items.field_191525_da));
                } else {
                    worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    playerIn.func_191521_c(new ItemStack(Items.field_151042_j));
                }
                return true;
            }
            if (playerIn.func_184614_ca().func_77973_b() == Items.field_151133_ar) {
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
                worldIn.func_175656_a(pos, ModBlocks.mapleSpileWithBucket.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)dir).func_177226_a((IProperty)BlockMapleSpileBucket.FILLING, (Comparable)Integer.valueOf((Boolean)state.func_177229_b((IProperty)FILLED) != false ? 1 : 0)));
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184614_ca().func_190918_g(1);
                }
                return true;
            }
        }
        if (this.giveSyrup(worldIn, pos, state, playerIn)) {
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    protected boolean giveSyrup(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Boolean)state.func_177229_b((IProperty)FILLED)).booleanValue()) {
            if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
                ItemStack drop = new ItemStack(FruitRegistry.getLog((String)"maple").getFruitItem());
                player.func_191521_c(drop);
            }
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.dropBlock(worldIn, pos, state);
        }
    }

    protected void dropBlock(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        BlockMapleSpile.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_191525_da));
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.func_184812_l_()) {
            BlockMapleSpile.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_191525_da));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos offsetPos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d());
        IBlockState offsetState = worldIn.func_180495_p(offsetPos);
        if (TreeHelper.isBranch((IBlockState)offsetState)) {
            BlockBranch branch = TreeHelper.getBranch((IBlockState)offsetState);
            return branch.getFamily().getPrimitiveLog().func_177230_c() == FruitRegistry.getLog((String)"maple") && branch.getRadius(offsetState) >= 7;
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Items.field_151042_j);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
            case SOUTH: {
                return SPILE_SOUTH_AABB;
            }
            default: {
                return SPILE_NORTH_AABB;
            }
            case WEST: {
                return SPILE_WEST_AABB;
            }
            case EAST: 
        }
        return SPILE_EAST_AABB;
    }
}

