/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.blocks;

import com.ferreusveritas.dynamictrees.ModTabs;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeTwinkle;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.ModItems;
import com.ferreusveritas.dynamictreesphc.blocks.BlockVinePassionfruit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDynamicSaplingPassionfruit
extends Block {
    public BlockDynamicSaplingPassionfruit(ResourceLocation name) {
        super(Material.field_151584_j);
        this.setRegistryName(name);
        this.func_149663_c(name.toString());
        this.func_149647_a(ModTabs.dynamicTreesTab);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
    }

    public static boolean canSaplingStay(World world, BlockPos pos) {
        boolean flatSide = false;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            if (!BlockVinePassionfruit.isAcceptableNeighbor(world, pos.func_177972_a(dir.func_176734_d()), dir)) continue;
            flatSide = true;
        }
        Species oak = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oak"));
        return flatSide && world.func_175623_d(pos.func_177984_a()) && oak.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()));
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return BlockDynamicSaplingPassionfruit.canSaplingStay(world, pos);
    }

    public boolean transitionToTree(World world, BlockPos pos) {
        boolean n = false;
        boolean s = false;
        boolean e = false;
        boolean w = false;
        block5: for (EnumFacing dir : EnumFacing.field_176754_o) {
            if (!BlockVinePassionfruit.isAcceptableNeighbor(world, pos.func_177972_a(dir), dir.func_176734_d())) continue;
            switch (dir) {
                default: {
                    n = true;
                    continue block5;
                }
                case SOUTH: {
                    s = true;
                    continue block5;
                }
                case EAST: {
                    e = true;
                    continue block5;
                }
                case WEST: {
                    w = true;
                }
            }
        }
        world.func_175656_a(pos, ModBlocks.passionfruitVine.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(n)).func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(s)).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(e)).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(w)));
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77960_j() == 15) {
            this.grow(world, world.field_73012_v, pos, state);
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            NodeTwinkle.spawnParticles((World)world, (EnumParticleTypes)EnumParticleTypes.VILLAGER_HAPPY, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p(), (int)8, (Random)world.field_73012_v);
            return true;
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.grow(world, rand, pos, state);
    }

    public void grow(World world, Random rand, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(world, pos, state)) {
            this.transitionToTree(world, pos);
        } else {
            this.dropBlock(world, state, pos);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos, state)) {
            this.dropBlock(world, state, pos);
        }
    }

    protected void dropBlock(World world, IBlockState state, BlockPos pos) {
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        drops.add((Object)new ItemStack((Item)ModItems.passionfruitSeed));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ModItems.passionfruitSeed);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

