/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictreesphc.ModConstants;
import com.ferreusveritas.dynamictreesphc.ModItems;
import com.ferreusveritas.dynamictreesphc.ModTrees;
import com.ferreusveritas.dynamictreesphc.trees.SpeciesFruit;
import com.pam.harvestcraft.blocks.FruitRegistry;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class ModRecipes {
    public static void register(IForgeRegistry<IRecipe> registry) {
        ModTrees.phcFruitSpecies.values().stream().filter(species -> !new ResourceLocation("dynamictreesphc", "spiderweb").equals((Object)species.getRegistryName())).forEach(ModRecipes::speciesRecipes);
        for (String name : new String[]{"cinnamon", "maple", "paperbark"}) {
            ModRecipes.speciesRecipes(TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesphc", name)));
        }
        Species appleSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "apple"));
        ItemStack appleSapling = new ItemStack((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation("harvestcraft", "apple_sapling"))));
        com.ferreusveritas.dynamictrees.ModRecipes.createDirtBucketExchangeRecipes((ItemStack)appleSapling, (ItemStack)appleSpecies.getSeedStack(1), (boolean)false, (String)"seedfromsapling", (ResourceLocation)new ResourceLocation("dynamictreesphc", "apple"));
        Species peppercornSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesphc", "peppercorn"));
        ItemStack peppercornSapling = new ItemStack((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation("harvestcraft", "peppercorn_sapling"))));
        com.ferreusveritas.dynamictrees.ModRecipes.createDirtBucketExchangeRecipesWithFruit((ItemStack)peppercornSapling, (ItemStack)peppercornSpecies.getSeedStack(1), (ItemStack)new ItemStack((Item)ModItems.ripePeppercorn), (boolean)true, (String)"ripe_seed", (boolean)false);
        Species spiderwebSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesphc", "spiderweb"));
        ItemStack spiderwebSapling = new ItemStack((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation("harvestcraft", "spiderweb_sapling"))));
        com.ferreusveritas.dynamictrees.ModRecipes.createDirtBucketExchangeRecipes((ItemStack)spiderwebSapling, (ItemStack)spiderwebSpecies.getSeedStack(1), (boolean)true);
        ItemStack passionfruitSeed = new ItemStack((Item)ModItems.passionfruitSeed);
        ItemStack passionfruit = new ItemStack(FruitRegistry.getFood((String)"passionfruit"));
        ItemStack passionfruitSapling = new ItemStack((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation("harvestcraft", "passionfruit_sapling"))));
        ItemStack passionfruitVine = new ItemStack(ModItems.passionfruitVine);
        com.ferreusveritas.dynamictrees.ModRecipes.createDirtBucketExchangeRecipesWithFruit((ItemStack)passionfruitSapling, (ItemStack)passionfruitSeed, (ItemStack)passionfruit, (boolean)true, (String)"seedfromsapling", (ResourceLocation)new ResourceLocation("dynamictreesphc", "passionfruit"), (boolean)false);
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("dynamictreesphc", "passionfruitsaplingfromvines"), null, (ItemStack)passionfruitSapling, (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{passionfruitVine}), Ingredient.func_193367_a((Item)com.ferreusveritas.dynamictrees.ModItems.dirtBucket)});
    }

    private static void speciesRecipes(Species species) {
        ModRecipes.addSeedExchange(species);
    }

    private static void addSeedExchange(Species species) {
        Block saplingBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("harvestcraft", species.getRegistryName().func_110623_a() + "_sapling"));
        if (saplingBlock == null) {
            return;
        }
        ItemStack saplingStack = new ItemStack(saplingBlock);
        ItemStack seedStack = species.getSeedStack(1);
        String fruit = species.getRegistryName().func_110623_a();
        if (ModConstants.FRUITISNOTSEED.contains(fruit) || !(species instanceof SpeciesFruit)) {
            com.ferreusveritas.dynamictrees.ModRecipes.createDirtBucketExchangeRecipes((ItemStack)saplingStack, (ItemStack)seedStack, (boolean)true, (String)"seedfromsapling");
        } else {
            Item fruitItem = ((SpeciesFruit)species).getFruitBlock().getFruitDrop().func_77973_b();
            ItemStack fruitStack = new ItemStack(fruitItem);
            com.ferreusveritas.dynamictrees.ModRecipes.createDirtBucketExchangeRecipesWithFruit((ItemStack)saplingStack, (ItemStack)seedStack, (ItemStack)fruitStack, (boolean)true, (String)"seedfromsapling", (ResourceLocation)species.getRegistryName(), (boolean)ModConstants.NUTS.contains(fruit));
        }
    }

    private static void addTransformationPotion(Species species) {
        ItemStack outputStack = com.ferreusveritas.dynamictrees.ModItems.dendroPotion.setTargetTree(new ItemStack((Item)com.ferreusveritas.dynamictrees.ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), species.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)com.ferreusveritas.dynamictrees.ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)species.getSeedStack(1), (ItemStack)outputStack);
    }
}

