/*
 * Decompiled with CFR 0.152.
 */
package surreal.bundles.recipes;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;
import surreal.bundles.items.ItemBundle;

public class RecipeBundleColoring
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World worldIn) {
        boolean hasBundle = false;
        boolean hasColor = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!DyeUtils.isDye((ItemStack)stack)) {
                if (!(stack.func_77973_b() instanceof ItemBundle)) continue;
                if (!hasBundle) {
                    hasBundle = true;
                    continue;
                }
                return false;
            }
            hasColor = true;
        }
        return hasBundle && hasColor;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack itemstack = ItemStack.field_190927_a;
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack itemstack1 = inv.func_70301_a(k);
            if (itemstack1.func_190926_b()) continue;
            if (itemstack1.func_77973_b() instanceof ItemBundle) {
                itemstack = itemstack1.func_77946_l();
                int l = ItemBundle.getColor(itemstack);
                if (l < 0) {
                    EnumDyeColor col = EnumDyeColor.func_176766_a((int)(-l));
                    switch (col) {
                        case WHITE: {
                            l = 0xF9FFFE;
                            break;
                        }
                        case ORANGE: {
                            l = 16351261;
                            break;
                        }
                        case MAGENTA: {
                            l = 13061821;
                            break;
                        }
                        case LIGHT_BLUE: {
                            l = 3847130;
                            break;
                        }
                        case YELLOW: {
                            l = 16701501;
                            break;
                        }
                        case LIME: {
                            l = 8439583;
                            break;
                        }
                        case PINK: {
                            l = 15961002;
                            break;
                        }
                        case GRAY: {
                            l = 4673362;
                            break;
                        }
                        case SILVER: {
                            l = 0x9D9D97;
                            break;
                        }
                        case CYAN: {
                            l = 1481884;
                            break;
                        }
                        case PURPLE: {
                            l = 8991416;
                            break;
                        }
                        case BLUE: {
                            l = 3949738;
                            break;
                        }
                        case BROWN: {
                            l = 8606770;
                            break;
                        }
                        case GREEN: {
                            l = 6192150;
                            break;
                        }
                        case RED: {
                            l = 11546150;
                            break;
                        }
                        case BLACK: {
                            l = 0x1D1D21;
                        }
                    }
                }
                float f = (float)(l >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(l & 0xFF) / 255.0f;
                i = (int)((float)i + Math.max(f, Math.max(f1, f2)) * 255.0f);
                aint[0] = (int)((float)aint[0] + f * 255.0f);
                aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                aint[2] = (int)((float)aint[2] + f2 * 255.0f);
            } else {
                Optional color = DyeUtils.colorFromStack((ItemStack)itemstack1);
                if (!color.isPresent()) {
                    return itemstack;
                }
                float[] afloat = ((EnumDyeColor)color.get()).func_193349_f();
                int l1 = (int)(afloat[0] * 255.0f);
                int i2 = (int)(afloat[1] * 255.0f);
                int j2 = (int)(afloat[2] * 255.0f);
                i += Math.max(l1, Math.max(i2, j2));
                aint[0] = aint[0] + l1;
                aint[1] = aint[1] + i2;
                aint[2] = aint[2] + j2;
            }
            ++j;
        }
        if (!itemstack.func_190926_b()) {
            int i1 = aint[0] / j;
            int j1 = aint[1] / j;
            int k1 = aint[2] / j;
            float f3 = (float)i / (float)j;
            float f4 = Math.max(i1, Math.max(j1, k1));
            i1 = (int)((float)i1 * f3 / f4);
            j1 = (int)((float)j1 * f3 / f4);
            k1 = (int)((float)k1 * f3 / f4);
            int k2 = (i1 << 8) + j1;
            k2 = (k2 << 8) + k1;
            ItemBundle.setColor(itemstack, k2);
        }
        return itemstack;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 1 || height > 1;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }
}

