/*
 * Decompiled with CFR 0.152.
 */
package surreal.bundles.mixins.early;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import surreal.bundles.ModSounds;
import surreal.bundles.config.ConfigHandler;
import surreal.bundles.items.ItemBundle;

@Mixin(value={Container.class})
public abstract class ContainerMixin {
    @Shadow
    public List<Slot> field_75151_b;
    @Shadow
    private int field_94536_g;

    @Inject(method={"slotClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void slotClick(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player, CallbackInfoReturnable<ItemStack> cir) {
        if (slotId >= 0 && slotId < this.field_75151_b.size()) {
            Slot slot = this.field_75151_b.get(slotId);
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (slot != null && ((dragType == 1 || dragType == 4) && this.field_94536_g == 0 || (dragType == 5 || dragType == 6) && this.field_94536_g == 1)) {
                if (stack.func_77973_b() instanceof ItemBundle) {
                    int itemAmount = ItemBundle.getItemAmount(stack);
                    if (slot.func_75216_d() && slot.func_82869_a(player) && itemAmount < ConfigHandler.bundleLimit && ConfigHandler.canPutItem(slot.func_75211_c())) {
                        this.bundles$insertItem(player, stack, slot.func_75211_c(), slot);
                        cir.setReturnValue((Object)ItemStack.field_190927_a);
                    } else if (itemAmount > 0) {
                        this.bundles$removeItem(player, stack, slot);
                        cir.setReturnValue((Object)ItemStack.field_190927_a);
                    }
                } else if (slot.func_75211_c().func_77973_b() instanceof ItemBundle) {
                    int itemAmount = ItemBundle.getItemAmount(slot.func_75211_c());
                    if (!stack.func_190926_b() && itemAmount < ConfigHandler.bundleLimit && ConfigHandler.canPutItem(stack) && slot.func_82869_a(player)) {
                        this.bundles$insertItem(player, slot.func_75211_c(), stack, slot);
                        cir.setReturnValue((Object)ItemStack.field_190927_a);
                    } else if (itemAmount > 0 && stack.func_190926_b()) {
                        this.bundles$removeHeldItem(player, slot.func_75211_c());
                        cir.setReturnValue((Object)ItemStack.field_190927_a);
                    }
                }
            }
        }
    }

    @Unique
    private void bundles$insertItem(EntityPlayer player, ItemStack bundle, ItemStack stackToAdd, Slot slot) {
        if (player.field_70170_p.field_72995_K) {
            player.func_184185_a(ModSounds.INSERT, 1.0f, 1.0f);
        }
        ItemBundle.addItem(bundle, slot.func_190901_a(player, stackToAdd));
    }

    @Unique
    private void bundles$removeItem(EntityPlayer player, ItemStack bundle, Slot slotInventory) {
        int slot;
        ItemStack st;
        if (slotInventory.func_75216_d()) {
            if (slotInventory.func_75211_c().func_77976_d() == slotInventory.func_75211_c().func_190916_E()) {
                return;
            }
            for (int i = 0; i < ItemBundle.getSlotCount(bundle); ++i) {
                ItemStack stack = ItemBundle.getItem(bundle, i);
                if (!Container.func_94527_a((Slot)slotInventory, (ItemStack)stack, (boolean)true) || !slotInventory.func_75214_a(stack)) continue;
                if (player.field_70170_p.field_72995_K) {
                    player.func_184185_a(ModSounds.REMOVE, 1.0f, 1.0f);
                }
                slotInventory.func_75215_d(ItemBundle.removeItem(bundle, i, Math.min(slotInventory.func_178170_b(stack), stack.func_77976_d())));
                return;
            }
        }
        if (Container.func_94527_a((Slot)slotInventory, (ItemStack)(st = ItemBundle.getItem(bundle, slot = 0)), (boolean)true) && slotInventory.func_75214_a(st)) {
            if (player.field_70170_p.field_72995_K) {
                player.func_184185_a(ModSounds.REMOVE, 1.0f, 1.0f);
            }
            slotInventory.func_75215_d(ItemBundle.removeItem(bundle, slot, Math.min(slotInventory.func_178170_b(st), st.func_77976_d())));
        }
    }

    @Unique
    private void bundles$removeHeldItem(EntityPlayer player, ItemStack bundle) {
        if (!player.field_71071_by.func_70445_o().func_190926_b()) {
            for (int i = 0; i < ItemBundle.getSlotCount(bundle); ++i) {
                ItemStack stack = ItemBundle.getItem(bundle, i);
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)player.field_71071_by.func_70445_o())) continue;
                if (player.field_70170_p.field_72995_K) {
                    player.func_184185_a(ModSounds.REMOVE, 1.0f, 1.0f);
                }
                player.field_71071_by.func_70437_b(ItemBundle.removeItem(bundle, i, stack.func_77976_d()));
                return;
            }
        }
        int slot = 0;
        ItemStack st = ItemBundle.getItem(bundle, slot);
        if (player.field_70170_p.field_72995_K) {
            player.func_184185_a(ModSounds.REMOVE, 1.0f, 1.0f);
        }
        player.field_71071_by.func_70437_b(ItemBundle.removeItem(bundle, slot, st.func_77976_d()));
    }
}

