/*
 * Decompiled with CFR 0.152.
 */
package surreal.bundles.items;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import surreal.bundles.ModSounds;
import surreal.bundles.config.ConfigHandler;

public class ItemBundle
extends Item {
    private static final IItemPropertyGetter BUNDLE_PROPERTY = (stack, worldIn, entityIn) -> {
        int amount = ItemBundle.getItemAmount(stack);
        if (amount == 0) {
            return 0.0f;
        }
        float a = (float)amount / (float)ConfigHandler.bundleLimit;
        float b = 1.0f / (float)ConfigHandler.bundleLevels;
        int level = (int)(a / b) + 1;
        return b * (float)level;
    };

    public ItemBundle() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_185043_a(new ResourceLocation("bundles", "filled"), BUNDLE_PROPERTY);
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            if (ConfigHandler.allowCustomColors && ItemBundle.getColor(stack) != 13464390) {
                tooltip.add(I18n.func_135052_a((String)"item.bundles.bundle.dyed", (Object[])new Object[0]));
            }
            int size = ItemBundle.getItemAmount(stack);
            String str = I18n.func_135052_a((String)"item.bundles.bundle.fullness", (Object[])new Object[]{size, ConfigHandler.bundleLimit});
            if (size == ConfigHandler.bundleLimit) {
                tooltip.add(TextFormatting.DARK_RED + str);
            } else {
                tooltip.add(str);
            }
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        super.func_150895_a(tab, items);
        if (!ConfigHandler.allowCustomColors && this.func_194125_a(tab)) {
            for (int i = 0; i < 16; ++i) {
                ItemStack stack = new ItemStack((Item)this);
                ItemBundle.setColor(stack, EnumDyeColor.func_176766_a((int)i));
                items.add((Object)stack);
            }
        }
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return 1.0 - (double)ItemBundle.getItemAmount(stack) / (double)ConfigHandler.bundleLimit;
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return 7104994;
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return ItemBundle.getItemAmount(stack) > 0;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack[] items;
        ItemStack bundle = playerIn.func_184586_b(handIn);
        if (!bundle.func_77942_o() || !playerIn.func_70093_af()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        if (ItemBundle.getItemAmount(bundle) > 0 && (items = ItemBundle.getItems(bundle)) != null && items.length > 0) {
            if (!worldIn.field_72995_K) {
                for (ItemStack stack : items) {
                    EntityItem item = new EntityItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u + 0.3, playerIn.field_70161_v, stack);
                    item.func_174868_q();
                    worldIn.func_72838_d((Entity)item);
                }
                NBTTagCompound tag = Objects.requireNonNull(bundle.func_77978_p());
                tag.func_82580_o("Items");
                tag.func_74782_a("Items", (NBTBase)new NBTTagList());
                ItemBundle.setAmount(bundle, 0);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)bundle);
            }
            playerIn.func_184185_a(ModSounds.DROP_CONTENTS, 1.0f, 1.0f);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static void addItem(ItemStack bundle, ItemStack stack) {
        NBTTagList list = ItemBundle.getItemList(bundle);
        if (list == null) {
            NBTTagCompound compound = ItemBundle.getOrCreateTag(bundle);
            list = new NBTTagList();
            compound.func_74782_a("Items", (NBTBase)list);
        }
        int empty = ItemBundle.getEmptyAmount(bundle);
        int itemSize = ItemBundle.getItemstackAmount(stack);
        int itemCount = stack.func_190916_E();
        int countToAdd = Math.min(itemCount, empty / itemSize);
        if (countToAdd == 0) {
            return;
        }
        int amountToAdd = Math.min(itemSize * itemCount, itemSize * countToAdd);
        ItemBundle.addAmount(bundle, amountToAdd);
        NBTTagCompound compound = stack.serializeNBT();
        if (compound.func_150297_b("Count", 1)) {
            compound.func_74774_a("Count", (byte)countToAdd);
        } else {
            compound.func_74768_a("Count", countToAdd);
        }
        list.func_74742_a((NBTBase)compound);
        stack.func_190920_e(stack.func_190916_E() - countToAdd);
    }

    public static ItemStack removeItem(ItemStack bundle, int slot, int amount) {
        NBTTagList list = ItemBundle.getItemList(bundle);
        if (list == null) {
            NBTTagCompound compound = ItemBundle.getOrCreateTag(bundle);
            list = new NBTTagList();
            compound.func_74782_a("Items", (NBTBase)list);
            return ItemStack.field_190927_a;
        }
        NBTTagCompound stackTag = list.func_150305_b(slot = ItemBundle.checkSlot(bundle, slot));
        ItemStack stack = new ItemStack(stackTag);
        if (stack.func_190926_b()) {
            return stack;
        }
        amount = Math.min(stack.func_190916_E(), amount);
        if (amount == stack.func_190916_E()) {
            list.func_74744_a(slot);
        } else {
            int count = stack.func_190916_E() - amount;
            if (stackTag.func_150297_b("Count", 1)) {
                stackTag.func_74774_a("Count", (byte)count);
            } else {
                stackTag.func_74768_a("Count", count);
            }
            stack.func_190920_e(amount);
        }
        ItemBundle.addAmount(bundle, -ItemBundle.getItemstackAmount(stack) * stack.func_190916_E());
        return stack;
    }

    public static int getSlotCount(ItemStack bundle) {
        NBTTagList list = ItemBundle.getItemList(bundle);
        if (list == null) {
            return 0;
        }
        return list.func_74745_c();
    }

    public static int getEmptyAmount(ItemStack bundle) {
        return ConfigHandler.bundleLimit - ItemBundle.getItemAmount(bundle);
    }

    public static int getItemAmount(ItemStack bundle) {
        NBTTagCompound tag = ItemBundle.getOrCreateTag(bundle);
        if (!tag.func_82582_d() && tag.func_74764_b("Amount")) {
            return tag.func_74762_e("Amount");
        }
        return 0;
    }

    public static boolean isBundleFull(ItemStack bundle) {
        return ItemBundle.getItemAmount(bundle) == ConfigHandler.bundleLimit;
    }

    public static ItemStack[] getItems(ItemStack bundle) {
        NBTTagList list = ItemBundle.getItemList(bundle);
        if (list == null) {
            return null;
        }
        int count = list.func_74745_c();
        if (count <= 0) {
            return null;
        }
        ItemStack[] array = new ItemStack[count];
        for (int i = 0; i < count; ++i) {
            ItemStack stack;
            array[i] = stack = new ItemStack(list.func_150305_b(i));
        }
        return array;
    }

    public static ItemStack getItem(ItemStack bundle, int slot) {
        NBTTagList list = ItemBundle.getItemList(bundle);
        if (list == null) {
            return ItemStack.field_190927_a;
        }
        int count = list.func_74745_c();
        if (count <= 0) {
            return ItemStack.field_190927_a;
        }
        slot = ItemBundle.checkSlot(bundle, slot);
        return new ItemStack(list.func_150305_b(slot));
    }

    public static int getColor(ItemStack bundle) {
        int def = 13464390;
        if (!bundle.func_77942_o()) {
            return def;
        }
        NBTTagCompound tag = Objects.requireNonNull(bundle.func_77978_p());
        if (!tag.func_74764_b("Color")) {
            return def;
        }
        return tag.func_74762_e("Color");
    }

    public static void setColor(ItemStack bundle, int color) {
        NBTTagCompound tag = ItemBundle.getOrCreateTag(bundle);
        tag.func_74768_a("Color", color);
    }

    public static void setColor(ItemStack bundle, EnumDyeColor color) {
        ItemBundle.setColor(bundle, -color.func_176767_b());
    }

    private static void setAmount(ItemStack bundle, int amount) {
        NBTTagCompound tag = ItemBundle.getOrCreateTag(bundle);
        tag.func_74768_a("Amount", amount);
    }

    private static void addAmount(ItemStack bundle, int amount) {
        NBTTagCompound tag = ItemBundle.getOrCreateTag(bundle);
        if (tag.func_74764_b("Amount")) {
            amount += tag.func_74762_e("Amount");
        }
        tag.func_74768_a("Amount", amount);
    }

    private static int getItemstackAmount(ItemStack stack) {
        int size = 1;
        if (ConfigHandler.respectStackSize && stack.func_77976_d() < 64) {
            size = 64 / stack.func_77976_d();
        }
        return size;
    }

    private static NBTTagList getItemList(ItemStack bundle) {
        NBTTagCompound tag = ItemBundle.getOrCreateTag(bundle);
        if (tag.func_82582_d() || !tag.func_74764_b("Items") || ItemBundle.getItemAmount(bundle) <= 0) {
            return null;
        }
        return tag.func_150295_c("Items", 10);
    }

    private static int checkSlot(ItemStack bundle, int slot) {
        NBTTagList list = ItemBundle.getItemList(bundle);
        if (list == null || list.func_74745_c() == 0) {
            return -1;
        }
        if (slot >= list.func_74745_c()) {
            slot = list.func_74745_c() - 1;
        } else if (slot < 0) {
            slot = 0;
        }
        return slot;
    }

    @Nonnull
    private static NBTTagCompound getOrCreateTag(ItemStack bundle) {
        if (!bundle.func_77942_o()) {
            bundle.func_77982_d(new NBTTagCompound());
        }
        return Objects.requireNonNull(bundle.func_77978_p());
    }
}

