/*
 * Decompiled with CFR 0.152.
 */
package surreal.bundles;

import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import surreal.bundles.ModSounds;
import surreal.bundles.client.ClientProxy;
import surreal.bundles.client.TooltipEvent;
import surreal.bundles.config.ConfigHandler;
import surreal.bundles.items.ItemBundle;
import surreal.bundles.recipes.RecipeBundleColoring;

@Mod(modid="bundles", name="Bundles", version="1.2.3", guiFactory="surreal.bundles.config.ConfigGuiFactory", dependencies="required-after:mixinbooter@[4.2,);after:mousetweaks@[3.0,)")
public class Bundles {
    public static final String MODID = "bundles";
    public static ItemBundle BUNDLE = Bundles.registerItem("bundle", new ItemBundle());

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(ConfigHandler.class);
        if (FMLLaunchHandler.side() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new ClientProxy());
            MinecraftForge.EVENT_BUS.register((Object)new TooltipEvent());
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.initialize(event);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)BUNDLE);
    }

    @SubscribeEvent
    public void registerRecipe(RegistryEvent.Register<IRecipe> event) {
        ItemStack string = new ItemStack(Items.field_151007_F);
        ItemStack hide = new ItemStack(Items.field_179555_bs);
        GameRegistry.addShapedRecipe((ResourceLocation)BUNDLE.getRegistryName(), null, (ItemStack)new ItemStack((Item)BUNDLE), (Object[])new Object[]{"ABA", "B B", "BBB", Character.valueOf('A'), string, Character.valueOf('B'), hide});
        if (!ConfigHandler.allowCustomColors) {
            for (int i = 0; i < 16; ++i) {
                EnumDyeColor color = EnumDyeColor.func_176766_a((int)i);
                ItemStack stack = new ItemStack((Item)BUNDLE);
                ItemBundle.setColor(stack, color);
                GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(BUNDLE.getRegistryName() + "_" + color.func_176610_l()), null, (ItemStack)stack, (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)BUNDLE), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, color.func_176767_b())})});
            }
        } else {
            event.getRegistry().register(new RecipeBundleColoring().setRegistryName(MODID, "bundle_coloring"));
        }
    }

    @SubscribeEvent
    public void registerSound(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.init();
    }

    private static <T extends Item> T registerItem(String name, T item) {
        ((Item)item.setRegistryName(MODID, name)).func_77655_b("bundles." + name);
        return item;
    }
}

