/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BiomeTraitPool
extends BiomeTrait {
    protected IBlockState blockToSpawn;
    protected IBlockState blockToSurround;

    protected BiomeTraitPool(Builder builder) {
        super(builder);
        this.blockToSpawn = builder.blockToSpawn;
        this.blockToSurround = builder.blockToSurround;
    }

    public static BiomeTraitPool create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public void readFromConfig(Config config) {
        super.readFromConfig(config);
        this.blockToSpawn = ConfigHelper.getBlockState(config, "blockToSpawn");
        this.blockToSurround = ConfigHelper.getBlockState(config, "blockToSurround");
    }

    @Override
    public void writeToConfig(Config config) {
        super.writeToConfig(config);
        ConfigHelper.setBlockState(config, "blockToSurround", this.blockToSurround);
        ConfigHelper.setBlockState(config, "blockToSpawn", this.blockToSpawn);
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.blockToSpawn == null || this.blockToSurround == null) {
            return false;
        }
        pos = pos.func_177982_a(-8, 0, -8);
        while (pos.func_177956_o() > this.minimumGenerationHeight && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 4 || pos.func_177956_o() < this.minimumGenerationHeight) {
            return false;
        }
        pos = pos.func_177979_c(4);
        boolean[] hasSpace = new boolean[2048];
        int i = random.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = random.nextDouble() * 6.0 + 3.0;
            double d1 = random.nextDouble() * 4.0 + 2.0;
            double d2 = random.nextDouble() * 6.0 + 3.0;
            double d3 = random.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = random.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = random.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        hasSpace[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    boolean bl = flag = !hasSpace[(k1 * 16 + l2) * 8 + k] && (k1 < 15 && hasSpace[((k1 + 1) * 16 + l2) * 8 + k] || k1 > 0 && hasSpace[((k1 - 1) * 16 + l2) * 8 + k] || l2 < 15 && hasSpace[(k1 * 16 + l2 + 1) * 8 + k] || l2 > 0 && hasSpace[(k1 * 16 + (l2 - 1)) * 8 + k] || k < 7 && hasSpace[(k1 * 16 + l2) * 8 + k + 1] || k > 0 && hasSpace[(k1 * 16 + l2) * 8 + (k - 1)]);
                    if (!flag) continue;
                    Material material = world.func_180495_p(pos.func_177982_a(k1, k, l2)).func_185904_a();
                    if (k >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (k >= 4 || material.func_76220_a() || world.func_180495_p(pos.func_177982_a(k1, k, l2)) == this.blockToSpawn) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 8; ++i4) {
                    if (!hasSpace[(l1 * 16 + i3) * 8 + i4]) continue;
                    world.func_180501_a(pos.func_177982_a(l1, i4, i3), i4 >= 4 ? Blocks.field_150350_a.func_176223_P() : this.blockToSpawn, 2);
                }
            }
        }
        for (int j2 = 0; j2 < 16; ++j2) {
            for (int k3 = 0; k3 < 16; ++k3) {
                for (int k4 = 0; k4 < 8; ++k4) {
                    boolean flag1;
                    boolean bl = flag1 = !hasSpace[(j2 * 16 + k3) * 8 + k4] && (j2 < 15 && hasSpace[((j2 + 1) * 16 + k3) * 8 + k4] || j2 > 0 && hasSpace[((j2 - 1) * 16 + k3) * 8 + k4] || k3 < 15 && hasSpace[(j2 * 16 + k3 + 1) * 8 + k4] || k3 > 0 && hasSpace[(j2 * 16 + (k3 - 1)) * 8 + k4] || k4 < 7 && hasSpace[(j2 * 16 + k3) * 8 + k4 + 1] || k4 > 0 && hasSpace[(j2 * 16 + k3) * 8 + (k4 - 1)]);
                    if (!flag1 || k4 >= 4 && random.nextInt(2) == 0 || !world.func_180495_p(pos.func_177982_a(j2, k4, k3)).func_185904_a().func_76220_a()) continue;
                    world.func_180501_a(pos.func_177982_a(j2, k4, k3), this.blockToSurround, 2);
                }
            }
        }
        return true;
    }

    public static class Builder
    extends BiomeTrait.Builder<BiomeTraitPool> {
        private IBlockState blockToSpawn = Blocks.field_150355_j.func_176223_P();
        private IBlockState blockToSurround = Blocks.field_150348_b.func_176223_P();

        public Builder blockToSpawn(IBlockState blockToSpawn) {
            this.blockToSpawn = blockToSpawn;
            return this;
        }

        public Builder blockToSurround(IBlockState blockToSurround) {
            this.blockToSurround = blockToSurround;
            return this;
        }

        @Override
        public BiomeTraitPool create() {
            return new BiomeTraitPool(this);
        }
    }
}

