/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BiomeTraitPatch
extends BiomeTrait {
    protected IBlockState blockToSpawn;
    protected IBlockState blockToTarget;
    protected int patchWidth;

    protected BiomeTraitPatch(Builder builder) {
        super(builder);
        this.blockToSpawn = builder.blockToSpawn;
        this.blockToTarget = builder.blockToTarget;
        this.patchWidth = builder.patchWidth;
    }

    public static BiomeTraitPatch create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public void readFromConfig(Config config) {
        super.readFromConfig(config);
        this.blockToSpawn = ConfigHelper.getBlockState(config, "blockToSpawn");
        this.blockToTarget = ConfigHelper.getBlockState(config, "blockToTarget");
        this.patchWidth = (Integer)config.get("patchWidth");
    }

    @Override
    public void writeToConfig(Config config) {
        super.writeToConfig(config);
        ConfigHelper.setBlockState(config, "blockToSpawn", this.blockToSpawn);
        ConfigHelper.setBlockState(config, "blockToTarget", this.blockToTarget);
        config.add("patchWidth", (Object)this.patchWidth);
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.blockToSpawn == null || this.blockToTarget == null) {
            return false;
        }
        while (world.func_175623_d(pos) && pos.func_177956_o() > 2) {
            pos = pos.func_177977_b();
        }
        if (world.func_180495_p(pos) != this.blockToTarget) {
            return false;
        }
        int width = random.nextInt(this.patchWidth - 2) + 2;
        for (int posX = pos.func_177958_n() - width; posX <= pos.func_177958_n() + width; ++posX) {
            for (int posZ = pos.func_177952_p() - width; posZ <= pos.func_177952_p() + width; ++posZ) {
                int areaZ;
                int areaX = posX - pos.func_177958_n();
                if (areaX * areaX + (areaZ = posZ - pos.func_177952_p()) * areaZ > width * width) continue;
                for (int posY = pos.func_177956_o() - 1; posY <= pos.func_177956_o() + 1; ++posY) {
                    BlockPos blockPos = new BlockPos(posX, posY, posZ);
                    if (world.func_180495_p(blockPos) != this.blockToTarget) continue;
                    world.func_180501_a(blockPos, this.blockToSpawn, 2);
                }
            }
        }
        return true;
    }

    public static class Builder
    extends BiomeTrait.Builder<BiomeTraitPatch> {
        private IBlockState blockToSpawn = Blocks.field_150403_cj.func_176223_P();
        private IBlockState blockToTarget = Blocks.field_150432_aD.func_176223_P();
        private int patchWidth = 4;

        public Builder blockToSpawn(IBlockState blockToSpawn) {
            this.blockToSpawn = blockToSpawn;
            return this;
        }

        public Builder blockToTarget(IBlockState blockToTarget) {
            this.blockToTarget = blockToTarget;
            return this;
        }

        public Builder patchWidth(int patchWidth) {
            this.patchWidth = patchWidth;
            return this;
        }

        @Override
        public BiomeTraitPatch create() {
            return new BiomeTraitPatch(this);
        }
    }
}

