/*
 * Decompiled with CFR 0.152.
 */
package com.Gr3atsaga.TimeShallNotPass.Core;

import com.Gr3atsaga.TimeShallNotPass.Commands.TimeShallNotPassCommand;
import com.Gr3atsaga.TimeShallNotPass.Config.TimeShallNotPassConfiguration;
import com.Gr3atsaga.TimeShallNotPass.Core.Managers.PlayerExclusionsManager;
import com.Gr3atsaga.TimeShallNotPass.Core.Managers.TimeShallNotPassModuleManager;
import com.Gr3atsaga.TimeShallNotPass.Util.LogService;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="timeshallnotpass", name="Time Shall Not Pass", version="1.12.2-1.2.1", acceptableRemoteVersions="*")
public class TimeShallNotPass {
    public static final String MOD_ID = "timeshallnotpass";
    public static final String MOD_NAME = "Time Shall Not Pass";
    public static final String MOD_VERSION = "1.12.2-1.2.1";
    private int numNonExcludedPlayersConnected = 0;
    public static TimeShallNotPass SingletonInstance;
    private static MinecraftServer minecraftServer;

    public TimeShallNotPass() {
        SingletonInstance = this;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        TimeShallNotPassConfiguration.Initialize(new File(new File(event.getModConfigurationDirectory(), "TimeShallNotPass"), "TimeShallNotPass.cfg"));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler commonHandler = FMLCommonHandler.instance();
        if (commonHandler != null && commonHandler.getSide() == Side.SERVER) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new TimeShallNotPassCommand());
        minecraftServer = event.getServer();
        TimeShallNotPassModuleManager.initializeModules(minecraftServer);
        TimeShallNotPassModuleManager.toggleModulesOn("Server is starting.");
    }

    @Mod.EventHandler
    public void onServerClosing(FMLServerStoppingEvent event) {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        TimeShallNotPassModuleManager.toggleModulesOff("Server is closing.");
        PlayerExclusionsManager.updateExclusionStatusForAllPlayers();
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        String playerName;
        String uniqueId = event.player.func_110124_au().toString();
        if (PlayerExclusionsManager.isPlayerNotExcluded(uniqueId, playerName = event.player.func_70005_c_(), true)) {
            if (++this.numNonExcludedPlayersConnected == 1) {
                TimeShallNotPassModuleManager.toggleModulesOff("A non-excluded player has connected.");
            }
        } else if (TimeShallNotPassConfiguration.verboseLogging.getBoolean()) {
            LogService.LogMessage("An excluded player has connected.");
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        String playerName;
        String uniqueId = event.player.func_110124_au().toString();
        if (PlayerExclusionsManager.isPlayerNotExcluded(uniqueId, playerName = event.player.func_70005_c_(), false)) {
            if (this.numNonExcludedPlayersConnected > 0 && --this.numNonExcludedPlayersConnected == 0) {
                TimeShallNotPassModuleManager.toggleModulesOn("All non-excluded players have disconnected.");
            }
        } else if (TimeShallNotPassConfiguration.verboseLogging.getBoolean()) {
            LogService.LogMessage("An excluded player has disconnected.");
        }
    }

    public void reload(boolean isRefresh) {
        this.numNonExcludedPlayersConnected = 0;
        for (EntityPlayer player : minecraftServer.func_184103_al().func_181057_v()) {
            String playerName;
            String uniqueId = player.func_110124_au().toString();
            if (!PlayerExclusionsManager.isPlayerNotExcluded(uniqueId, playerName = player.func_70005_c_(), false)) continue;
            ++this.numNonExcludedPlayersConnected;
        }
        if (isRefresh) {
            TimeShallNotPassModuleManager.toggleModulesOn("Time Shall Not Pass is refreshing.");
        }
        if (this.numNonExcludedPlayersConnected > 0) {
            TimeShallNotPassModuleManager.toggleModulesOff("Reloaded Time Shall Not Pass. There are non-excluded players online.");
        } else if (!isRefresh) {
            TimeShallNotPassModuleManager.toggleModulesOn("Reloaded Time Shall Not Pass. No non-excluded players are online.");
        }
    }

    public boolean excludedPlayersOnline() {
        return this.numNonExcludedPlayersConnected > 0;
    }
}

