/*
 * Decompiled with CFR 0.152.
 */
package com.Gr3atsaga.TimeShallNotPass.Core.Modules;

import com.Gr3atsaga.TimeShallNotPass.Config.TimeShallNotPassConfiguration;
import com.Gr3atsaga.TimeShallNotPass.Core.TimeShallNotPassModule;
import com.Gr3atsaga.TimeShallNotPass.Util.LogService;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TileEntityTicksModule
extends TimeShallNotPassModule {
    public TileEntityTicksModule() {
        this.moduleName = "tileEntityTicksModule";
        this.moduleDisplayName = "Tile Entity Ticks Module";
    }

    @Override
    public void initialize(MinecraftServer minecraftServer) {
        this.enabled = TimeShallNotPassConfiguration.tileEntityTicksModuleEnabled.getBoolean();
    }

    @Override
    public boolean toggle(TimeShallNotPassModule.ToggleStatus toggleStatus) {
        if (toggleStatus != this.currentToggleStatus) {
            if (toggleStatus == TimeShallNotPassModule.ToggleStatus.ON) {
                this.minecraftServer.field_71305_c[0].field_175730_i.clear();
                MinecraftForge.EVENT_BUS.register((Object)this);
            } else if (toggleStatus == TimeShallNotPassModule.ToggleStatus.OFF) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                this.minecraftServer.field_71305_c[0].field_175730_i.addAll(this.minecraftServer.field_71305_c[0].field_147482_g.stream().filter(x -> x instanceof ITickable).collect(Collectors.toSet()));
            }
            this.currentToggleStatus = toggleStatus;
            return true;
        }
        return false;
    }

    @Override
    public String getToggleMessage() {
        return this.moduleDisplayName + ": " + (this.currentToggleStatus == TimeShallNotPassModule.ToggleStatus.ON ? "All tick-able tile entities have been paused." : "All tick-able tile entities have been un-paused.");
    }

    @SubscribeEvent
    public void OnWorldTick(TickEvent.WorldTickEvent event) {
        List tickableTileEntities = event.world.field_175730_i;
        if (tickableTileEntities.size() > 0) {
            tickableTileEntities.clear();
            if (TimeShallNotPassConfiguration.verboseLogging.getBoolean()) {
                LogService.LogMessage(String.format("%s detected new tile entities and paused them.", this.moduleDisplayName));
            }
        }
    }
}

