/*
 * Decompiled with CFR 0.152.
 */
package com.Gr3atsaga.TimeShallNotPass.Core.Managers;

import com.Gr3atsaga.TimeShallNotPass.Config.TimeShallNotPassConfiguration;
import com.Gr3atsaga.TimeShallNotPass.Core.Modules.DaylightCycleModule;
import com.Gr3atsaga.TimeShallNotPass.Core.Modules.FireTicksModule;
import com.Gr3atsaga.TimeShallNotPass.Core.Modules.RandomTicksModule;
import com.Gr3atsaga.TimeShallNotPass.Core.Modules.TileEntityTicksModule;
import com.Gr3atsaga.TimeShallNotPass.Core.Modules.WeatherCycleModule;
import com.Gr3atsaga.TimeShallNotPass.Core.TimeShallNotPass;
import com.Gr3atsaga.TimeShallNotPass.Core.TimeShallNotPassModule;
import com.Gr3atsaga.TimeShallNotPass.Util.LogService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;

public final class TimeShallNotPassModuleManager {
    private static final DaylightCycleModule daylightCycleModule;
    private static final RandomTicksModule randomTicksModule;
    private static final TileEntityTicksModule tileEntityTicksModule;
    private static final FireTicksModule fireTicksModule;
    private static final WeatherCycleModule weatherCycleModule;
    private static final HashMap<String, TimeShallNotPassModule> modules;
    private static GameRules GameRules;

    public static void initializeModules(MinecraftServer minecraftServer) {
        GameRules = minecraftServer.field_71305_c[0].func_82736_K();
        daylightCycleModule.initialize(minecraftServer);
        randomTicksModule.initialize(minecraftServer);
        tileEntityTicksModule.initialize(minecraftServer);
        fireTicksModule.initialize(minecraftServer);
        weatherCycleModule.initialize(minecraftServer);
    }

    private static void toggleModules(TimeShallNotPassModule.ToggleStatus toggleStatus, String logMessage) {
        ArrayList<TimeShallNotPassModule> toggledModules = new ArrayList<TimeShallNotPassModule>();
        for (TimeShallNotPassModule module : modules.values()) {
            if (!module.isEnabled() || !module.toggle(toggleStatus)) continue;
            toggledModules.add(module);
        }
        String toggleStatusString = toggleStatus.toString().toLowerCase();
        if (toggledModules.size() > 0) {
            LogService.LogMessage(String.format("%s The following modules have been toggled %s: %s", logMessage, toggleStatusString, toggledModules.stream().map(TimeShallNotPassModule::getModuleDisplayName).collect(Collectors.joining(", "))));
            if (TimeShallNotPassConfiguration.verboseLogging.getBoolean()) {
                toggledModules.stream().map(TimeShallNotPassModule::getToggleMessage).forEach(LogService::LogMessage);
            }
        } else {
            LogService.LogMessage(String.format("%s No modules have been toggled %s", logMessage, toggleStatusString));
        }
    }

    public static void toggleModulesOn(String logMessage) {
        TimeShallNotPassModuleManager.toggleModules(TimeShallNotPassModule.ToggleStatus.ON, logMessage);
    }

    public static void toggleModulesOff(String logMessage) {
        TimeShallNotPassModuleManager.toggleModules(TimeShallNotPassModule.ToggleStatus.OFF, logMessage);
    }

    public static void enableModule(String moduleName) {
        TimeShallNotPassModule module = modules.get(moduleName);
        if (module != null && module.enable(!TimeShallNotPass.SingletonInstance.excludedPlayersOnline())) {
            LogService.LogMessage(String.format("The Time Shall Not Pass %s has been enabled and toggled on.", module.getModuleDisplayName()));
            if (TimeShallNotPassConfiguration.verboseLogging.getBoolean()) {
                LogService.LogMessage(module.getToggleMessage());
            }
        }
    }

    public static void disableModule(String moduleName) {
        TimeShallNotPassModule module = modules.get(moduleName);
        if (module != null && module.disable()) {
            LogService.LogMessage(String.format("The Time Shall Not Pass %s has been disabled and toggled off.", module.getModuleDisplayName()));
            if (TimeShallNotPassConfiguration.verboseLogging.getBoolean()) {
                LogService.LogMessage(module.getToggleMessage());
            }
        }
    }

    public static String getModuleDisplayName(String moduleName) {
        TimeShallNotPassModule module = modules.get(moduleName);
        return module != null ? module.getModuleDisplayName() : moduleName;
    }

    public static void setGameRule(String gameRuleKey, String gameRuleValue) {
        GameRules.func_82764_b(gameRuleKey, gameRuleValue);
    }

    static {
        modules = new HashMap();
        daylightCycleModule = new DaylightCycleModule();
        randomTicksModule = new RandomTicksModule();
        tileEntityTicksModule = new TileEntityTicksModule();
        fireTicksModule = new FireTicksModule();
        weatherCycleModule = new WeatherCycleModule();
        modules.put(daylightCycleModule.getModuleName(), daylightCycleModule);
        modules.put(randomTicksModule.getModuleName(), randomTicksModule);
        modules.put(tileEntityTicksModule.getModuleName(), tileEntityTicksModule);
        modules.put(fireTicksModule.getModuleName(), fireTicksModule);
        modules.put(weatherCycleModule.getModuleName(), weatherCycleModule);
    }
}

