/*
 * Decompiled with CFR 0.152.
 */
package com.Gr3atsaga.TimeShallNotPass.Core.Managers;

import com.Gr3atsaga.TimeShallNotPass.Config.TimeShallNotPassConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.util.Tuple;

public final class PlayerExclusionsManager {
    private static final ArrayList<ExcludedPlayer> excludedPlayers = Arrays.stream(TimeShallNotPassConfiguration.excludedPlayers.getStringList()).map(ExcludedPlayer::new).collect(Collectors.toCollection(ArrayList::new));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tuple<ExclusionResult, String> performExclusionOperation(ExclusionOperation exclusionOperation, String uniqueId, String playerName) {
        ExcludedPlayer excludedPlayer = PlayerExclusionsManager.findExcludedPlayer(uniqueId, playerName);
        if (exclusionOperation == ExclusionOperation.ADD) {
            if (excludedPlayer == null) {
                PlayerExclusionsManager.addExcludedPlayer(new ExcludedPlayer(playerName, uniqueId, ExclusionStatus.EXCLUDED));
                return new Tuple((Object)ExclusionResult.SUCCESS, (Object)String.format("%s is now excluded.", playerName));
            } else {
                if (excludedPlayer.exclusionStatus == ExclusionStatus.EXCLUDED) return new Tuple((Object)ExclusionResult.FAILURE, (Object)String.format("%s is already excluded.", playerName));
                PlayerExclusionsManager.updateExcludedPlayer(excludedPlayer, ExclusionStatus.EXCLUDED);
            }
            return new Tuple((Object)ExclusionResult.SUCCESS, (Object)String.format("%s is now excluded.", playerName));
        }
        if (exclusionOperation == ExclusionOperation.REMOVE) {
            if (excludedPlayer == null) return new Tuple((Object)ExclusionResult.FAILURE, (Object)String.format("%s is not currently excluded.", playerName));
            PlayerExclusionsManager.removeExcludedPlayer(excludedPlayer);
            return new Tuple((Object)ExclusionResult.SUCCESS, (Object)String.format("%s is no longer excluded.", playerName));
        }
        if (exclusionOperation == ExclusionOperation.DEFER_ADDITION) {
            if (excludedPlayer != null) {
                if (excludedPlayer.exclusionStatus == ExclusionStatus.DEFERRED_REMOVAL) {
                    return new Tuple((Object)ExclusionResult.FAILURE, (Object)String.format("%s is already excluded and marked for removal.", playerName));
                }
                if (excludedPlayer.exclusionStatus == ExclusionStatus.DEFERRED_ADDITION) {
                    return new Tuple((Object)ExclusionResult.FAILURE, (Object)String.format("%s is already marked for exclusion on their next log-in.", playerName));
                }
                if (excludedPlayer.exclusionStatus != ExclusionStatus.EXCLUDED) return new Tuple((Object)ExclusionResult.FAILURE, (Object)"Invalid exclusion operation.");
                return new Tuple((Object)ExclusionResult.FAILURE, (Object)String.format("%s is already excluded.", playerName));
            }
            PlayerExclusionsManager.addExcludedPlayer(new ExcludedPlayer(playerName, uniqueId, ExclusionStatus.DEFERRED_ADDITION));
            return new Tuple((Object)ExclusionResult.SUCCESS, (Object)String.format("%s is now marked for exclusion on their next log-in. ", playerName));
        }
        if (exclusionOperation != ExclusionOperation.DEFER_REMOVAL) return new Tuple((Object)ExclusionResult.FAILURE, (Object)"Invalid exclusion operation.");
        if (excludedPlayer == null) return new Tuple((Object)ExclusionResult.FAILURE, (Object)String.format("%s is not currently excluded.", playerName));
        if (excludedPlayer.exclusionStatus == ExclusionStatus.EXCLUDED) {
            PlayerExclusionsManager.updateExcludedPlayer(excludedPlayer, ExclusionStatus.DEFERRED_REMOVAL);
            return new Tuple((Object)ExclusionResult.SUCCESS, (Object)String.format("%s is now marked for removal from exclusion on their next log-in.", playerName));
        }
        if (excludedPlayer.exclusionStatus != ExclusionStatus.DEFERRED_ADDITION) return new Tuple((Object)ExclusionResult.FAILURE, (Object)String.format("%s is already marked for removal from exclusion on their next log-in.", playerName));
        return new Tuple((Object)ExclusionResult.FAILURE, (Object)String.format("%s is not yet excluded and marked for exclusion on their next log-in.", playerName));
    }

    public static boolean isPlayerNotExcluded(String uniqueId, String playerName, boolean updateExclusionStatus) {
        return !PlayerExclusionsManager.isPlayerExcluded(uniqueId, playerName, updateExclusionStatus);
    }

    public static boolean isPlayerExcluded(String uniqueId, String playerName, boolean updateExclusionStatus) {
        ExcludedPlayer excludedPlayer = PlayerExclusionsManager.findExcludedPlayer(uniqueId, playerName);
        if (excludedPlayer != null) {
            ExclusionStatus exclusionStatus = excludedPlayer.exclusionStatus;
            if (updateExclusionStatus) {
                if (exclusionStatus == ExclusionStatus.DEFERRED_ADDITION) {
                    PlayerExclusionsManager.updateExcludedPlayer(excludedPlayer, ExclusionStatus.EXCLUDED);
                } else if (exclusionStatus == ExclusionStatus.DEFERRED_REMOVAL) {
                    PlayerExclusionsManager.updateExcludedPlayer(excludedPlayer, ExclusionStatus.NOT_EXCLUDED);
                }
            }
            return TimeShallNotPassConfiguration.allowPlayerExclusions.getBoolean() && excludedPlayer.exclusionStatus == ExclusionStatus.EXCLUDED || excludedPlayer.exclusionStatus == ExclusionStatus.DEFERRED_REMOVAL;
        }
        return false;
    }

    public static String getExcludedPlayers() {
        return excludedPlayers.stream().filter(x -> ((ExcludedPlayer)x).exclusionStatus == ExclusionStatus.EXCLUDED).map(ExcludedPlayer::getDisplayValue).collect(Collectors.joining(", "));
    }

    private static void removeExcludedPlayer(ExcludedPlayer excludedPlayer) {
        excludedPlayers.remove(excludedPlayer);
        PlayerExclusionsManager.updateExcludedPlayersInConfig();
    }

    private static void addExcludedPlayer(ExcludedPlayer excludedPlayer) {
        excludedPlayers.add(excludedPlayer);
        PlayerExclusionsManager.updateExcludedPlayersInConfig();
    }

    private static void updateExcludedPlayer(ExcludedPlayer excludedPlayer, ExclusionStatus exclusionStatus) {
        excludedPlayer.exclusionStatus = exclusionStatus;
        if (exclusionStatus == ExclusionStatus.EXCLUDED) {
            PlayerExclusionsManager.updateExcludedPlayersInConfig();
        } else if (exclusionStatus == ExclusionStatus.NOT_EXCLUDED) {
            PlayerExclusionsManager.removeExcludedPlayer(excludedPlayer);
        }
    }

    private static void updateExcludedPlayersInConfig() {
        TimeShallNotPassConfiguration.updateExcludedPlayers(excludedPlayers.stream().filter(x -> ((ExcludedPlayer)x).exclusionStatus == ExclusionStatus.EXCLUDED).map(ExcludedPlayer::getConfigurationValue).collect(Collectors.toList()));
    }

    public static void updateExclusionStatusForAllPlayers() {
        ArrayList<ExcludedPlayer> currentExcludedPlayers = new ArrayList<ExcludedPlayer>(excludedPlayers);
        for (ExcludedPlayer excludedPlayer : currentExcludedPlayers) {
            ExclusionStatus exclusionStatus = excludedPlayer.exclusionStatus;
            if (exclusionStatus == ExclusionStatus.DEFERRED_ADDITION) {
                excludedPlayer.exclusionStatus = ExclusionStatus.EXCLUDED;
                continue;
            }
            if (exclusionStatus != ExclusionStatus.DEFERRED_REMOVAL) continue;
            excludedPlayers.remove(excludedPlayer);
        }
        PlayerExclusionsManager.updateExcludedPlayersInConfig();
    }

    private static ExcludedPlayer findExcludedPlayer(String uniqueId, String playerName) {
        for (ExcludedPlayer excludedPlayer : excludedPlayers) {
            if (!excludedPlayer.uniqueId.equals(uniqueId)) continue;
            if (excludedPlayer.playerName.equals("") || !excludedPlayer.playerName.equals(playerName)) {
                excludedPlayer.playerName = playerName;
                PlayerExclusionsManager.updateExcludedPlayersInConfig();
            }
            return excludedPlayer;
        }
        return null;
    }

    public static class ExcludedPlayer {
        private final String uniqueId;
        private ExclusionStatus exclusionStatus;
        public String playerName;

        ExcludedPlayer(String excludedPlayerTag) {
            String[] excludedPlayerTagPieces = excludedPlayerTag.split(":");
            if (excludedPlayerTagPieces.length == 2) {
                this.playerName = excludedPlayerTagPieces[0].trim();
                this.uniqueId = excludedPlayerTagPieces[1].trim();
            } else {
                this.playerName = "";
                this.uniqueId = excludedPlayerTag.trim();
            }
            this.exclusionStatus = ExclusionStatus.EXCLUDED;
        }

        ExcludedPlayer(String playerName, String uniqueId, ExclusionStatus exclusionStatus) {
            this.playerName = playerName;
            this.uniqueId = uniqueId;
            this.exclusionStatus = exclusionStatus;
        }

        String getDisplayValue() {
            return !this.playerName.equals("") ? this.playerName : this.uniqueId;
        }

        String getConfigurationValue() {
            return !this.playerName.equals("") ? this.playerName + ": " + this.uniqueId : this.uniqueId;
        }
    }

    public static enum ExclusionResult {
        SUCCESS,
        FAILURE;

    }

    public static enum ExclusionOperation {
        ADD,
        REMOVE,
        DEFER_ADDITION,
        DEFER_REMOVAL;

    }

    public static enum ExclusionStatus {
        EXCLUDED,
        DEFERRED_REMOVAL,
        DEFERRED_ADDITION,
        NOT_EXCLUDED;

    }
}

