/*
 * Decompiled with CFR 0.152.
 */
package com.Gr3atsaga.TimeShallNotPass.Config;

import com.Gr3atsaga.TimeShallNotPass.Core.Managers.TimeShallNotPassModuleManager;
import com.Gr3atsaga.TimeShallNotPass.Core.TimeShallNotPass;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class TimeShallNotPassConfiguration {
    public static final HashMap<String, Property> configPropertyMap = new HashMap();
    private static final String CONFIG_TIME_SHALL_NOT_PASS = "TimeShallNotPass";
    private static final String CONFIG_TIME_SHALL_NOT_PASS_MODULES = "TimeShallNotPassModules";
    public static final String CONFIG_ALLOW_PLAYER_EXCLUSIONS = "allowPlayerExclusions";
    public static final String CONFIG_EXCLUDED_PLAYERS = "excludedPlayers";
    public static final String CONFIG_DAYLIGHT_CYCLE_MODULE = "daylightCycleModule";
    public static final String CONFIG_RANDOM_TICKS_MODULE = "randomTicksModule";
    public static final String CONFIG_TILE_ENTITY_TICKS_MODULE = "tileEntityTicksModule";
    public static final String CONFIG_FIRE_TICKS_MODULE = "fireTicksModule";
    public static final String CONFIG_WEATHER_CYCLE_MODULE = "weatherCycleModule";
    public static final String CONFIG_VERBOSE_LOGGING = "verboseLogging";
    private static final String CONFIG_TIME_SHALL_NOT_PASS_COMMENT = " Time Shall Not Pass General Config";
    private static final String CONFIG_TIME_SHALL_NOT_PASS_MODULES_COMMENT = " Time Shall Not Pass Modules Config";
    private static final String CONFIG_ALLOW_EXCLUDED_PLAYERS_DESCRIPTION = " Determines whether players added to the exclusion list can connect to the server without causing any Time Shall Not Pass modules to toggle off. Default: [false]";
    private static final String CONFIG_EXCLUDED_PLAYERS_DESCRIPTION = " The players that can connect to the server without causing any Time Shall Not Pass modules to toggle off. Example: [playerName: playerUUID]";
    private static final String CONFIG_DISABLE_DAYLIGHT_CYCLE_DESCRIPTION = " Controls if Time Shall Not Pass will disable the daylight cycle when there are no non-excluded players connected. Default: [true]";
    private static final String CONFIG_DISABLE_RANDOM_TICKS_DESCRIPTION = " Controls if Time Shall Not Pass will disable random ticks when there are no non-excluded players connected. Default: [false]";
    private static final String CONFIG_DISABLE_TILE_ENTITY_TICKS_DESCRIPTION = " Controls if Time Shall Not Pass will disable tile entity ticks when there are no non-excluded players connected. Default: [false]";
    private static final String CONFIG_DISABLE_FIRE_TICKS_DESCRIPTION = " Controls if Time Shall Not Pass will disable fire ticks when there are no non-excluded players connected. Default: [false]";
    private static final String CONFIG_DISABLE_WEATHER_CYCLE_DESCRIPTION = " Controls if Time Shall Not Pass will disable the weather cycle when there are no non-excluded players connected. Default: [false]";
    private static final String CONFIG_VERBOSE_LOGGING_DESCRIPTION = " Tells Time Shall Not Pass if extra logging should be done in the server console and log file. This will give you a break-down of what each module is doing. Default: [false]";
    public static Property daylightCycleModuleEnabled;
    public static Property randomTicksModuleEnabled;
    public static Property tileEntityTicksModuleEnabled;
    public static Property fireTicksModuleEnabled;
    public static Property weatherCycleModuleEnabled;
    public static Property allowPlayerExclusions;
    public static Property excludedPlayers;
    public static Property verboseLogging;
    private static Configuration configuration;

    public static void Initialize(File configFile) {
        configuration = new Configuration(configFile);
        configuration.addCustomCategoryComment(CONFIG_TIME_SHALL_NOT_PASS, CONFIG_TIME_SHALL_NOT_PASS_COMMENT);
        allowPlayerExclusions = configuration.get(CONFIG_TIME_SHALL_NOT_PASS, CONFIG_ALLOW_PLAYER_EXCLUSIONS, false, CONFIG_ALLOW_EXCLUDED_PLAYERS_DESCRIPTION);
        excludedPlayers = configuration.get(CONFIG_TIME_SHALL_NOT_PASS, CONFIG_EXCLUDED_PLAYERS, new String[0], CONFIG_EXCLUDED_PLAYERS_DESCRIPTION);
        verboseLogging = configuration.get(CONFIG_TIME_SHALL_NOT_PASS, CONFIG_VERBOSE_LOGGING, false, CONFIG_VERBOSE_LOGGING_DESCRIPTION);
        configuration.addCustomCategoryComment(CONFIG_TIME_SHALL_NOT_PASS_MODULES, CONFIG_TIME_SHALL_NOT_PASS_MODULES_COMMENT);
        daylightCycleModuleEnabled = configuration.get(CONFIG_TIME_SHALL_NOT_PASS_MODULES, CONFIG_DAYLIGHT_CYCLE_MODULE, true, CONFIG_DISABLE_DAYLIGHT_CYCLE_DESCRIPTION);
        randomTicksModuleEnabled = configuration.get(CONFIG_TIME_SHALL_NOT_PASS_MODULES, CONFIG_RANDOM_TICKS_MODULE, false, CONFIG_DISABLE_RANDOM_TICKS_DESCRIPTION);
        tileEntityTicksModuleEnabled = configuration.get(CONFIG_TIME_SHALL_NOT_PASS_MODULES, CONFIG_TILE_ENTITY_TICKS_MODULE, false, CONFIG_DISABLE_TILE_ENTITY_TICKS_DESCRIPTION);
        fireTicksModuleEnabled = configuration.get(CONFIG_TIME_SHALL_NOT_PASS_MODULES, CONFIG_FIRE_TICKS_MODULE, false, CONFIG_DISABLE_FIRE_TICKS_DESCRIPTION);
        weatherCycleModuleEnabled = configuration.get(CONFIG_TIME_SHALL_NOT_PASS_MODULES, CONFIG_WEATHER_CYCLE_MODULE, false, CONFIG_DISABLE_WEATHER_CYCLE_DESCRIPTION);
        configPropertyMap.put(CONFIG_ALLOW_PLAYER_EXCLUSIONS, allowPlayerExclusions);
        configPropertyMap.put(CONFIG_VERBOSE_LOGGING, verboseLogging);
        configPropertyMap.put(CONFIG_DAYLIGHT_CYCLE_MODULE, daylightCycleModuleEnabled);
        configPropertyMap.put(CONFIG_RANDOM_TICKS_MODULE, randomTicksModuleEnabled);
        configPropertyMap.put(CONFIG_TILE_ENTITY_TICKS_MODULE, tileEntityTicksModuleEnabled);
        configPropertyMap.put(CONFIG_FIRE_TICKS_MODULE, fireTicksModuleEnabled);
        configPropertyMap.put(CONFIG_WEATHER_CYCLE_MODULE, weatherCycleModuleEnabled);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static Tuple<Boolean, String> tryUpdateConfigurationRule(String timeShallNotPassRuleName, boolean enableRule) {
        String configurationRuleStatusMessage;
        Property timeShallNotPassRule = configPropertyMap.get(timeShallNotPassRuleName);
        if (timeShallNotPassRule != null) {
            if (timeShallNotPassRule.getBoolean() != enableRule) {
                String configurationRuleStatusMessage2;
                timeShallNotPassRule.set(enableRule);
                if (timeShallNotPassRuleName.equals(CONFIG_ALLOW_PLAYER_EXCLUSIONS)) {
                    TimeShallNotPass.SingletonInstance.reload(false);
                    configurationRuleStatusMessage2 = enableRule ? "Time Shall Not Pass is now excluding configured players." : "Time Shall Not Pass is now not excluding any players.";
                    configurationRuleStatusMessage2 = configurationRuleStatusMessage2 + " Time Shall Not Pass modules may have been toggled. Check the server console/log for more information.";
                } else if (!timeShallNotPassRuleName.equals(CONFIG_VERBOSE_LOGGING)) {
                    String moduleDisplayName = TimeShallNotPassModuleManager.getModuleDisplayName(timeShallNotPassRuleName);
                    if (enableRule) {
                        TimeShallNotPassModuleManager.enableModule(timeShallNotPassRuleName);
                        configurationRuleStatusMessage2 = String.format("The Time Shall Not Pass %s has been enabled. Check the server console/log for more information.", moduleDisplayName);
                    } else {
                        TimeShallNotPassModuleManager.disableModule(timeShallNotPassRuleName);
                        configurationRuleStatusMessage2 = String.format("The Time Shall Not Pass %s has been disabled. Check the server console/log for more information.", moduleDisplayName);
                    }
                } else {
                    configurationRuleStatusMessage2 = enableRule ? "Time Shall Not Pass is now including more information in the server console/log." : "Time Shall Not Pass is now including less information in the server console/log.";
                }
                configuration.save();
                return new Tuple((Object)true, (Object)configurationRuleStatusMessage2);
            }
            configurationRuleStatusMessage = String.format("The Time Shall Not Pass rule %s is already set to %s.", timeShallNotPassRuleName, enableRule);
        } else {
            configurationRuleStatusMessage = String.format("Could not find the given Time Shall Not Pass rule: %s", timeShallNotPassRuleName);
        }
        return new Tuple((Object)false, (Object)configurationRuleStatusMessage);
    }

    public static String queryConfigurationRule(String timeShallNotPassRuleName) {
        return String.valueOf(configPropertyMap.get(timeShallNotPassRuleName).getBoolean());
    }

    public static void updateExcludedPlayers(List<String> uniqueIds) {
        excludedPlayers.setValues(uniqueIds.toArray(new String[0]));
        configuration.save();
    }
}

