/*
 * Decompiled with CFR 0.152.
 */
package com.Gr3atsaga.TimeShallNotPass.Commands;

import com.Gr3atsaga.TimeShallNotPass.Config.TimeShallNotPassConfiguration;
import com.Gr3atsaga.TimeShallNotPass.Core.Managers.PlayerExclusionsManager;
import com.Gr3atsaga.TimeShallNotPass.Core.TimeShallNotPass;
import com.Gr3atsaga.TimeShallNotPass.Util.Helpers;
import com.Gr3atsaga.TimeShallNotPass.Util.LogService;
import java.util.HashMap;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Tuple;

public class TimeShallNotPassCommand
extends CommandBase {
    private final HashMap<String, String> subCommands = new HashMap();
    private String subCommand = null;

    public TimeShallNotPassCommand() {
        this.subCommands.put("excludedPlayers", "<add/remove> <player> [reload/defer]");
        this.subCommands.put("allowPlayerExclusions", "[true/false]");
        this.subCommands.put("refresh", "");
        this.subCommands.put("daylightCycleModule", "[true/false]");
        this.subCommands.put("randomTicksModule", "[true/false]");
        this.subCommands.put("tileEntityTicksModule", "[true/false]");
        this.subCommands.put("fireTicksModule", "[true/false]");
        this.subCommands.put("weatherCycleModule", "[true/false]");
        this.subCommands.put("verboseLogging", "[true/false]");
    }

    public String func_71517_b() {
        return "timeshallnotpass";
    }

    public String func_71518_a(ICommandSender sender) {
        if (this.subCommand != null && this.subCommands.containsKey(this.subCommand)) {
            return String.format("%s %s %s", "timeshallnotpass", this.subCommand, this.subCommands.get(this.subCommand));
        }
        return String.format("%s <%s>", "timeshallnotpass", String.join((CharSequence)"/", this.subCommands.keySet()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        this.subCommand = null;
        if (args.length <= 0) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        this.subCommand = args[0];
        if (this.subCommand.equals("excludedPlayers")) {
            this.executeExclusionsCommand(server, sender, args);
            return;
        } else if (this.subCommand.equals("refresh")) {
            this.refreshCommand(sender);
            return;
        } else if (this.subCommands.containsKey(this.subCommand)) {
            this.executeConfigRuleCommand(sender, args);
            return;
        } else {
            this.subCommand = null;
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    private void executeConfigRuleCommand(ICommandSender commandSender, String[] args) throws CommandException {
        int numArgs = args.length;
        if (numArgs == 1) {
            String configurationRule = args[0];
            TimeShallNotPassCommand.queryConfigurationRule(commandSender, configurationRule);
        } else if (numArgs == 2) {
            String configurationRule = args[0];
            boolean value = TimeShallNotPassCommand.func_180527_d((String)args[1]);
            TimeShallNotPassCommand.updateConfigurationRule(commandSender, configurationRule, value);
        } else {
            throw new WrongUsageException(this.func_71518_a(commandSender), new Object[0]);
        }
    }

    private static int queryConfigurationRule(ICommandSender commandSender, String configurationRule) {
        Helpers.sendCommandMessage(commandSender, String.format("%s is currently set to %s.", configurationRule, TimeShallNotPassConfiguration.queryConfigurationRule(configurationRule)), true);
        return 0;
    }

    private static int updateConfigurationRule(ICommandSender commandSender, String configurationRule, boolean value) {
        Tuple<Boolean, String> updateConfigurationRuleValueTuple = TimeShallNotPassConfiguration.tryUpdateConfigurationRule(configurationRule, value);
        if (((Boolean)updateConfigurationRuleValueTuple.func_76341_a()).booleanValue()) {
            Helpers.sendCommandMessage(commandSender, (String)updateConfigurationRuleValueTuple.func_76340_b(), true);
            return 0;
        }
        Helpers.sendCommandMessage(commandSender, (String)updateConfigurationRuleValueTuple.func_76340_b(), false);
        return -1;
    }

    private void executeExclusionsCommand(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        EntityPlayerMP player;
        ExclusionsAction action;
        int numArgs = args.length;
        if (numArgs == 1) {
            TimeShallNotPassCommand.queryExclusions(commandSender);
            return;
        }
        if (numArgs != 3 && numArgs != 4) {
            throw new WrongUsageException(this.func_71518_a(commandSender), new Object[0]);
        }
        try {
            action = Enum.valueOf(ExclusionsAction.class, args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new WrongUsageException(this.func_71518_a(commandSender), new Object[0]);
        }
        try {
            player = TimeShallNotPassCommand.func_184888_a((MinecraftServer)server, (ICommandSender)commandSender, (String)args[2]);
        }
        catch (Exception e) {
            throw new WrongUsageException(this.func_71518_a(commandSender), new Object[0]);
        }
        ExclusionSubAction subAction = ExclusionSubAction.RELOAD;
        if (numArgs == 4) {
            try {
                subAction = Enum.valueOf(ExclusionSubAction.class, args[3].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new WrongUsageException(this.func_71518_a(commandSender), new Object[0]);
            }
        }
        PlayerExclusionsManager.ExclusionOperation exclusionOperation = PlayerExclusionsManager.ExclusionOperation.ADD;
        switch (action) {
            case ADD: {
                exclusionOperation = subAction == ExclusionSubAction.RELOAD ? PlayerExclusionsManager.ExclusionOperation.ADD : PlayerExclusionsManager.ExclusionOperation.DEFER_ADDITION;
                break;
            }
            case REMOVE: {
                exclusionOperation = subAction == ExclusionSubAction.RELOAD ? PlayerExclusionsManager.ExclusionOperation.REMOVE : PlayerExclusionsManager.ExclusionOperation.DEFER_REMOVAL;
            }
        }
        TimeShallNotPassCommand.executeExclusionOperation(commandSender, (Entity)player, exclusionOperation);
    }

    private static int queryExclusions(ICommandSender commandSender) {
        String excludedPlayers = PlayerExclusionsManager.getExcludedPlayers();
        String message = excludedPlayers != null && !excludedPlayers.equals("") ? String.format("Excluded players: %s", excludedPlayers) : "There are currently no players excluded from Time Shall Not Pass.";
        Helpers.sendCommandMessage(commandSender, message, true);
        return 0;
    }

    private static int executeExclusionOperation(ICommandSender commandSender, Entity player, PlayerExclusionsManager.ExclusionOperation exclusionOperation) {
        String playerName;
        String uniqueId = player.func_110124_au().toString();
        Tuple<PlayerExclusionsManager.ExclusionResult, String> operationStatus = PlayerExclusionsManager.performExclusionOperation(exclusionOperation, uniqueId, playerName = player.func_70005_c_());
        if (operationStatus.func_76341_a() == PlayerExclusionsManager.ExclusionResult.SUCCESS) {
            String message = String.format("Exclusion operation successful. %s", operationStatus.func_76340_b());
            LogService.LogMessage(message);
            Helpers.sendCommandMessage(commandSender, String.format("%s Check the server console/log for more information about what has changed.", message), true);
            if (exclusionOperation == PlayerExclusionsManager.ExclusionOperation.ADD || exclusionOperation == PlayerExclusionsManager.ExclusionOperation.REMOVE) {
                TimeShallNotPass.SingletonInstance.reload(false);
            }
            return 0;
        }
        Helpers.sendCommandMessage(commandSender, String.format("Exclusion operation failed. %s", operationStatus.func_76340_b()), false);
        return -1;
    }

    private void refreshCommand(ICommandSender commandSender) {
        TimeShallNotPass.SingletonInstance.reload(true);
        Helpers.sendCommandMessage(commandSender, "Status of TimeShallNotPass! has been refreshed. Check the server console/log for more information about what has changed.", true);
    }

    private static enum ExclusionsAction {
        ADD,
        REMOVE;

    }

    private static enum ExclusionSubAction {
        RELOAD,
        DEFER;

    }
}

