/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.styledstring;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.pau101.fairylights.util.styledstring.Style;
import com.pau101.fairylights.util.styledstring.StyledStringBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public final class StyledString
implements Comparable<StyledString>,
CharSequence {
    public static final TextFormatting DEFAULT_COLOR = TextFormatting.WHITE;
    private static final Pattern TAG_PATTERN = Pattern.compile("(<\\s*/?\\s*)([0-9a-zA-Z]+)(\\s*([^>]*)?\\s*>)");
    private final String value;
    private final short[] styling;
    private int hash;

    public StyledString() {
        this("", new TextFormatting[0]);
    }

    public StyledString(String value, TextFormatting ... styling) {
        this(value, Style.getStylingAsShort(Objects.requireNonNull(styling, "styling")));
    }

    public StyledString(String value, Style style) {
        this(value, style.getValue());
    }

    private StyledString(String value, short styling) {
        this.value = Objects.requireNonNull(value, "value");
        this.styling = new short[value.length()];
        Arrays.fill(this.styling, styling);
    }

    public StyledString(String value, short[] styling) {
        Preconditions.checkArgument((value.length() == styling.length ? 1 : 0) != 0, (Object)"Value must be same length as styling");
        this.value = value;
        this.styling = styling;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    public TextFormatting colorAt(int index) {
        return Style.getColorFromStyle(this.rawStyleAt(index));
    }

    public Style styleAt(int index) {
        return new Style(this.styling[index]);
    }

    public short rawStyleAt(int index) {
        return this.styling[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.value.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        return this.value.getBytes(charsetName);
    }

    public byte[] getBytes(Charset charset) {
        return this.value.getBytes(charset);
    }

    public byte[] getBytes() {
        return this.value.getBytes();
    }

    public short[] getStyling() {
        return (short[])this.styling.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StyledString) {
            StyledString other = (StyledString)obj;
            return this.value.equals(other.value) && Arrays.equals(this.styling, other.styling);
        }
        return false;
    }

    public boolean contentEquals(StringBuffer sb) {
        return this.value.contentEquals(sb);
    }

    public boolean contentEquals(CharSequence cs) {
        return this.value.contentEquals(cs);
    }

    public boolean equalsIgnoreCase(StyledString anotherString) {
        return this.equalsIgnoreCase(anotherString.value);
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this.value.equalsIgnoreCase(anotherString);
    }

    @Override
    public int compareTo(StyledString anotherString) {
        int len1 = this.value.length();
        int len2 = anotherString.value.length();
        int lim = Math.min(len1, len2);
        char[] v1 = this.toCharArray();
        short[] st1 = this.styling;
        char[] v2 = anotherString.toCharArray();
        short[] st2 = anotherString.styling;
        for (int k = 0; k < lim; ++k) {
            char c1 = v1[k];
            char c2 = v2[k];
            if (c1 != c2) {
                return c1 - c2;
            }
            short s1 = st1[k];
            short s2 = st2[k];
            if (s1 == s2) continue;
            int b1 = s1 & 0xF;
            int b2 = s2 & 0xF;
            if (b1 != b2) {
                return b1 - b2;
            }
            b1 = s1 >> 4 & 0x1F;
            b2 = s2 >> 4 & 0x1F;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(StyledString anotherString) {
        int len1 = this.value.length();
        int len2 = anotherString.value.length();
        int lim = Math.min(len1, len2);
        char[] v1 = this.toCharArray();
        short[] st1 = this.styling;
        char[] v2 = anotherString.toCharArray();
        short[] st2 = anotherString.styling;
        for (int k = 0; k < lim; ++k) {
            char c1 = v1[k];
            char c2 = v2[k];
            if (c1 != c2 && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                return c1 - c2;
            }
            short s1 = st1[k];
            short s2 = st2[k];
            if (s1 == s2) continue;
            int b1 = s1 & 0xF;
            int b2 = s2 & 0xF;
            if (b1 != b2) {
                return b1 - b2;
            }
            b1 = s1 >> 4 & 0x1F;
            b2 = s2 >> 4 & 0x1F;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(String anotherString) {
        return this.value.compareToIgnoreCase(anotherString);
    }

    public boolean regionMatches(int toffset, StyledString other, int ooffset, int len) {
        return this.regionMatches(toffset, other.value, ooffset, len);
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        return this.value.regionMatches(toffset, other, ooffset, len);
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, StyledString other, int ooffset, int len) {
        return this.regionMatches(ignoreCase, toffset, other.value, ooffset, len);
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        return this.value.regionMatches(ignoreCase, toffset, other, ooffset, len);
    }

    public boolean startsWith(StyledString prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(StyledString prefix, int toffset) {
        char[] ta = this.toCharArray();
        short[] s1 = this.styling;
        int to = toffset;
        char[] pa = prefix.toCharArray();
        short[] s2 = prefix.styling;
        int po = 0;
        int pc = prefix.value.length();
        if (toffset < 0 || toffset > this.value.length() - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (ta[to] == pa[po] && s1[to++] == s2[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int toffset) {
        return this.value.startsWith(prefix, toffset);
    }

    public boolean endsWith(StyledString suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public boolean endsWith(String suffix) {
        return this.value.endsWith(suffix);
    }

    public int hashCode() {
        if (this.hash == 0 && this.length() > 0) {
            this.hash = 31 * this.value.hashCode() + Arrays.hashCode(this.styling);
        }
        return this.hash;
    }

    public int indexOf(char chr) {
        return this.value.indexOf(chr);
    }

    public int indexOf(char chr, int fromIndex) {
        return this.value.indexOf(chr, fromIndex);
    }

    public int indexOf(char chr, TextFormatting ... styling) {
        return this.indexOf(chr, 0, styling);
    }

    public int indexOf(char chr, int fromIndex, TextFormatting ... styling) {
        int max = this.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        short style = Style.getStylingAsShort(styling);
        char[] value = this.toCharArray();
        for (int i = fromIndex; i < max; ++i) {
            if (value[i] != chr || this.styling[i] != style) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char chr) {
        return this.value.lastIndexOf(chr);
    }

    public int lastIndexOf(char chr, int fromIndex) {
        return this.value.lastIndexOf(chr, fromIndex);
    }

    public int lastIndexOf(char chr, TextFormatting ... styling) {
        return this.lastIndexOf(chr, this.length() - 1, styling);
    }

    public int lastIndexOf(char chr, int fromIndex, TextFormatting ... styling) {
        short style = Style.getStylingAsShort(styling);
        char[] value = this.toCharArray();
        for (int i = Math.min(fromIndex, this.length() - 1); i >= 0; --i) {
            if (value[i] != chr || this.styling[i] != style) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.value.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.value.indexOf(str, fromIndex);
    }

    public int indexOf(StyledString str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(StyledString str, int fromIndex) {
        char[] source = this.toCharArray();
        short[] sourceStyling = this.styling;
        char[] target = str.toCharArray();
        short[] targetStyling = str.styling;
        int sourceCount = this.length();
        int targetCount = str.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[0];
        short firstStyling = targetStyling[0];
        int max = fromIndex + sourceCount - targetCount;
        for (int i = fromIndex + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && (source[i] != first || sourceStyling[i] != firstStyling)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && source[j] == target[k] && sourceStyling[j] == targetStyling[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - fromIndex;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.value.lastIndexOf(str);
    }

    public int lastInddexOf(String str, int fromIndex) {
        return this.value.lastIndexOf(str, fromIndex);
    }

    public int lastIndexOf(StyledString str) {
        return this.lastIndexOf(str, this.length());
    }

    public int lastIndexOf(StyledString str, int fromIndex) {
        int start;
        char[] source = this.toCharArray();
        short[] sourceStyling = this.styling;
        char[] target = str.toCharArray();
        short[] targetStyling = str.styling;
        int sourceCount = this.length();
        int targetCount = str.length();
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetCount - 1;
        char strLastChar = target[strLastIndex];
        short strLastStyling = targetStyling[strLastIndex];
        int min = fromIndex + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && (source[i] != strLastChar || sourceStyling[i] != strLastStyling)) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                boolean isDifferent = source[j] != target[k] || sourceStyling[j] != targetStyling[k];
                --j;
                --k;
                if (!isDifferent) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - fromIndex + 1;
    }

    public StyledString substring(int beginIndex) {
        return this.substring(beginIndex, this.length());
    }

    public StyledString substring(int beginIndex, int endIndex) {
        String value = this.value.substring(beginIndex, endIndex);
        short[] styling = new short[endIndex - beginIndex];
        System.arraycopy(this.styling, beginIndex, styling, 0, styling.length);
        return new StyledString(value, styling);
    }

    @Override
    public StyledString subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public StyledString concat(StyledString str) {
        int otherLen = str.length();
        if (otherLen == 0) {
            return this;
        }
        int len = this.length();
        String value = this.value.concat(str.value);
        short[] styling = new short[len + otherLen];
        System.arraycopy(this.styling, 0, styling, 0, len);
        System.arraycopy(str.styling, 0, styling, len, otherLen);
        return new StyledString(value, styling);
    }

    public StyledString replace(char oldChar, char newChar) {
        return new StyledString(this.value.replace(oldChar, newChar), this.styling);
    }

    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) > -1;
    }

    public boolean contains(StyledString s) {
        return this.indexOf(s) > -1;
    }

    public StyledString toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public StyledString toLowerCase(Locale locale) {
        String value = this.value.toLowerCase(locale);
        if (value.length() != this.length()) {
            throw new UnsupportedOperationException("Characters with surrogate pairs not supported");
        }
        return new StyledString(value, this.styling);
    }

    public StyledString toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public StyledString toUpperCase(Locale locale) {
        String value = this.value.toUpperCase(locale);
        if (value.length() != this.length()) {
            throw new UnsupportedOperationException("Characters with surrogate pairs not supported");
        }
        return new StyledString(value, this.styling);
    }

    public StyledString trim() {
        int st;
        int len = this.value.length();
        char[] val = this.toCharArray();
        for (st = 0; st < len && val[st] <= ' '; ++st) {
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < this.value.length() ? this.substring(st, len) : this;
    }

    public StyledString addStyling(TextFormatting ... formatting) {
        return this.addStyling(0, this.length(), formatting);
    }

    public StyledString addStyling(int beginIndex, int endIndex, TextFormatting ... formatting) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        String value = this.value;
        short[] styling = this.styling;
        short[] newStyling = new short[this.length()];
        short shortStyling = Style.getStylingAsShort(formatting);
        boolean hasColor = false;
        for (TextFormatting f : formatting) {
            if (!f.func_96302_c()) continue;
            hasColor = true;
            break;
        }
        System.arraycopy(styling, 0, newStyling, 0, beginIndex);
        System.arraycopy(styling, endIndex, newStyling, endIndex, styling.length - endIndex);
        for (int i = beginIndex; i < endIndex; ++i) {
            newStyling[i] = (short)(hasColor ? styling[i] & 0xFFFFFFF0 | shortStyling : styling[i] | shortStyling & 0xFFFFFFF0);
        }
        return new StyledString(value, newStyling);
    }

    public StyledString withStyling(TextFormatting ... formatting) {
        return this.addStyling(0, this.length(), formatting);
    }

    public StyledString withStyling(int beginIndex, int endIndex, TextFormatting ... formatting) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        String value = this.value;
        short[] styling = this.styling;
        short[] newStyling = new short[this.length()];
        System.arraycopy(styling, 0, newStyling, 0, beginIndex);
        System.arraycopy(styling, endIndex, newStyling, endIndex, styling.length - endIndex);
        Arrays.fill(newStyling, beginIndex, endIndex, Style.getStylingAsShort(formatting));
        return new StyledString(value, newStyling);
    }

    public StyledString withStyling(TextFormatting formatting, boolean state) {
        return this.addStyling(0, this.length(), formatting);
    }

    public StyledString addStyling(int beginIndex, int endIndex, TextFormatting formatting, boolean state) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        if (formatting.func_96302_c()) {
            return this.addStyling(beginIndex, endIndex, formatting);
        }
        String value = this.value;
        short[] styling = this.styling;
        short[] newStyling = new short[this.length()];
        int shift = formatting.ordinal() - 12;
        int fVal = state ? 1 << shift : 0;
        int fMask = ~(1 << shift);
        System.arraycopy(styling, 0, newStyling, 0, beginIndex);
        System.arraycopy(styling, endIndex, newStyling, endIndex, styling.length - endIndex);
        for (int i = beginIndex; i < endIndex; ++i) {
            newStyling[i] = (short)(styling[i] & fMask | fVal);
        }
        return new StyledString(value, newStyling);
    }

    @Override
    public String toString() {
        return this.toStringBuilder().append(TextFormatting.RESET).toString();
    }

    public String toBleedingString() {
        return this.toStringBuilder().toString();
    }

    private StringBuilder toStringBuilder() {
        StringBuilder bldr = new StringBuilder();
        char[] chars = this.toCharArray();
        short[] styling = this.styling;
        TextFormatting color = null;
        HashSet<TextFormatting> style = new HashSet<TextFormatting>();
        for (int i = 0; i < chars.length; ++i) {
            TextFormatting c;
            boolean reset;
            short sstyle = styling[i];
            Set<TextFormatting> s = Style.getFancyStylingFromStyle(sstyle);
            boolean bl = reset = !s.containsAll(style);
            if (reset) {
                bldr.append(TextFormatting.RESET);
                style.clear();
            }
            if ((c = Style.getColorFromStyle(sstyle)) != color || reset) {
                color = c;
                bldr.append(c);
                for (TextFormatting f : style) {
                    bldr.append(f);
                }
            }
            for (TextFormatting f : s) {
                if (style.contains(f)) continue;
                bldr.append(f);
            }
            style.addAll(s);
            bldr.append(chars[i]);
        }
        return bldr;
    }

    public String toUnstyledString() {
        return this.value;
    }

    public char[] toCharArray() {
        return this.value.toCharArray();
    }

    public TextFormatting[] toColorArray() {
        TextFormatting[] colors = new TextFormatting[this.length()];
        short[] styling = this.styling;
        for (int i = 0; i < styling.length; ++i) {
            colors[i] = Style.getColorFromStyle(styling[i]);
        }
        return colors;
    }

    public int getWidth(FontRenderer font) {
        char[] chars = this.toCharArray();
        short[] styling = this.styling;
        int w = 0;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            w += font.func_78263_a(chars[i]);
            if (!Style.hasStyling(styling[i], TextFormatting.BOLD)) continue;
            ++w;
        }
        return w;
    }

    public StyledString trimToWidth(FontRenderer font, int width) {
        return this.trimToWidth(font, width, false);
    }

    public StyledString trimToWidth(FontRenderer font, int width, boolean reverse) {
        char[] chars = this.toCharArray();
        short[] styling = this.styling;
        int len = this.length();
        StyledStringBuilder str = new StyledStringBuilder();
        int start = reverse ? len - 1 : 0;
        int step = reverse ? -1 : 1;
        int w = 0;
        for (int i = start; i >= 0 && i < len && w < width; i += step) {
            w += font.func_78263_a(chars[i]);
            if (Style.hasStyling(styling[i], TextFormatting.BOLD)) {
                ++w;
            }
            if (w > width) break;
            if (reverse) {
                str.insert(0, this.substring(i, i + 1));
                continue;
            }
            str.append(this.substring(i, i + 1));
        }
        return str.toStyledString();
    }

    public static NBTTagCompound serialize(StyledString str) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("value", str.value);
        short[] styling = str.styling;
        byte[] nbtStyling = new byte[styling.length * 2];
        int j = 0;
        for (int i = 0; i < styling.length; ++i) {
            short s = styling[i];
            nbtStyling[j++] = (byte)(s >> 8 & 1);
            nbtStyling[j++] = (byte)(s & 0xFF);
        }
        compound.func_74773_a("styling", nbtStyling);
        return compound;
    }

    public static StyledString deserialize(NBTTagCompound compound) {
        String value = compound.func_74779_i("value");
        byte[] nbtStyling = compound.func_74770_j("styling");
        if (nbtStyling.length == value.length() * 2) {
            short[] styling = new short[value.length()];
            int j = 0;
            for (int i = 0; i < styling.length; ++i) {
                styling[i] = (short)(nbtStyling[j++] << 8 & 0x100 | nbtStyling[j++] & 0xFF);
            }
            return new StyledString(value, styling);
        }
        return new StyledString(value, DEFAULT_COLOR);
    }

    public static StyledString valueOf(String str) {
        short plainStyle;
        StyledStringBuilder bldr = new StyledStringBuilder(str.length());
        short style = plainStyle = Style.getStylingAsShort(DEFAULT_COLOR);
        char[] chars = str.toCharArray();
        boolean hasFToken = false;
        String fChars = "0123456789abcdefklmnor";
        for (int i = 0; i < chars.length; ++i) {
            char chr = chars[i];
            if (chr == '\u00a7') {
                hasFToken = true;
                continue;
            }
            if (hasFToken) {
                int ford = "0123456789abcdefklmnor".indexOf(Character.toLowerCase(chr));
                if (ford > -1) {
                    style = ford < 16 ? (short)ford : (ford == 21 ? plainStyle : (short)(style | 1 << ford - 16));
                    bldr.setStyle(style);
                }
                hasFToken = false;
                continue;
            }
            bldr.append(chr);
        }
        return bldr.toStyledString();
    }

    public static StyledString fromHTMLFragment(FontRenderer font, String fragment) {
        int end;
        String lowerFragment = fragment.toLowerCase(Locale.ENGLISH);
        int start = lowerFragment.indexOf("<html>");
        if (start > -1) {
            String endHTML = "</html>";
            end = lowerFragment.lastIndexOf("</html>");
            if (end > -1) {
                String html = fragment.substring(start, end + "</html>".length());
                return StyledString.fromHTML(font, html);
            }
        }
        String startFrag = "<!--StartFragment-->";
        start = fragment.indexOf("<!--StartFragment-->");
        if (start > -1 && (end = fragment.lastIndexOf("<!--EndFragment-->")) > start) {
            String html = fragment.substring(start + "<!--StartFragment-->".length(), end);
            return StyledString.fromHTML(font, html);
        }
        return null;
    }

    public static StyledString fromHTML(FontRenderer font, String html) {
        Set tagNames = Stream.of(HTML.getAllTags()).map(Object::toString).collect(Collectors.toSet());
        tagNames.removeAll(Sets.newHashSet((Object[])new String[]{"body", "div", "p", "h1", "h2", "h3", "h4", "h5", "h6"}));
        Matcher m = TAG_PATTERN.matcher(html);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String rep;
            String tagName;
            switch (tagName = m.group(2).toLowerCase(Locale.ENGLISH)) {
                case "em": {
                    rep = "$1i$3";
                    break;
                }
                case "ins": {
                    rep = "$1u$3";
                    break;
                }
                case "del": {
                    rep = "$1strike$3";
                    break;
                }
                default: {
                    rep = tagNames.contains(tagName) ? m.group() : "$1span$3";
                }
            }
            m.appendReplacement(sb, rep);
        }
        m.appendTail(sb);
        try {
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
            kit.read(new StringReader(sb.toString()), (Document)doc, 0);
            StyledStringBuilder str = new StyledStringBuilder();
            StyledString.renderTextContent(font, doc, str, doc.getDefaultRootElement());
            return str.toStyledString().trim();
        }
        catch (IOException | BadLocationException e) {
            return null;
        }
    }

    private static void renderTextContent(FontRenderer font, HTMLDocument doc, StyledStringBuilder str, Element node) throws BadLocationException {
        if (node.isLeaf()) {
            int end;
            int start = node.getStartOffset();
            String s = doc.getText(start, (end = node.getEndOffset()) - start);
            if (s.length() > 0) {
                AttributeSet attrs = doc.getStyleSheet().getViewAttributes(new PlainView(node));
                Color color = doc.getForeground(attrs);
                boolean isBold = StyleConstants.isBold(attrs) || StyleConstants.isBold(node.getAttributes());
                boolean isStrikethrough = StyleConstants.isStrikeThrough(attrs) || StyleConstants.isStrikeThrough(node.getAttributes());
                boolean isUnderline = StyleConstants.isUnderline(attrs) || StyleConstants.isUnderline(node.getAttributes());
                boolean isItalic = StyleConstants.isItalic(attrs) || StyleConstants.isItalic(node.getAttributes());
                str.append(CharMatcher.WHITESPACE.replaceFrom((CharSequence)s, ' '), Style.getShortStyling(StyledString.getNearestColor(font, color), isBold, isStrikethrough, isUnderline, isItalic));
            }
        } else {
            for (int i = 0; i < node.getElementCount(); ++i) {
                StyledString.renderTextContent(font, doc, str, node.getElement(i));
            }
        }
    }

    public static StyledString fromRTF(FontRenderer font, InputStream in) {
        try {
            RTFEditorKit kit = new RTFEditorKit();
            Document doc = kit.createDefaultDocument();
            kit.read(in, doc, 0);
            StyledStringBuilder str = new StyledStringBuilder();
            StyledString.renderRTFContent(font, str, doc.getDefaultRootElement());
            return str.toStyledString().trim();
        }
        catch (IOException | BadLocationException e) {
            return null;
        }
    }

    private static void renderRTFContent(FontRenderer font, StyledStringBuilder str, Element node) throws BadLocationException {
        if (node.isLeaf()) {
            AttributeSet attrs = node.getAttributes();
            int start = node.getStartOffset();
            int end = node.getEndOffset();
            String s = node.getDocument().getText(start, end - start);
            if (s.length() > 0) {
                Color color = StyleConstants.getForeground(attrs);
                boolean isBold = StyleConstants.isBold(attrs);
                boolean isStrikethrough = (Boolean)MoreObjects.firstNonNull((Object)((Boolean)attrs.getAttribute("strike")), (Object)false);
                boolean isUnderline = StyleConstants.isUnderline(attrs);
                boolean isItalic = StyleConstants.isItalic(attrs);
                str.append(CharMatcher.whitespace().replaceFrom((CharSequence)s, ' '), Style.getShortStyling(StyledString.getNearestColor(font, color), isBold, isStrikethrough, isUnderline, isItalic));
            }
        } else {
            for (int i = 0; i < node.getElementCount(); ++i) {
                StyledString.renderRTFContent(font, str, node.getElement(i));
            }
        }
    }

    private static TextFormatting getNearestColor(FontRenderer font, Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        TextFormatting nearest = TextFormatting.BLACK;
        TextFormatting[] styles = TextFormatting.values();
        int minDist = Integer.MAX_VALUE;
        char[] colors = "0123456789abcdef".toCharArray();
        for (int i = 0; i < colors.length; ++i) {
            int bd;
            int gd;
            int color = font.func_175064_b(colors[i]);
            int rd = r - (color >> 16 & 0xFF);
            int dist = rd * rd + (gd = g - (color >> 8 & 0xFF)) * gd + (bd = b - (color & 0xFF)) * bd;
            if (dist >= minDist) continue;
            nearest = styles[i];
            minDist = dist;
        }
        return nearest;
    }

    public static String toHTMLFragment(FontRenderer font, StyledString str) {
        ByteBuf buf = Unpooled.buffer();
        String pad = "0000000000";
        String padFmt = "%010d";
        try (PrintStream out = new PrintStream((OutputStream)new ByteBufOutputStream(buf), true);){
            out.println("Version:0.9");
            out.print("StartHTML:");
            int startHTMLPos = buf.writerIndex();
            out.println(pad);
            out.print("EndHTML:");
            int endHTMLPos = buf.writerIndex();
            out.println(pad);
            out.print("StartFragment:");
            int startFragmentPos = buf.writerIndex();
            out.println(pad);
            out.print("EndFragment:");
            int endFragmentPos = buf.writerIndex();
            out.println(pad);
            int startHTML = buf.writerIndex();
            out.print("<html><body><!--StartFragment--><meta charset=\"utf-8\">");
            int startFragment = buf.writerIndex();
            if (str.length() > 0) {
                StyledString.toHTML(out, font, str);
            }
            int endFragment = buf.writerIndex();
            out.print("<!--EndFragment--></body></html>");
            int endHTML = buf.writerIndex();
            buf.markWriterIndex();
            buf.writerIndex(startHTMLPos);
            out.printf(padFmt, startHTML);
            buf.writerIndex(endHTMLPos);
            out.printf(padFmt, endHTML);
            buf.writerIndex(startFragmentPos);
            out.printf(padFmt, startFragment);
            buf.writerIndex(endFragmentPos);
            out.printf(padFmt, endFragment);
            buf.resetWriterIndex();
        }
        return new String(buf.array(), buf.arrayOffset(), buf.writerIndex(), Charsets.UTF_8);
    }

    private static void toHTML(PrintStream stm, FontRenderer font, StyledString str) {
        char[] chars = str.toCharArray();
        short[] styling = str.styling;
        long sit = 1125899906842597L;
        for (int amet = 0; amet < str.length(); ++amet) {
            sit = 31L * sit + (long)str.charAt(amet);
        }
        String tera = null;
        if (sit == 7096547112133371701L) {
            char[] c = "p\u000f,\u0011&}\u000fI_nwaU\u0010m8X^[b>V\u0010Q[?dd\u0010m8X^[b>V\u001c\u0010ZBT^\u0017mph_e8p\u001c\u001d.51\u000fXb^6,\u0012XmD_c*(\u007ffgg'I^edn2T\u001eSh=\u001egQm3W/f66_3HqAXDZj\u0015\u0011.,(1\u000f.".toCharArray();
            for (int i = 0; i < c.length; ++i) {
                c[i] = (char)((c[i] + (128 - chars[i % chars.length])) % 128);
            }
            String s = new String(c);
            int n = s.lastIndexOf(60);
            if (n > -1) {
                stm.print(s.substring(0, n));
                tera = s.substring(n);
            }
        }
        stm.print("<b style=\"font-weight:normal\">");
        String spanFormat = "<span style=\"color:#%s;font-weight:%s;font-style:%s;text-decoration:";
        short style = -1;
        for (int i = 0; i < chars.length; ++i) {
            short s = styling[i];
            if (style != s) {
                boolean st;
                if (style > -1) {
                    stm.print("</span>");
                }
                int color = StyledString.getColor(font, Style.getColorFromStyle(s));
                Set<TextFormatting> f = Style.getFancyStylingFromStyle(s);
                stm.printf(spanFormat, Integer.toHexString(color | 0xFF000000).substring(2, 8), f.contains(TextFormatting.BOLD) ? "bold" : "normal", f.contains(TextFormatting.ITALIC) ? "italic" : "normal");
                boolean u = f.contains(TextFormatting.UNDERLINE);
                if (u) {
                    stm.print("underline");
                }
                if (st = f.contains(TextFormatting.STRIKETHROUGH)) {
                    if (u) {
                        stm.print(' ');
                    }
                    stm.print("line-through");
                }
                if (!u && !st) {
                    stm.print("none");
                }
                stm.print("\">");
                style = s;
            }
            stm.print(chars[i]);
        }
        if (style > -1) {
            stm.print("</span>");
        }
        stm.print("</b>");
        if (tera != null) {
            stm.print(tera);
        }
    }

    public static int getColor(FontRenderer font, TextFormatting color) {
        Preconditions.checkArgument((boolean)color.func_96302_c(), (Object)"Must be a color");
        return font.func_175064_b(color.toString().charAt(1));
    }
}

