/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import com.pau101.fairylights.util.crafting.GenericRecipe;
import com.pau101.fairylights.util.crafting.ingredient.IngredientRegular;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;

public class IngredientRegularList
implements IngredientRegular {
    private final List<IngredientRegular> ingredients;

    public IngredientRegularList(IngredientRegular ... ingredients) {
        this(Arrays.asList(ingredients));
    }

    public IngredientRegularList(List<IngredientRegular> ingredients) {
        this.ingredients = Objects.requireNonNull(ingredients, "ingredients");
    }

    @Override
    public final GenericRecipe.MatchResultRegular matches(ItemStack input, ItemStack output) {
        GenericRecipe.MatchResultRegular matchResult = null;
        ArrayList<GenericRecipe.MatchResultRegular> supplementaryResults = new ArrayList<GenericRecipe.MatchResultRegular>(this.ingredients.size());
        for (IngredientRegular ingredient : this.ingredients) {
            GenericRecipe.MatchResultRegular result = (GenericRecipe.MatchResultRegular)ingredient.matches(input, output);
            if (result.doesMatch() && matchResult == null) {
                matchResult = result;
                continue;
            }
            supplementaryResults.add(result);
        }
        if (matchResult == null) {
            return new GenericRecipe.MatchResultRegular(this, input, false, supplementaryResults);
        }
        return matchResult.withParent(new GenericRecipe.MatchResultRegular(this, input, true, supplementaryResults));
    }

    @Override
    public ImmutableList<ItemStack> getInputs() {
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (IngredientRegular ingredient : this.ingredients) {
            inputs.addAll(ingredient.getInputs());
        }
        return inputs.build();
    }

    @Override
    public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
        ArrayList inputs = new ArrayList();
        for (IngredientRegular ingredient : this.ingredients) {
            ImmutableList<ImmutableList<ItemStack>> immutableList = ingredient.getInput(output);
            for (int i = 0; i < immutableList.size(); ++i) {
                ArrayList stacks;
                if (i < inputs.size()) {
                    stacks = (ArrayList)inputs.get(i);
                } else {
                    stacks = new ArrayList();
                    inputs.add(stacks);
                }
                stacks.addAll((Collection)immutableList.get(i));
            }
        }
        ImmutableList.Builder inputsImm = ImmutableList.builder();
        for (List list : inputs) {
            inputsImm.add((Object)ImmutableList.copyOf((Collection)list));
        }
        return inputsImm.build();
    }

    public String toString() {
        return this.ingredients.toString();
    }
}

