/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.item;

import com.google.common.base.CaseFormat;
import com.pau101.fairylights.server.item.FLItems;
import com.pau101.fairylights.server.item.crafting.Recipes;
import com.pau101.fairylights.util.Utils;
import com.pau101.fairylights.util.crafting.GenericRecipeBuilder;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public enum LightVariant {
    FAIRY("fairy", true, 5.0f, 5.0f, () -> new GenericRecipeBuilder().withShape(" I ", "IDI", " G ").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('G', "paneGlassColorless")),
    PAPER("paper", false, 9.0f, 16.5f, () -> new GenericRecipeBuilder().withShape(" I ", "PDP", "PPP").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('P', Items.field_151121_aF)),
    ORB("orb", false, 10.0f, 11.5f, () -> new GenericRecipeBuilder().withShape(" I ", "SDS", " W ").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('S', Items.field_151007_F).withIngredient('W', Blocks.field_150325_L)),
    FLOWER("flower", true, 10.0f, 6.0f, () -> new GenericRecipeBuilder().withShape(" I ", "RDB", " Y ").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('R', (Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.POPPY.func_176968_b()).withIngredient('Y', (Block)Blocks.field_150327_N).withIngredient('B', (Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b())),
    ORNATE("ornate", false, 24.0f, 8.0f, 12.0f, () -> new GenericRecipeBuilder().withShape(" I ", "GDG", "IGI").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('G', "nuggetGold")),
    OIL("oil", false, 32.0f, 8.0f, 13.5f, () -> new GenericRecipeBuilder().withShape(" I ", "SDS", "IGI").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('S', "stickWood").withIngredient('G', "paneGlassColorless")),
    LUXO_BALL("luxo_ball", true, 5.0f, 5.0f, () -> new GenericRecipeBuilder().withShape(" I ", "BBB", "YRY").withIngredient('I', "ingotIron").withIngredient('B', "dyeBlue").withIngredient('Y', "dyeYellow").withIngredient('R', "dyeRed")),
    JACK_O_LANTERN("jack_o_lantern", true, 7.0f, 9.5f, () -> new GenericRecipeBuilder().withShape(" I ", "SDS", "GPG").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('S', "slabWood").withIngredient('G', Blocks.field_150478_aa).withIngredient('P', Blocks.field_150423_aK)),
    SKULL("skull", true, 6.0f, 9.0f, () -> new GenericRecipeBuilder().withShape(" I ", "IDI", " B ").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withAnyIngredient('B', Items.field_151103_aS, new ItemStack(Items.field_151144_bL, 1, 0))),
    GHOST("ghost", true, 6.0f, 8.0f, () -> new GenericRecipeBuilder().withShape(" I ", "PDP", "IGI").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('P', Items.field_151121_aF).withIngredient('G', "paneGlassWhite")),
    SPIDER("spider", true, 12.0f, 14.0f, () -> new GenericRecipeBuilder().withShape(" I ", "WDW", "SES").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('W', Blocks.field_150321_G).withIngredient('S', Items.field_151007_F).withIngredient('E', Items.field_151070_bp)),
    WITCH("witch", true, 8.0f, 10.0f, () -> new GenericRecipeBuilder().withShape(" I ", "BDW", " S ").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('B', Items.field_151069_bo).withIngredient('W', Items.field_151015_O).withIngredient('S', "stickWood")),
    SNOWFLAKE("snowflake", true, 8.0f, 12.5f, () -> new GenericRecipeBuilder().withShape(" I ", "SDS", " G ").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('S', Items.field_151126_ay).withIngredient('G', "paneGlassWhite")),
    ICICLE("icicle", false, 10.0f, 7.0f, 20.0f, () -> new GenericRecipeBuilder().withShape(" I ", "GDG", " B ").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('G', "paneGlassColorless").withAnyIngredient('B', Items.field_151131_as, Blocks.field_150432_aD, Blocks.field_150403_cj)),
    METEOR("meteor", false, 24.0f, 3.0f, 28.5f, () -> new GenericRecipeBuilder().withShape(" I ", "GDG", "IPI").withIngredient('I', "ingotIron").withIngredient('D', Recipes.LIGHT_DYE).withIngredient('G', Items.field_151114_aO).withIngredient('P', Items.field_151121_aF), 0.02f, 100);

    private final String name;
    private final String unlocalizedName;
    private final boolean parallelsCord;
    private final float spacing;
    private final float width;
    private final float height;
    private final Supplier<GenericRecipeBuilder> recipe;
    private final float twinkleChance;
    private final int tickCycle;
    private final boolean alwaysTwinkle;

    private LightVariant(String name, boolean parallelsCord, float width, float height, Supplier<GenericRecipeBuilder> recipe) {
        this(name, parallelsCord, 16.0f, width, height, recipe);
    }

    private LightVariant(String name, boolean parallelsCord, float spacing, float width, float height, Supplier<GenericRecipeBuilder> recipe) {
        this(name, parallelsCord, spacing, width, height, recipe, 0.05f, 40, false);
    }

    private LightVariant(String name, boolean parallelsCord, float spacing, float width, float height, Supplier<GenericRecipeBuilder> recipe, float twinkleChance, int tickCycle) {
        this(name, parallelsCord, spacing, width, height, recipe, twinkleChance, tickCycle, true);
    }

    private LightVariant(String name, boolean parallelsCord, float spacing, float width, float height, Supplier<GenericRecipeBuilder> recipe, float twinkleChance, int tickCycle, boolean alwaysTwinkle) {
        this.name = name;
        this.parallelsCord = parallelsCord;
        this.spacing = spacing;
        this.width = width / 16.0f;
        this.height = height / 16.0f;
        this.recipe = recipe;
        this.twinkleChance = twinkleChance;
        this.tickCycle = tickCycle;
        this.alwaysTwinkle = alwaysTwinkle;
        this.unlocalizedName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
    }

    public String getName() {
        return this.name;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public boolean parallelsCord() {
        return this.parallelsCord;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public IRecipe getRecipe() {
        return (IRecipe)this.recipe.get().withOutput(FLItems.LIGHT, 4, this.getFirstMeta()).build().setRegistryName(this.name);
    }

    public float getTwinkleChance() {
        return this.twinkleChance;
    }

    public int getTickCycle() {
        return this.tickCycle;
    }

    public boolean alwaysDoTwinkleLogic() {
        return this.alwaysTwinkle;
    }

    public int getFirstMeta() {
        return this.ordinal() * 16;
    }

    public static LightVariant getLightVariant(int index) {
        return Utils.getEnumValue(LightVariant.class, index);
    }
}

