/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.connection;

import com.pau101.fairylights.client.model.AdvancedModelRenderer;
import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.client.renderer.FastenerRenderer;
import com.pau101.fairylights.server.fastener.connection.type.garland.ConnectionGarlandVine;
import com.pau101.fairylights.util.RandomArray;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class ModelConnectionGarland
extends ModelConnection<ConnectionGarlandVine> {
    private static final int RING_COUNT = 8;
    private static final float RINGS_PER_METER = 4.0f;
    private static final RandomArray RAND = new RandomArray(8411L, 32);
    private AdvancedModelRenderer cordModel = new AdvancedModelRenderer(this, 39, 0);
    private int ringId = -1;
    private int uniquifier;

    public ModelConnectionGarland() {
        this.cordModel.addBox(-0.5f, -0.5f, 0.0f, 1, 1, 1);
    }

    private void generateGarlandRings() {
        this.ringId = GLAllocation.func_74526_a((int)8);
        for (int i = 0; i < 8; ++i) {
            GlStateManager.func_187423_f((int)(this.ringId + i), (int)4864);
            FastenerRenderer.render3DTexture(8, 8, i * 8, 64);
            GlStateManager.func_187415_K();
        }
    }

    @Override
    public void renderCord(ConnectionGarlandVine connection, World world, int sunlight, int moonlight, float delta) {
        this.uniquifier = connection.hashCode();
        super.renderCord(connection, world, sunlight, moonlight, delta);
    }

    @Override
    protected void renderSegment(ConnectionGarlandVine garland, int index, double angleX, double angleY, double length, double x, double y, double z, float delta) {
        if (this.ringId == -1) {
            this.generateGarlandRings();
        }
        this.cordModel.field_78795_f = (float)angleX;
        this.cordModel.field_78796_g = (float)angleY;
        this.cordModel.scaleZ = (float)length;
        this.cordModel.setRotationPoint(x, y, z);
        this.cordModel.func_78785_a(0.0625f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x / 16.0), (double)(y / 16.0), (double)(z / 16.0));
        GlStateManager.func_179114_b((float)((float)angleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)angleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        int rings = MathHelper.func_76143_f((double)(length * 4.0 / 16.0)) + 1;
        for (int i = 0; i < rings; ++i) {
            double t = (double)((float)i / (float)rings) * length / 16.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)t);
            float rotZ = RAND.get(index + i + this.uniquifier) * 45.0f;
            float rotY = RAND.get(index + i + 8 + this.uniquifier) * 60.0f + 90.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.25f, (float)-0.25f, (float)-0.03125f);
            int ring = this.ringId + index % 8;
            GlStateManager.func_179148_o((int)ring);
            GlStateManager.func_179121_F();
            GlStateManager.func_179114_b((float)(rotZ + 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.875f, (float)0.875f, (float)0.875f);
            GlStateManager.func_179109_b((float)-0.25f, (float)-0.25f, (float)-0.03125f);
            GlStateManager.func_179148_o((int)ring);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }
}

