/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client;

import com.google.common.collect.Sets;
import com.pau101.fairylights.server.block.entity.BlockEntityFastener;
import com.pau101.fairylights.server.capability.CapabilityHandler;
import com.pau101.fairylights.server.entity.EntityFenceFastener;
import com.pau101.fairylights.server.fastener.CollectFastenersEvent;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.FastenerType;
import com.pau101.fairylights.server.fastener.connection.Catenary;
import com.pau101.fairylights.server.fastener.connection.PlayerAction;
import com.pau101.fairylights.server.fastener.connection.Segment;
import com.pau101.fairylights.server.fastener.connection.collision.ConnectionCollision;
import com.pau101.fairylights.server.fastener.connection.collision.Intersection;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.ConnectionHangingLights;
import com.pau101.fairylights.server.jingle.Jingle;
import com.pau101.fairylights.util.Mth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class ClientEventHandler {
    private static final float HIGHLIGHT_ALPHA = 0.4f;
    @Nullable
    private static HitConnection hit;
    @Nullable
    private Vec3d prevCatenaryVec;
    @Nullable
    private VertexBuffer connHighlightVBO;
    private int connHighlightId;
    private boolean useVBO;

    @Nullable
    public static Connection getHitConnection() {
        return hit == null || hit.result == null ? null : hit.result.connection;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (event.phase != TickEvent.Phase.START && world != null) {
            this.getBlockEntities((World)world).stream().filter(BlockEntityFastener.class::isInstance).map(BlockEntityFastener.class::cast).forEach(f -> ((Fastener)f.getCapability(CapabilityHandler.FASTENER_CAP, null)).update());
        }
    }

    private Collection<TileEntity> getBlockEntities(World world) {
        try {
            return new ArrayList<TileEntity>(world.field_147482_g);
        }
        catch (ConcurrentModificationException e) {
            return Collections.emptyList();
        }
    }

    @SubscribeEvent
    public void gatherOverlayText(RenderGameOverlayEvent.Text event) {
        if (hit == null || hit.result == null) {
            return;
        }
        Connection conn = hit.result.connection;
        if (!(conn instanceof ConnectionHangingLights)) {
            return;
        }
        Jingle jingle = ((ConnectionHangingLights)conn).getPlayingJingle();
        if (jingle != null) {
            ArrayList lines = event.getRight();
            if (lines.size() > 0) {
                lines.add("");
            }
            lines.add("Song: " + jingle.getName());
            lines.add("Artist: " + jingle.getArtist());
        }
    }

    @SubscribeEvent
    public void renderWorldEarly(EntityViewRenderEvent.FogColors event) {
        if (hit != null && hit.result != null) {
            Minecraft mc = Minecraft.func_71410_x();
            hit.func_70029_a((World)mc.field_71441_e);
            mc.field_71476_x = new RayTraceResult((Entity)hit);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (hit != null && ClientEventHandler.hit.field_70170_p == event.getWorld()) {
            hit = null;
        }
    }

    public static void updateHitConnection() {
        Vec3d eyes;
        HitResult result;
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewer = mc.func_175606_aa();
        if (mc.field_71476_x != null && mc.field_71441_e != null && viewer != null && (result = ClientEventHandler.getHitConnection((World)mc.field_71441_e, viewer)) != null && ((HitResult)result).intersection.getResult().field_72307_f.func_72438_d(eyes = viewer.func_174824_e(1.0f)) < mc.field_71476_x.field_72307_f.func_72438_d(eyes)) {
            if (hit == null) {
                hit = new HitConnection((World)mc.field_71441_e);
            }
            hit.result = result;
            hit.func_70029_a((World)mc.field_71441_e);
            mc.field_71476_x = new RayTraceResult((Entity)hit);
            return;
        }
        if (hit != null) {
            hit.result = null;
        }
    }

    @Nullable
    private static HitResult getHitConnection(World world, Entity viewer) {
        AxisAlignedBB bounds = new AxisAlignedBB(viewer.func_180425_c()).func_186662_g(33.0);
        Set<Fastener<?>> fasteners = ClientEventHandler.collectFasteners(world, bounds);
        return ClientEventHandler.getHitConnection(viewer, bounds, fasteners);
    }

    private static Set<Fastener<?>> collectFasteners(World world, AxisAlignedBB bounds) {
        LinkedHashSet fasteners = Sets.newLinkedHashSet();
        CollectFastenersEvent event = new CollectFastenersEvent(world, bounds, fasteners);
        world.func_72872_a(EntityFenceFastener.class, bounds).forEach(event::accept);
        int minX = MathHelper.func_76128_c((double)(bounds.field_72340_a / 16.0));
        int maxX = MathHelper.func_76143_f((double)(bounds.field_72336_d / 16.0));
        int minZ = MathHelper.func_76128_c((double)(bounds.field_72339_c / 16.0));
        int maxZ = MathHelper.func_76143_f((double)(bounds.field_72334_f / 16.0));
        IChunkProvider provider = world.func_72863_F();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                Chunk chunk = provider.func_186026_b(x, z);
                if (chunk == null) continue;
                event.accept(chunk);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
        return fasteners;
    }

    @Nullable
    private static HitResult getHitConnection(Entity viewer, AxisAlignedBB bounds, Set<Fastener<?>> fasteners) {
        if (fasteners.isEmpty()) {
            return null;
        }
        Vec3d origin = viewer.func_174824_e(1.0f);
        Vec3d look = viewer.func_70676_i(1.0f);
        double reach = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        Vec3d end = origin.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        Connection found = null;
        Intersection rayTrace = null;
        double distance = Double.MAX_VALUE;
        for (Fastener<?> fastener : fasteners) {
            for (Connection connection : fastener.getConnections().values()) {
                double dist;
                ConnectionCollision collision;
                Intersection result;
                if (!connection.isOrigin() || connection.getDestination().getType() == FastenerType.PLAYER || (result = (collision = connection.getCollision()).intersect(origin, end)) == null || !((dist = result.getResult().field_72307_f.func_72438_d(origin)) < distance)) continue;
                distance = dist;
                found = connection;
                rayTrace = result;
            }
        }
        if (found == null) {
            return null;
        }
        return new HitResult(found, rayTrace);
    }

    @SubscribeEvent
    public void drawBlockHighlight(DrawBlockHighlightEvent event) {
        boolean isHitConnection;
        RayTraceResult over = event.getTarget();
        boolean isFence = over.field_72308_g instanceof EntityFenceFastener;
        boolean bl = isHitConnection = over.field_72308_g == hit;
        if (isFence || isHitConnection) {
            EntityPlayer player = event.getPlayer();
            float delta = event.getPartialTicks();
            double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)delta;
            double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)delta;
            double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)delta;
            this.setupHighlightGL();
            if (isFence) {
                this.drawFenceFastenerHighlight(player, (EntityFenceFastener)over.field_72308_g, delta, dx, dy, dz);
            } else if (hit != null && hit.result != null) {
                if (hit.result.intersection.getFeatureType() == Connection.CORD_FEATURE) {
                    this.drawConnectionHighlight(hit.result.connection, delta, dx, dy, dz);
                } else {
                    AxisAlignedBB aabb = hit.result.intersection.getHitBox().func_72317_d(-dx, -dy, -dz).func_186662_g(0.002);
                    RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                }
            }
            this.restoreHighlightGL();
        }
    }

    private void drawFenceFastenerHighlight(EntityPlayer player, EntityFenceFastener fence, float delta, double dx, double dy, double dz) {
        if (player.func_70685_l((Entity)fence) || player.func_70068_e((Entity)fence) <= 9.0) {
            AxisAlignedBB selection = fence.func_174813_aQ().func_72317_d(-dx, -dy, -dz).func_186662_g(0.002);
            RenderGlobal.func_189697_a((AxisAlignedBB)selection, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
    }

    private void drawConnectionHighlight(Connection connection, float delta, double dx, double dy, double dz) {
        Catenary catenary = connection.getCatenary();
        if (catenary != null) {
            boolean update;
            Vec3d vec = catenary.getVector();
            boolean bl = update = this.useVBO != OpenGlHelper.func_176075_f();
            if (update) {
                this.useVBO = OpenGlHelper.func_176075_f();
            }
            if (this.prevCatenaryVec != vec || update) {
                this.generateHighlight(connection);
                this.prevCatenaryVec = vec;
            }
            GlStateManager.func_179094_E();
            Vec3d offset = connection.getFastener().getConnectionPoint();
            GlStateManager.func_179137_b((double)(offset.field_72450_a - dx), (double)(offset.field_72448_b - dy), (double)(offset.field_72449_c - dz));
            if (this.useVBO) {
                this.connHighlightVBO.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187410_q((int)32886);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)16, (int)0);
                GlStateManager.func_187406_e((int)4, (int)5121, (int)16, (int)12);
                this.connHighlightVBO.func_177358_a(3);
                this.connHighlightVBO.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
                GlStateManager.func_187429_p((int)32886);
            } else {
                GlStateManager.func_179148_o((int)this.connHighlightId);
            }
            GlStateManager.func_179121_F();
        }
    }

    private void setupHighlightGL() {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
    }

    private void restoreHighlightGL() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    private void generateHighlight(Connection connection) {
        if (this.connHighlightVBO != null) {
            this.connHighlightVBO.func_177362_c();
        }
        if (this.connHighlightId >= 0) {
            GLAllocation.func_74523_b((int)this.connHighlightId);
            this.connHighlightId = 0;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        if (OpenGlHelper.func_176075_f()) {
            this.connHighlightVBO = new VertexBuffer(DefaultVertexFormats.field_181706_f);
            this.renderHighlight(connection, buf);
            buf.func_178977_d();
            buf.func_178965_a();
            this.connHighlightVBO.func_181722_a(buf.func_178966_f());
        } else {
            this.connHighlightId = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_179094_E();
            GlStateManager.func_187423_f((int)this.connHighlightId, (int)4864);
            this.renderHighlight(connection, buf);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
            GlStateManager.func_179121_F();
        }
    }

    private void renderHighlight(Connection connection, BufferBuilder buf) {
        buf.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        Segment[] segments = connection.getCatenary().getSegments();
        float cordRadius = connection.getRadius();
        for (int edge = 0; edge < 4; ++edge) {
            Vec3d dir;
            int step;
            int end;
            int start;
            boolean forward;
            boolean bl = forward = edge % 2 == 0;
            if (forward) {
                start = 0;
                end = segments.length;
                step = 1;
                Segment first = segments[0];
                dir = first.getVector();
                this.renderVertex(buf, edge, forward, first.getStart(), dir, dir, cordRadius, 0.4f);
            } else {
                start = segments.length - 1;
                end = -1;
                step = -1;
                Segment last = segments[start];
                dir = last.getVector();
                this.renderVertex(buf, edge, forward, last.getEnd(), dir, dir, cordRadius, 0.4f);
            }
            for (int i = start; i != end; i += step) {
                Segment segment = segments[i];
                Segment next = i + step >= segments.length || i + step < 0 ? segment : segments[i + step];
                Vec3d dir2 = segment.getVector();
                Vec3d pos = forward ? segment.getEnd() : segment.getStart();
                this.renderVertex(buf, edge, forward, pos, dir2, next.getVector(), cordRadius, 0.4f);
            }
            if (edge == 0) {
                Segment last = segments[segments.length - 1];
                dir = last.getVector();
                Vec3d endPoint = last.getEnd();
                this.renderVertex(buf, 0, false, endPoint, dir, dir, cordRadius, 0.0f);
                this.renderVertex(buf, 2, false, endPoint, dir, dir, cordRadius, 0.4f);
                this.renderVertex(buf, 2, true, endPoint, dir, dir, cordRadius, 0.0f);
                this.renderVertex(buf, 0, true, endPoint, dir, dir, cordRadius, 0.4f);
                continue;
            }
            if (edge != 1) continue;
            Segment first = segments[0];
            dir = first.getVector();
            this.renderVertex(buf, 2, forward, first.getStart(), dir, dir, cordRadius, 0.4f);
        }
        Segment first = segments[0];
        Vec3d dir = first.getVector();
        Vec3d startPoint = first.getStart();
        this.renderVertex(buf, 0, true, startPoint, dir, dir, cordRadius, 0.0f);
        this.renderVertex(buf, 2, true, startPoint, dir, dir, cordRadius, 0.4f);
        this.renderVertex(buf, 0, false, startPoint, dir, dir, cordRadius, 0.0f);
        this.renderVertex(buf, 0, true, startPoint, dir, dir, cordRadius, 0.4f);
    }

    private void renderVertex(BufferBuilder buf, int edge, boolean forward, Vec3d pos, Vec3d dir, Vec3d toDir, float cordRadius, float alpha) {
        double h;
        boolean colinear;
        if (forward) {
            toDir = Mth.negate(toDir);
        } else {
            dir = Mth.negate(dir);
        }
        boolean bl = colinear = dir.func_72430_b(toDir) < -0.999999;
        Vec3d up = colinear ? ((h = Math.sqrt(dir.field_72450_a * dir.field_72450_a + dir.field_72449_c * dir.field_72449_c)) < 1.0E-6 ? new Vec3d(-1.0, 0.0, 0.0) : new Vec3d(dir.field_72450_a / h * -dir.field_72448_b, h, dir.field_72449_c / h * -dir.field_72448_b).func_72432_b()) : Mth.lerp(dir, toDir, 0.5).func_72432_b();
        Vec3d side = dir.func_72431_c(up).func_72432_b();
        if (edge < 2) {
            up = Mth.negate(up);
        }
        pos = pos.func_186678_a(0.0625).func_178787_e(up.func_186678_a((double)(cordRadius + 0.01f)).func_178787_e(side.func_186678_a((double)(cordRadius + 0.01f))));
        buf.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
    }

    private static final class HitResult {
        private final Connection connection;
        private final Intersection intersection;

        public HitResult(Connection connection, Intersection intersection) {
            this.connection = connection;
            this.intersection = intersection;
        }
    }

    private static class HitConnection
    extends Entity {
        @Nullable
        private HitResult result;

        private HitConnection(World world) {
            super(world);
            this.func_145769_d(-1);
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            this.processAction(PlayerAction.ATTACK);
            return false;
        }

        public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
            if (hand == EnumHand.MAIN_HAND) {
                this.processAction(PlayerAction.INTERACT);
            }
            return false;
        }

        private void processAction(PlayerAction action) {
            if (this.result != null) {
                this.result.connection.processClientAction((EntityPlayer)Minecraft.func_71410_x().field_71439_g, action, this.result.intersection);
            }
        }

        public ItemStack getPickedResult(RayTraceResult target) {
            if (this.result == null) {
                return ItemStack.field_190927_a;
            }
            return this.result.connection.getItemStack();
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }
}

