/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.dpt.mixin;

import mod.acgaming.dpt.config.DPTConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Potion.class})
public abstract class DPTInstantDamageMixin {
    @ModifyArg(method={"affectEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private float dptInstantDamageAffectOld(float damageAmount) {
        return DPTConfig.instantDamageDisableExpScaling ? 0.0f : damageAmount;
    }

    @Inject(method={"affectEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z", ordinal=0)})
    private void dptInstantDamageAffectDirectNew(Entity source, Entity indirectSource, EntityLivingBase entityLivingBase, int amplifier, double health, CallbackInfo ci) {
        if (!DPTConfig.instantDamageDisableExpScaling) {
            return;
        }
        int level = amplifier + 1;
        float newDamage = (float)((double)level * DPTConfig.instantDamageAmount);
        entityLivingBase.func_70097_a(DamageSource.field_76376_m, newDamage);
    }

    @Inject(method={"affectEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z", ordinal=1)})
    private void dptInstantDamageAffectIndirectNew(Entity source, Entity indirectSource, EntityLivingBase entityLivingBase, int amplifier, double health, CallbackInfo ci) {
        if (!DPTConfig.instantDamageDisableExpScaling) {
            return;
        }
        int level = amplifier + 1;
        float newDamage = (float)((double)level * DPTConfig.instantDamageAmount);
        entityLivingBase.func_70097_a(DamageSource.func_76354_b((Entity)source, (Entity)indirectSource), newDamage);
    }

    @ModifyArg(method={"performEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z", ordinal=2))
    private float dptInstantDamagePerformOld(float damageAmount) {
        return DPTConfig.instantDamageDisableExpScaling ? 0.0f : damageAmount;
    }

    @Inject(method={"performEffect"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z", ordinal=2)})
    private void dptInstantDamagePerformNew(EntityLivingBase entityLivingBase, int amplifier, CallbackInfo ci) {
        if (!DPTConfig.instantDamageDisableExpScaling) {
            return;
        }
        int level = amplifier + 1;
        float newDamage = (float)((double)level * DPTConfig.instantDamageAmount);
        entityLivingBase.func_70097_a(DamageSource.field_76376_m, newDamage);
    }
}

