/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.helpers.game;

import alexndr.api.logger.LogHelper;
import java.util.IllegalFormatException;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.util.text.translation.I18n;

public final class Translator {
    private Translator() {
    }

    public static String translateToLocal(String key) {
        if (I18n.func_94522_b((String)key)) {
            return I18n.func_74838_a((String)key);
        }
        return I18n.func_150826_b((String)key);
    }

    public static String translateToLocalFormatted(String key, Object ... format) {
        String s = Translator.translateToLocal(key);
        try {
            return String.format(s, format);
        }
        catch (IllegalFormatException e) {
            LogHelper.severe("Format error: " + s);
            LogHelper.verboseException(e);
            return "Format error: " + s;
        }
    }

    public static String toLowercaseWithLocale(String string) {
        return string.toLowerCase(Translator.getLocale());
    }

    private static Locale getLocale() {
        Language currentLanguage;
        LanguageManager languageManager;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft != null && (languageManager = minecraft.func_135016_M()) != null && (currentLanguage = languageManager.func_135041_c()) != null) {
            return currentLanguage.getJavaLocale();
        }
        return Locale.getDefault();
    }
}

