/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.content.items;

import alexndr.api.config.types.ConfigBow;
import alexndr.api.content.items.SimpleBowEffects;
import alexndr.api.core.SimpleCoreAPI;
import alexndr.api.helpers.game.TooltipHelper;
import alexndr.api.registry.Plugin;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class SimpleBow
extends ItemBow {
    protected String name;
    protected Plugin plugin;
    protected ConfigBow entry;
    protected List<String> toolTipStrings = Lists.newArrayList();
    protected HashMap<SimpleBowEffects, Object> effects = new HashMap();
    protected ItemStack repairMaterial;
    protected float zoomAmount = 0.165f;

    public SimpleBow(String bowName, Plugin plugin, int maxUses) {
        this.name = bowName;
        this.plugin = plugin;
        this.func_77656_e(maxUses);
        this.field_77789_bW = true;
        this.func_77655_b(bowName);
        this.setRegistryName(plugin.getModId(), bowName);
    }

    public void registerItemModel() {
        String bowName = this.name;
        SimpleCoreAPI.proxy.registerItemRenderer(this.plugin, (Item)this, 0, bowName);
        bowName = this.name + "_pulling_0";
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation(this.plugin.getModId(), bowName), "inventory")});
        bowName = this.name + "_pulling_1";
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation(this.plugin.getModId(), bowName), "inventory")});
        bowName = this.name + "_pulling_2";
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation(this.plugin.getModId(), bowName), "inventory")});
    }

    public ConfigBow getConfigEntry() {
        return this.entry;
    }

    public SimpleBow setConfigEntry(ConfigBow entry) {
        this.entry = entry;
        this.setAdditionalProperties();
        return this;
    }

    public SimpleBow addToolTip(String toolTip) {
        TooltipHelper.addTooltipToItem((Item)this, toolTip);
        return this;
    }

    public SimpleBow addToolTip(String toolTip, TextFormatting color) {
        TooltipHelper.addTooltipToItem((Item)this, color + I18n.func_74838_a((String)toolTip));
        return this;
    }

    public SimpleBow setRepairMaterial(ItemStack repairMaterial) {
        this.repairMaterial = repairMaterial;
        return this;
    }

    public SimpleBow setEffect(SimpleBowEffects effect) {
        this.effects.put(effect, null);
        return this;
    }

    public SimpleBow setEffect(SimpleBowEffects effect, float modifier) {
        this.effects.put(effect, Float.valueOf(modifier));
        return this;
    }

    public SimpleBow setEffect(SimpleBowEffects effect, int modifier) {
        this.effects.put(effect, modifier);
        return this;
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    public SimpleBow setZoomAmount(float zoomAmount) {
        this.zoomAmount = zoomAmount;
        return this;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.repairMaterial.func_77973_b() == repair.func_77973_b() ? true : super.func_82789_a(toRepair, repair);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean hasAmmo;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)(hasAmmo = !this.func_185060_a(playerIn).func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemstack) > 0 || this.effects.containsKey(SimpleBowEffects.infiniteArrows)));
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !hasAmmo) {
            return hasAmmo ? new ActionResult(EnumActionResult.PASS, (Object)itemstack) : new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean efficient = false;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0 || this.effects.containsKey(SimpleBowEffects.infiniteArrows);
            ItemStack itemstack = this.func_185060_a(entityplayer);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                float f;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                if ((double)(f = ItemBow.func_185059_b((int)i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
                    if (!worldIn.field_72995_K) {
                        int k;
                        int j;
                        ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                        EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)entityplayer);
                        entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        if (f == 1.0f) {
                            entityarrow.func_70243_d(true);
                            if (this.effects.containsKey(SimpleBowEffects.critFlameEffect)) {
                                entityarrow.func_70015_d(100);
                            }
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            entityarrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0 || this.effects.containsKey(SimpleBowEffects.flameEffect)) {
                            entityarrow.func_70015_d(100);
                        }
                        if (this.effects.containsKey(SimpleBowEffects.damageEffect)) {
                            entityarrow.func_70239_b(entityarrow.func_70242_d() * (double)((Float)this.effects.get(SimpleBowEffects.damageEffect)).floatValue());
                        }
                        if (this.effects.containsKey(SimpleBowEffects.knockbackEffect)) {
                            entityarrow.func_70240_a(k > 0 ? k + (Integer)this.effects.get(SimpleBowEffects.knockbackEffect) : (Integer)this.effects.get(SimpleBowEffects.knockbackEffect));
                        }
                        if (this.effects.containsKey(SimpleBowEffects.efficiencyEffect)) {
                            efficient = this.randomChance((Integer)this.effects.get(SimpleBowEffects.efficiencyEffect));
                        }
                        stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                        if (flag1 || entityplayer.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_72838_d((Entity)entityarrow);
                    }
                    worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!(flag1 || efficient || entityplayer.field_71075_bZ.field_75098_d)) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            entityplayer.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    protected ItemStack func_185060_a(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean randomChance(int chance) {
        Random random = new Random();
        int rand = random.nextInt(100);
        return rand <= chance;
    }

    public void setAdditionalProperties() {
    }
}

