/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.content.items;

import alexndr.api.config.IConfigureItemHelper;
import alexndr.api.config.types.ConfigArmor;
import alexndr.api.core.SimpleCoreAPI;
import alexndr.api.helpers.game.TooltipHelper;
import alexndr.api.helpers.game.Translator;
import alexndr.api.registry.Plugin;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class SimpleArmor
extends ItemArmor
implements IConfigureItemHelper<SimpleArmor, ConfigArmor> {
    protected String name;
    protected ItemArmor[] armor = new ItemArmor[]{null, null, null, null};
    private final ItemArmor.ArmorMaterial material;
    protected Plugin plugin;
    protected ConfigArmor entry;
    protected EntityEquipmentSlot slot;
    protected String type;
    protected String texturePath;
    private List<String> toolTipStrings = Lists.newArrayList();

    public SimpleArmor(String armorName, Plugin plugin, ItemArmor.ArmorMaterial material, EntityEquipmentSlot slot) {
        super(material, 1, slot);
        this.name = armorName;
        this.plugin = plugin;
        this.material = material;
        this.slot = slot;
        this.func_77655_b(armorName);
        this.setRegistryName(plugin.getModId(), armorName);
    }

    public void registerItemModel() {
        SimpleCoreAPI.proxy.registerItemRenderer(this.plugin, (Item)this, 0, this.name);
    }

    @Override
    public ConfigArmor getConfigEntry() {
        return this.entry;
    }

    @Override
    public SimpleArmor setConfigEntry(ConfigArmor entry) {
        this.entry = entry;
        return this;
    }

    public SimpleArmor setType(String armorType) {
        this.type = armorType;
        this.setArmorTexturePath(this.plugin.getModId(), armorType, this.slot);
        return this;
    }

    @Override
    public SimpleArmor addToolTip(String toolTip) {
        TooltipHelper.addTooltipToItem((Item)this, toolTip);
        return this;
    }

    public SimpleArmor addToolTip(String toolTip, TextFormatting color) {
        TooltipHelper.addTooltipToItem((Item)this, color + Translator.translateToLocal(toolTip));
        return this;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ItemStack.func_179545_c((ItemStack)this.material.getRepairItemStack(), (ItemStack)repair) ? true : super.func_82789_a(toRepair, repair);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, EntityEquipmentSlot slot, String layer) {
        return this.texturePath;
    }

    public void setArmorTexturePath(String modId, String type, EntityEquipmentSlot slot) {
        switch (slot) {
            case FEET: {
                this.texturePath = modId + ":textures/models/armor/" + type + "_layer_1.png";
                break;
            }
            case LEGS: {
                this.texturePath = modId + ":textures/models/armor/" + type + "_layer_2.png";
                break;
            }
            case CHEST: {
                this.texturePath = modId + ":textures/models/armor/" + type + "_layer_1.png";
                break;
            }
            case HEAD: {
                this.texturePath = modId + ":textures/models/armor/" + type + "_layer_1.png";
                break;
            }
        }
    }

    public static void getArmorSet(EntityPlayer player, ItemArmor[] ar) {
        for (int ii = 0; ii < ar.length; ++ii) {
            ar[ii] = null;
        }
        Iterable armorList = player.func_184193_aE();
        for (ItemStack stack : armorList) {
            ItemArmor piece;
            if (stack == null || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            ar[piece.field_77881_a.func_188454_b()] = piece = (ItemArmor)stack.func_77973_b();
        }
    }

    public void getArmorPieces(EntityPlayer player) {
        SimpleArmor.getArmorSet(player, this.armor);
    }

    public boolean isFullSet(EntityPlayer player) {
        this.getArmorPieces(player);
        for (ItemArmor ar0 : this.armor) {
            if (!(ar0 instanceof SimpleArmor)) {
                return false;
            }
            SimpleArmor ar = (SimpleArmor)ar0;
            if (ar.material == this.material) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setAdditionalProperties() {
    }
}

