/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.Fluid;
import surreal.contentcreator.common.block.BlockMaterial;
import surreal.contentcreator.common.block.generic.IGenericBlock;
import surreal.contentcreator.common.fluid.FluidBase;
import surreal.contentcreator.common.item.ItemBase;
import surreal.contentcreator.common.item.ItemMaterial;
import surreal.contentcreator.common.item.SubItem;
import surreal.contentcreator.proxy.CommonProxy;
import surreal.contentcreator.types.CTMaterial;

public class FileGenUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void generateFiles() {
        FileGenUtil.generateResourcesFile();
        FileGenUtil.generateItemFiles(CommonProxy.ITEMS);
        FileGenUtil.generateMatItems(CommonProxy.MAT_ITEMS.values());
        FileGenUtil.generateBlocks(CommonProxy.BLOCKS);
        FileGenUtil.generateBlocks(CommonProxy.MAT_BLOCKS);
        FileGenUtil.generateFluidFiles(CommonProxy.FLUIDS);
    }

    private static void generateResourcesFile() {
        File blockstates;
        File models;
        File lang;
        File textures;
        File resources = new File(Minecraft.func_71410_x().field_71412_D, "resources/contentcreator");
        if (!resources.exists()) {
            resources.mkdirs();
        }
        if (!(textures = new File(resources, "textures/items")).exists()) {
            textures.mkdirs();
        }
        if (!(textures = new File(textures.getParentFile(), "blocks")).exists()) {
            textures.mkdirs();
        }
        if (!(lang = new File(resources, "lang")).exists()) {
            lang.mkdirs();
        }
        if (!(lang = new File(lang, "en_us.lang")).exists()) {
            try {
                lang.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(models = new File(resources, "models/block")).exists()) {
            models.mkdirs();
        }
        if (!(models = new File(models.getParentFile(), "item")).exists()) {
            models.mkdirs();
        }
        if (!(blockstates = new File(resources, "blockstates")).exists()) {
            blockstates.mkdirs();
        }
    }

    private static void generateItemFiles(Collection<ItemBase> list) {
        File blockstates = new File(Minecraft.func_71410_x().field_71412_D, "resources/contentcreator/blockstates/item");
        File models = new File(Minecraft.func_71410_x().field_71412_D, "resources/contentcreator/models/item");
        for (ItemBase item : list) {
            if (item.modelBlockState) {
                JsonObject object = new JsonObject();
                object.addProperty("forge_marker", (Number)1);
                JsonObject defaults = new JsonObject();
                defaults.addProperty("model", "builtin/generated");
                defaults.addProperty("transform", "forge:default-item");
                object.add("defaults", (JsonElement)defaults);
                JsonObject variants = new JsonObject();
                JsonObject type = new JsonObject();
                for (SubItem sub : item.SUBITEMS.values()) {
                    String name = item.getSubName(sub);
                    if (name == null) {
                        name = "" + sub.meta;
                    }
                    JsonObject obj = new JsonObject();
                    JsonObject textures = new JsonObject();
                    textures.addProperty("layer0", "contentcreator:items/" + item.getRegistryName().func_110623_a() + "/" + name);
                    obj.add("textures", (JsonElement)textures);
                    type.add(name, (JsonElement)obj);
                }
                variants.add("type", (JsonElement)type);
                object.add("variants", (JsonElement)variants);
                try {
                    File f = new File(blockstates, item.getRegistryName().func_110623_a() + ".json");
                    if (f.exists()) continue;
                    FileWriter file = new FileWriter(f);
                    file.write(GSON.toJson((JsonElement)object));
                    file.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            for (SubItem sub : item.SUBITEMS.values()) {
                String name = item.getSubName(sub);
                if (name == null) {
                    name = sub.meta != 0 ? item.getRegistryName().func_110623_a() + "_" + sub.meta : item.getRegistryName().func_110623_a();
                }
                JsonObject object = new JsonObject();
                object.addProperty("parent", "item/generated");
                JsonObject textures = new JsonObject();
                textures.addProperty("layer0", "contentcreator:items/" + name);
                object.add("textures", (JsonElement)textures);
                try {
                    File f = new File(models, name + ".json");
                    if (f.exists()) continue;
                    FileWriter file = new FileWriter(f);
                    file.write(GSON.toJson((JsonElement)object));
                    file.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void generateMatItems(Collection<ItemMaterial> items) {
        for (ItemMaterial item : items) {
            for (CTMaterial material : item.MATERIALS.values()) {
                String model = item.getModelLocation(material).split(":")[1];
                String texture = "items/" + model;
                File f = new File(Minecraft.func_71410_x().field_71412_D, "resources/contentcreator/models/item/" + model + ".json");
                JsonObject object = new JsonObject();
                object.addProperty("parent", "item/generated");
                JsonObject textures = new JsonObject();
                textures.addProperty("layer0", "contentcreator:" + texture);
                object.add("textures", (JsonElement)textures);
                try {
                    if (f.exists()) continue;
                    FileWriter file = new FileWriter(f);
                    file.write(GSON.toJson((JsonElement)object));
                    file.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void generateBlocks(Collection<Block> blocks) {
        for (Block block : blocks) {
            JsonObject object = new JsonObject();
            object.addProperty("forge_marker", (Number)1);
            JsonObject defaults = new JsonObject();
            defaults.addProperty("transform", "forge:default-block");
            defaults.addProperty("model", FileGenUtil.getModelLocation(block));
            JsonObject textures = FileGenUtil.getTextures(block);
            if (!(block instanceof BlockMaterial)) {
                defaults.add("textures", (JsonElement)textures);
            }
            object.add("defaults", (JsonElement)defaults);
            JsonObject variants = FileGenUtil.getVariants(block, textures);
            object.add("variants", (JsonElement)variants);
            try {
                File f = new File(Minecraft.func_71410_x().field_71412_D, "resources/contentcreator/blockstates/" + block.getRegistryName().func_110623_a() + ".json");
                if (f.exists()) continue;
                FileWriter file = new FileWriter(f);
                file.write(GSON.toJson((JsonElement)object));
                file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getModelLocation(Block block) {
        if (block instanceof BlockMaterial) {
            return "contentcreator:tinted_cube_all";
        }
        if (block instanceof IGenericBlock) {
            return ((IGenericBlock)block).getModelLocation();
        }
        return "cube_all";
    }

    private static JsonObject getTextures(Block block) {
        JsonObject textures = new JsonObject();
        if (block instanceof BlockMaterial) {
            textures.addProperty("all", "contentcreator:blocks/part/" + ((BlockMaterial)block).part.name);
        } else if (block instanceof IGenericBlock) {
            ((IGenericBlock)block).setTextures(block, textures);
        } else {
            textures.addProperty("all", "contentcreator:blocks/" + block.getRegistryName().func_110623_a());
        }
        return textures;
    }

    private static JsonObject getVariants(Block block, JsonObject textures) {
        JsonObject variants = new JsonObject();
        if (block instanceof BlockMaterial) {
            BlockMaterial b = (BlockMaterial)block;
            JsonObject material = new JsonObject();
            for (int i = 0; i < b.materials.length; ++i) {
                JsonObject mat = new JsonObject();
                mat.add("textures", (JsonElement)textures);
                material.add("" + i, (JsonElement)mat);
            }
            variants.add("material", (JsonElement)material);
            JsonArray mongus = new JsonArray();
            mongus.add((JsonElement)new JsonObject());
            variants.add("inventory", (JsonElement)mongus);
        } else if (block instanceof IGenericBlock) {
            ((IGenericBlock)block).setVariants(block, variants);
        } else {
            JsonArray mongus = new JsonArray();
            mongus.add((JsonElement)new JsonObject());
            variants.add("normal", (JsonElement)mongus);
            variants.add("inventory", (JsonElement)mongus);
        }
        return variants;
    }

    private static void generateFluidFiles(Collection<FluidBase> list) {
        if (list.size() > 0) {
            JsonObject object = new JsonObject();
            object.addProperty("forge_marker", (Number)1);
            JsonObject variants = new JsonObject();
            for (Fluid fluid : list) {
                if (variants.get(fluid.getName()) != null) continue;
                JsonObject fluidObj = new JsonObject();
                JsonObject customFluid = new JsonObject();
                customFluid.addProperty("fluid", fluid.getName());
                fluidObj.addProperty("model", "forge:fluid");
                fluidObj.add("custom", (JsonElement)customFluid);
                variants.add(fluid.getName(), (JsonElement)fluidObj);
            }
            object.add("variants", (JsonElement)variants);
            try {
                File f = new File(Minecraft.func_71410_x().field_71412_D, "resources/contentcreator/blockstates");
                f = new File(f, "fluids.json");
                FileWriter fileWriter = new FileWriter(f);
                fileWriter.write(GSON.toJson((JsonElement)object));
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

