/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.util;

import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.util.IRandom;
import crafttweaker.api.world.IBlockAccess;
import crafttweaker.mc1120.enchantments.MCEnchantmentDefinition;
import crafttweaker.mc1120.entity.MCEntityEquipmentSlot;
import crafttweaker.mc1120.entity.MCEntityItem;
import crafttweaker.mc1120.util.MCRandom;
import crafttweaker.mc1120.world.MCBlockAccess;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import surreal.contentcreator.common.item.ItemBase;
import surreal.contentcreator.common.item.SubItem;
import surreal.contentcreator.proxy.CommonProxy;

public class CTUtil {
    public static List<ItemStack> getStacks(Item item) {
        NonNullList list = NonNullList.func_191196_a();
        item.func_150895_a(CreativeTabs.field_78027_g, list);
        return list;
    }

    public static Map<String, ItemStack> getMap() {
        HashMap<String, ItemStack> map = new HashMap<String, ItemStack>();
        for (ItemBase item : CommonProxy.ITEMS) {
            String itemName = Objects.requireNonNull(item.getRegistryName()).func_110623_a();
            if (item.SUBITEMS.size() > 1) {
                for (int meta : item.SUBITEMS.keySet()) {
                    SubItem subItem = item.SUBITEMS.get(meta);
                    String name = subItem.UNLOCNAME != null ? subItem.UNLOCNAME.getUnlocalizedName(CraftTweakerMC.getIItemStack((ItemStack)new ItemStack((Item)item, 1, meta))) : "" + meta;
                    map.put(itemName + ":" + name, new ItemStack((Item)item, 1, meta));
                }
                continue;
            }
            map.put(itemName, new ItemStack((Item)item));
        }
        return map;
    }

    public static EnumRarity getRarity(String name) {
        for (EnumRarity rarity : EnumRarity.values()) {
            if (!rarity.name().equalsIgnoreCase(name)) continue;
            return rarity;
        }
        return EnumRarity.COMMON;
    }

    public static EnumAction getAction(String name) {
        for (EnumAction action : EnumAction.values()) {
            if (!action.name().equalsIgnoreCase(name)) continue;
            return action;
        }
        return EnumAction.NONE;
    }

    public static IBlockAccess getIBlockAccess(net.minecraft.world.IBlockAccess world) {
        return new MCBlockAccess(world);
    }

    public static IRandom getRandom(Random random) {
        return new MCRandom(random);
    }

    public static IEnchantmentDefinition getEnchantment(Enchantment enchantment) {
        return new MCEnchantmentDefinition(enchantment);
    }

    public static EnumHand getHand(IEntityEquipmentSlot equipmentSlot) {
        switch (equipmentSlot.getIndex()) {
            case 0: {
                return EnumHand.MAIN_HAND;
            }
            case 1: {
                return EnumHand.OFF_HAND;
            }
        }
        return EnumHand.MAIN_HAND;
    }

    public static IEntityEquipmentSlot getHandEquipment(EnumHand hand) {
        return new MCEntityEquipmentSlot(EntityEquipmentSlot.values()[hand.ordinal()]);
    }

    public static class MCEntityItemMutable
    extends MCEntityItem {
        EntityItem entityItem;

        public MCEntityItemMutable(EntityItem entityItem) {
            super(entityItem);
            this.entityItem = entityItem;
        }

        public IItemStack getItem() {
            return CraftTweakerMC.getIItemStackMutable((ItemStack)this.entityItem.func_92059_d());
        }
    }
}

