/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.enchantment;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import surreal.contentcreator.common.enchantment.wrapper.EnchantmentTypeWrapper;
import surreal.contentcreator.common.enchantment.wrapper.EntityEquipmentSlotWrapper;
import surreal.contentcreator.common.enchantment.wrapper.RarityWrapper;
import surreal.contentcreator.functions.enchantment.IEnchantmentCalcDamageByCreatureFunc;
import surreal.contentcreator.functions.enchantment.IEnchantmentCalcModifierDamageFunc;
import surreal.contentcreator.functions.enchantment.IEnchantmentMaxEnchantabilityFunc;
import surreal.contentcreator.functions.enchantment.IEnchantmentMinEnchantabilityFunc;
import surreal.contentcreator.functions.enchantment.IEnchantmentOnEntityDamagedAction;
import surreal.contentcreator.functions.enchantment.IEnchantmentOnUserHurtAction;
import surreal.contentcreator.proxy.CommonProxy;

@ZenRegister
@ZenClass(value="contentcreator.enchantment.Enchantment")
public class EnchantmentBase
extends Enchantment {
    private boolean allowedOnBooks = true;
    private boolean treasure = false;
    private boolean curse = false;
    private List<String> incompatibleEnchs = new ArrayList<String>();
    private int minLevel = 1;
    private int maxLevel = 1;
    private IEnchantmentMinEnchantabilityFunc MIN_ENCHANTABILITY = null;
    private IEnchantmentMaxEnchantabilityFunc MAX_ENCHANTABILITY = null;
    private IEnchantmentCalcModifierDamageFunc CALC_MODIFIER_DAMAGE = null;
    private IEnchantmentCalcDamageByCreatureFunc CALC_DAMAGE_BY_CREATURE = null;
    private IEnchantmentOnEntityDamagedAction ON_ENTITY_DAMAGED = null;
    private IEnchantmentOnUserHurtAction ON_USER_HURT = null;

    protected EnchantmentBase(Enchantment.Rarity rarityIn, EnumEnchantmentType typeIn, EntityEquipmentSlot[] slots) {
        super(rarityIn, typeIn, slots);
    }

    @ZenMethod
    public static EnchantmentBase create(String name, RarityWrapper rarityWrapper, EnchantmentTypeWrapper enchantmentTypeWrapper, EntityEquipmentSlotWrapper[] slotWrappers) {
        EntityEquipmentSlot[] slots = new EntityEquipmentSlot[slotWrappers.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = slotWrappers[i].slot;
        }
        EnchantmentBase enchantmentBase = new EnchantmentBase(rarityWrapper.rarity, enchantmentTypeWrapper.type, slots);
        enchantmentBase.func_77322_b(name);
        enchantmentBase.setRegistryName("contentcreator:" + name);
        return enchantmentBase;
    }

    @ZenMethod
    public void register() {
        CommonProxy.ENCHANTMENTS.add(this);
    }

    @ZenMethod
    public EnchantmentBase setAllowedOnBooks(boolean allowedOnBooks) {
        this.allowedOnBooks = allowedOnBooks;
        return this;
    }

    @ZenMethod
    public EnchantmentBase setTreasure(boolean treasure) {
        this.treasure = treasure;
        return this;
    }

    @ZenMethod
    public EnchantmentBase setCurse(boolean curse) {
        this.curse = curse;
        return this;
    }

    @ZenMethod
    public EnchantmentBase addIncompatible(String name) {
        this.incompatibleEnchs.add(name);
        return this;
    }

    @ZenMethod
    public EnchantmentBase setMinLevel(int minLevel) {
        this.minLevel = Math.max(1, minLevel);
        return this;
    }

    @ZenMethod
    public EnchantmentBase setMaxLevel(int maxLevel) {
        this.maxLevel = Math.max(this.minLevel, maxLevel);
        return this;
    }

    @ZenMethod
    public EnchantmentBase setMinEnchantability(IEnchantmentMinEnchantabilityFunc func) {
        this.MIN_ENCHANTABILITY = func;
        return this;
    }

    @ZenMethod
    public EnchantmentBase setMaxEnchantability(IEnchantmentMaxEnchantabilityFunc func) {
        this.MAX_ENCHANTABILITY = func;
        return this;
    }

    @ZenMethod
    public EnchantmentBase setCalcModifierDamage(IEnchantmentCalcModifierDamageFunc func) {
        this.CALC_MODIFIER_DAMAGE = func;
        return this;
    }

    @ZenMethod
    public EnchantmentBase setOnEntityDamaged(IEnchantmentOnEntityDamagedAction func) {
        this.ON_ENTITY_DAMAGED = func;
        return this;
    }

    @ZenMethod
    public EnchantmentBase setOnUserHurt(IEnchantmentOnUserHurtAction func) {
        this.ON_USER_HURT = func;
        return this;
    }

    public int func_77319_d() {
        return this.minLevel;
    }

    public int func_77325_b() {
        return this.maxLevel;
    }

    public int func_77321_a(int enchantmentLevel) {
        if (this.MIN_ENCHANTABILITY == null) {
            return super.func_77321_a(enchantmentLevel);
        }
        return this.MIN_ENCHANTABILITY.getMinEnchantability(enchantmentLevel);
    }

    public int func_77317_b(int enchantmentLevel) {
        if (this.MAX_ENCHANTABILITY == null) {
            return super.func_77317_b(enchantmentLevel);
        }
        return this.MAX_ENCHANTABILITY.getMaxEnchantability(enchantmentLevel);
    }

    public int func_77318_a(int level, DamageSource source) {
        if (this.CALC_MODIFIER_DAMAGE == null) {
            return super.func_77318_a(level, source);
        }
        return this.CALC_MODIFIER_DAMAGE.calcModifierDamage(level, CraftTweakerMC.getIDamageSource((DamageSource)source));
    }

    public float func_152376_a(int level, EnumCreatureAttribute creatureType) {
        if (this.CALC_DAMAGE_BY_CREATURE == null) {
            return super.func_152376_a(level, creatureType);
        }
        return this.CALC_DAMAGE_BY_CREATURE.calcDamageByCreature(level, creatureType.toString().toLowerCase());
    }

    protected boolean func_77326_a(Enchantment ench) {
        boolean flag = true;
        String registryName = ench.getRegistryName().toString();
        if (this.getRegistryName().toString().equals(registryName)) {
            flag = false;
        }
        for (String incompatibleRegistryName : this.incompatibleEnchs) {
            if (!incompatibleRegistryName.equals(registryName)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean func_185261_e() {
        return this.treasure;
    }

    public boolean func_190936_d() {
        return this.curse;
    }

    public void func_151368_a(EntityLivingBase user, Entity target, int level) {
        if (this.ON_ENTITY_DAMAGED == null) {
            super.func_151368_a(user, target, level);
        } else {
            this.ON_ENTITY_DAMAGED.onEntityDamaged(CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)user), CraftTweakerMC.getIEntity((Entity)target), level);
        }
    }

    public void func_151367_b(EntityLivingBase user, Entity attacker, int level) {
        if (this.ON_USER_HURT == null) {
            super.func_151368_a(user, attacker, level);
        } else {
            this.ON_USER_HURT.onUserHurt(CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)user), CraftTweakerMC.getIEntity((Entity)attacker), level);
        }
    }

    public boolean isAllowedOnBooks() {
        return this.allowedOnBooks;
    }
}

