/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block.generic;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import surreal.contentcreator.common.block.generic.IGenericBlock;
import surreal.contentcreator.types.CTSoundType;

public class BlockGenericStem
extends BlockStem
implements IGenericBlock {
    private boolean cropItemExists = true;
    private String cropID;
    private int cropMeta;
    private ItemStack seed;
    private IBlockState crop;

    @Nullable
    private IBlockState tryGetCrop() {
        if (this.crop == null && this.cropItemExists) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.cropID));
            if (block != null) {
                this.crop = block.func_176203_a(this.cropMeta);
            }
            if (this.crop == null) {
                this.cropItemExists = false;
            }
        }
        return this.crop;
    }

    public static BlockGenericStem create(String c, int meta) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(c));
        IBlockState blockState = block == null ? null : block.func_176203_a(meta);
        return new BlockGenericStem(blockState, c, meta);
    }

    public BlockGenericStem(IBlockState crop, String c, int meta) {
        super(crop.func_177230_c());
        this.cropID = c;
        this.cropMeta = meta;
        this.crop = crop;
    }

    protected Item func_176481_j() {
        return this.seed.func_77973_b();
    }

    @Override
    public void setSoundType(CTSoundType soundType) {
        this.func_149672_a(soundType.getType());
    }

    @Override
    public Item createItem(Block block) {
        Item seeds = ((Item)new ItemSeeds(block, Blocks.field_150458_ak).setRegistryName(block.getRegistryName())).func_77655_b(block.func_149739_a());
        this.seed = new ItemStack(seeds);
        return seeds;
    }
}

