/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block.generic;

import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import surreal.contentcreator.common.block.generic.BlockGenericCropTall;
import surreal.contentcreator.common.block.generic.IGenericBlock;

public class BlockGenericCropTallRestricted
extends BlockGenericCropTall
implements IGenericBlock,
IPlantable {
    private HashSet<IBlockState> neededBlocks = new HashSet();

    public BlockGenericCropTallRestricted(String c, int meta, int cMin, int cMax, String blockId, int blockMeta) {
        super(c, meta, cMin, cMax);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
        IBlockState blockState = block == null ? null : block.func_176203_a(blockMeta);
        this.neededBlocks.add(blockState);
    }

    public BlockGenericCropTallRestricted(String c, int meta, int cMin, int cMax, String oreDictName) {
        super(c, meta, cMin, cMax);
        String cleanedOreDictName = oreDictName.startsWith("ore:") ? oreDictName.substring(4) : oreDictName;
        for (ItemStack stack : OreDictionary.getOres((String)cleanedOreDictName)) {
            if (!(stack.func_77973_b() instanceof ItemBlock) || stack.func_190926_b()) continue;
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                if (stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != state.func_177230_c().func_176201_c(state)) continue;
                this.neededBlocks.add(state);
            }
        }
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (!this.hasNeededBlock(world, pos)) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            IBlockState belowState = world.func_180495_p(pos.func_177977_b());
            return belowState.func_177230_c() instanceof BlockGenericCropTall && (Boolean)belowState.func_177229_b((IProperty)TOP) == false;
        }
        return !(world.func_175699_k(pos) <= 12 && !world.func_175678_i(pos) && !world.func_175678_i(pos.func_177984_a()) || !this.canBePlantedHere(world, pos) && !this.canPlantGrowOnBlock(world.func_180495_p(pos.func_177977_b())));
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.func_176475_e(world, pos, state);
        BlockPos up = pos.func_177984_a();
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        boolean isTop = (Boolean)state.func_177229_b((IProperty)TOP);
        float growthChance = BlockGenericCropTallRestricted.func_180672_a((Block)this, (World)world, (BlockPos)pos);
        if (age < 7) {
            if (world.func_175671_l(up) > 12 && rand.nextInt(MathHelper.func_76123_f((float)growthChance)) == 0) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(age + 1)));
            }
        } else if (age == 7 && world.func_175623_d(up) && !isTop && this.hasNeededBlock(world, pos.func_177984_a()) && world.func_175671_l(up) > 12 && rand.nextInt(MathHelper.func_76123_f((float)(growthChance * 2.0f))) == 0) {
            world.func_175656_a(up, state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean hasNeededBlock(World worldIn, BlockPos pos) {
        return this.neededBlocks.contains(worldIn.func_180495_p(pos.func_177978_c())) || this.neededBlocks.contains(worldIn.func_180495_p(pos.func_177968_d())) || this.neededBlocks.contains(worldIn.func_180495_p(pos.func_177974_f())) || this.neededBlocks.contains(worldIn.func_180495_p(pos.func_177976_e()));
    }
}

