/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block.generic;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import surreal.contentcreator.common.block.generic.IGenericBlock;
import surreal.contentcreator.types.CTSoundType;

public class BlockGenericCropTall
extends BlockCrops
implements IGenericBlock,
IPlantable {
    private boolean cropItemExists = true;
    private String cropID;
    private int cropMeta;
    private ItemStack seed;
    private ItemStack crop;
    private int cMin;
    private int cMax;
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.25, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.375, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.5, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.875, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125)};

    @Nullable
    private ItemStack tryGetCrop() {
        if (this.crop == null && this.cropItemExists) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.cropID));
            if (item != null) {
                this.crop = new ItemStack(item, 1, this.cropMeta);
            }
            if (this.crop == null) {
                this.cropItemExists = false;
            }
        }
        return this.crop;
    }

    public BlockGenericCropTall(String c, int meta, int cMin, int cMax) {
        this.cropID = c;
        this.cropMeta = meta;
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.cropID));
        ItemStack itemStack = item == null ? null : new ItemStack(item, 1, this.cropMeta);
        this.crop = itemStack == null ? null : itemStack;
        this.cMin = Math.max(cMin, 1);
        this.cMax = Math.max(cMin, cMax);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    public boolean func_185525_y(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)field_176488_a) > 6;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
        boolean isTop = (Boolean)state.func_177229_b((IProperty)TOP);
        if (isTop) {
            return !this.func_185525_y(state);
        }
        return !(above.func_177230_c() instanceof BlockGenericCropTall);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            IBlockState belowState = world.func_180495_p(pos.func_177977_b());
            return belowState.func_177230_c() instanceof BlockGenericCropTall && (Boolean)belowState.func_177229_b((IProperty)TOP) == false;
        }
        return !(world.func_175699_k(pos) <= 12 && !world.func_175678_i(pos) && !world.func_175678_i(pos.func_177984_a()) || !this.canBePlantedHere(world, pos) && !this.canPlantGrowOnBlock(world.func_180495_p(pos.func_177977_b())));
    }

    public boolean canBePlantedHere(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public void func_176487_g(World worldIn, BlockPos pos, IBlockState state) {
        int j;
        if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && (Integer)state.func_177229_b((IProperty)field_176488_a) >= 7) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        }
        boolean isTop = (Boolean)state.func_177229_b((IProperty)TOP);
        int i = this.func_185527_x(state) + this.func_185529_b(worldIn);
        if (i > (j = this.func_185526_g())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.func_185528_e(i).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(isTop)), 2);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.func_176475_e(world, pos, state);
        BlockPos up = pos.func_177984_a();
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        boolean isTop = (Boolean)state.func_177229_b((IProperty)TOP);
        float growthChance = BlockGenericCropTall.func_180672_a((Block)this, (World)world, (BlockPos)pos);
        if (age < 7) {
            if (world.func_175671_l(up) > 12 && rand.nextInt(MathHelper.func_76123_f((float)growthChance)) == 0) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(age + 1)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(isTop)));
            }
        } else if (age == 7 && world.func_175623_d(up) && !isTop && world.func_175671_l(up) > 12 && rand.nextInt(MathHelper.func_76123_f((float)(growthChance * 2.0f))) == 0) {
            world.func_175656_a(up, state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    public boolean canPlantGrowOnBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return block == this && (Integer)state.func_177229_b((IProperty)field_176488_a) == 7;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            IBlockState aboveState;
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && (aboveState = world.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof BlockGenericCropTall && ((Boolean)aboveState.func_177229_b((IProperty)TOP)).booleanValue()) {
                world.func_175698_g(pos.func_177984_a());
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)field_176488_a);
        return meta > 6 ? 2 : 0;
    }

    protected Item func_149866_i() {
        return this.seed.func_77973_b();
    }

    protected Item func_149865_P() {
        return this.tryGetCrop().func_77973_b();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176488_a, TOP});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 8) {
            return super.func_176203_a(7).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true));
        }
        return super.func_176203_a(meta).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        ItemStack itemStack = this.tryGetCrop();
        if (itemStack != null) {
            for (int i = 0; i < count; ++i) {
                drops.add((Object)itemStack.func_77946_l());
            }
        }
        drops.add((Object)this.seed.func_77946_l());
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            return 8;
        }
        return super.func_176201_c(state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = (Integer)state.func_177229_b((IProperty)field_176488_a);
        return meta > 6 ? this.func_149865_P() : this.func_149866_i();
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.func_185527_x(state) >= this.func_185526_g() ? (random.nextInt(this.cMax - this.cMin + 1) + this.cMin) * Math.max(1, fortune) : 0;
    }

    @Override
    public Item createItem(Block block) {
        Item seeds = ((Item)new ItemSeeds(block, Blocks.field_150458_ak).setRegistryName(block.getRegistryName())).func_77655_b(block.func_149739_a());
        this.seed = new ItemStack(seeds);
        return seeds;
    }

    @Override
    public void setSoundType(CTSoundType soundType) {
        this.func_149672_a(soundType.getType());
    }
}

