/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block.generic;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import surreal.contentcreator.common.block.generic.BlockGenericCrop;
import surreal.contentcreator.common.block.generic.IGenericBlock;

public class BlockGenericCropRestricted
extends BlockGenericCrop
implements IGenericBlock {
    private HashSet<IBlockState> neededBlocks = new HashSet();

    public BlockGenericCropRestricted(String c, int meta, int cMin, int cMax, String blockId, int blockMeta) {
        super(c, meta, cMin, cMax);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
        IBlockState blockState = block == null ? null : block.func_176203_a(blockMeta);
        this.neededBlocks.add(blockState);
    }

    public BlockGenericCropRestricted(String c, int meta, int cMin, int cMax, String oreDictName) {
        super(c, meta, cMin, cMax);
        String cleanedOreDictName = oreDictName.startsWith("ore:") ? oreDictName.substring(4) : oreDictName;
        for (ItemStack stack : OreDictionary.getOres((String)cleanedOreDictName)) {
            if (!(stack.func_77973_b() instanceof ItemBlock) || stack.func_190926_b()) continue;
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                if (stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != state.func_177230_c().func_176201_c(state)) continue;
                this.neededBlocks.add(state);
            }
        }
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (this.hasNeededBlock(worldIn, pos)) {
            return (worldIn.func_175699_k(pos) >= 8 || worldIn.func_175678_i(pos)) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    public boolean hasNeededBlock(World worldIn, BlockPos pos) {
        return this.neededBlocks.contains(worldIn.func_180495_p(pos.func_177978_c())) || this.neededBlocks.contains(worldIn.func_180495_p(pos.func_177968_d())) || this.neededBlocks.contains(worldIn.func_180495_p(pos.func_177974_f())) || this.neededBlocks.contains(worldIn.func_180495_p(pos.func_177976_e()));
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.func_185525_y(state) && this.hasNeededBlock(worldIn, pos);
    }
}

