/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block.generic;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import surreal.contentcreator.common.block.generic.IGenericBlock;
import surreal.contentcreator.types.CTSoundType;

public class BlockGenericCrop
extends BlockCrops
implements IGenericBlock {
    private boolean cropItemExists = true;
    private String cropID;
    private int cropMeta;
    private ItemStack seed;
    private ItemStack crop;
    private int cMin;
    private int cMax;

    @Nullable
    private ItemStack tryGetCrop() {
        if (this.crop == null && this.cropItemExists) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.cropID));
            if (item != null) {
                this.crop = new ItemStack(item, 1, this.cropMeta);
            }
            if (this.crop == null) {
                this.cropItemExists = false;
            }
        }
        return this.crop;
    }

    public BlockGenericCrop(String c, int meta, int cMin, int cMax) {
        this.cropID = c;
        this.cropMeta = meta;
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.cropID));
        ItemStack itemStack = item == null ? null : new ItemStack(item, 1, this.cropMeta);
        this.crop = itemStack == null ? null : itemStack;
        this.cMin = Math.max(cMin, 1);
        this.cMax = Math.max(cMin, cMax);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        ItemStack itemStack = this.tryGetCrop();
        if (itemStack != null) {
            for (int i = 0; i < count; ++i) {
                drops.add((Object)itemStack.func_77946_l());
            }
        }
        drops.add((Object)this.seed.func_77946_l());
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List drops = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockGenericCrop.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_185525_y(state) ? this.tryGetCrop().func_77960_j() : this.seed.func_77960_j();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.func_185525_y(state) ? this.tryGetCrop().func_77973_b() : this.seed.func_77973_b();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.seed;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.func_185527_x(state) >= this.func_185526_g() ? (random.nextInt(this.cMax - this.cMin + 1) + this.cMin) * Math.max(1, fortune) : 0;
    }

    protected Item func_149865_P() {
        return this.tryGetCrop().func_77973_b();
    }

    protected Item func_149866_i() {
        return this.seed.func_77973_b();
    }

    @Override
    public void setSoundType(CTSoundType soundType) {
        this.func_149672_a(soundType.getType());
    }

    @Override
    public Item createItem(Block block) {
        Item seeds = ((Item)new ItemSeeds(block, Blocks.field_150458_ak).setRegistryName(block.getRegistryName())).func_77655_b(block.func_149739_a());
        this.seed = new ItemStack(seeds);
        return seeds;
    }
}

