/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block.generic;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import surreal.contentcreator.common.block.generic.IGenericBlock;
import surreal.contentcreator.types.CTSoundType;

public class BlockGenericCocoa
extends BlockCocoa
implements IGenericBlock {
    private boolean cropItemExists = true;
    private String cropID;
    private int cropMeta;
    private ItemStack crop;
    private int cMin;
    private int cMax;

    @Nullable
    private ItemStack tryGetCrop() {
        if (this.crop == null && this.cropItemExists) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.cropID));
            if (item != null) {
                this.crop = new ItemStack(item, 1, this.cropMeta);
            }
            if (this.crop == null) {
                this.cropItemExists = false;
            }
        }
        return this.crop;
    }

    public BlockGenericCocoa(String c, int meta, int cMin, int cMax) {
        this.cropID = c;
        this.cropMeta = meta;
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.cropID));
        ItemStack itemStack = item == null ? null : new ItemStack(item, 1, this.cropMeta);
        this.crop = itemStack == null ? null : itemStack;
        this.cMin = Math.max(cMin, 1);
        this.cMax = Math.max(cMin, cMax);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.tryGetCrop();
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return (Integer)state.func_177229_b((IProperty)field_176501_a) >= 2 ? (random.nextInt(this.cMax - this.cMin + 1) + this.cMin) * Math.max(1, fortune) : 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.tryGetCrop().func_77973_b();
    }

    public int func_180651_a(IBlockState state) {
        return this.tryGetCrop().func_77960_j();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand) + 1;
        ItemStack itemStack = this.tryGetCrop();
        if (itemStack != null) {
            for (int i = 0; i < count; ++i) {
                drops.add((Object)itemStack.func_77946_l());
            }
        }
    }

    @Override
    public void setSoundType(CTSoundType soundType) {
        this.func_149672_a(soundType.getType());
    }
}

