/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block.generic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import surreal.contentcreator.common.block.generic.IGenericBlock;
import surreal.contentcreator.types.CTSoundEvent;
import surreal.contentcreator.types.CTSoundType;

public class BlockGenericButton
extends BlockButton
implements IGenericBlock {
    private final boolean wooden;
    private final int tickRate;
    private CTSoundEvent click;
    private CTSoundEvent release;

    protected BlockGenericButton(boolean wooden, int tickRate) {
        super(wooden);
        this.wooden = wooden;
        this.tickRate = tickRate;
    }

    public int func_149738_a(@Nonnull World worldIn) {
        return this.tickRate > 0 ? this.tickRate : super.func_149738_a(worldIn);
    }

    public BlockGenericButton setClick(CTSoundEvent click) {
        this.click = click;
        return this;
    }

    public BlockGenericButton setRelease(CTSoundEvent release) {
        this.release = release;
        return this;
    }

    protected void func_185615_a(@Nullable EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        if (this.click != null) {
            worldIn.func_184133_a(player, pos, this.click.getInternal(), SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else if (this.wooden) {
            worldIn.func_184133_a(player, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            worldIn.func_184133_a(player, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    protected void func_185617_b(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        if (this.release != null) {
            worldIn.func_184133_a(null, pos, this.release.getInternal(), SoundCategory.BLOCKS, 0.3f, 0.5f);
        } else if (this.wooden) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    @Override
    public void setSoundType(CTSoundType soundType) {
        this.func_149672_a(soundType.getType());
    }
}

