/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.common.block.generic;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IMaterial;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import surreal.contentcreator.common.block.generic.BlockGenericButton;
import surreal.contentcreator.common.block.generic.BlockGenericCake;
import surreal.contentcreator.common.block.generic.BlockGenericCocoa;
import surreal.contentcreator.common.block.generic.BlockGenericColored;
import surreal.contentcreator.common.block.generic.BlockGenericCrop;
import surreal.contentcreator.common.block.generic.BlockGenericCropRestricted;
import surreal.contentcreator.common.block.generic.BlockGenericCropTall;
import surreal.contentcreator.common.block.generic.BlockGenericCropTallRestricted;
import surreal.contentcreator.common.block.generic.BlockGenericDoor;
import surreal.contentcreator.common.block.generic.BlockGenericFalling;
import surreal.contentcreator.common.block.generic.BlockGenericFence;
import surreal.contentcreator.common.block.generic.BlockGenericFenceGate;
import surreal.contentcreator.common.block.generic.BlockGenericHalfSlab;
import surreal.contentcreator.common.block.generic.BlockGenericHorizontal;
import surreal.contentcreator.common.block.generic.BlockGenericPillar;
import surreal.contentcreator.common.block.generic.BlockGenericPressurePlate;
import surreal.contentcreator.common.block.generic.BlockGenericPressurePlateWeighted;
import surreal.contentcreator.common.block.generic.BlockGenericStairs;
import surreal.contentcreator.common.block.generic.BlockGenericStem;
import surreal.contentcreator.common.block.generic.BlockGenericTransparent;
import surreal.contentcreator.common.block.generic.IGenericBlock;
import surreal.contentcreator.proxy.CommonProxy;
import surreal.contentcreator.types.CTSoundEvent;
import surreal.contentcreator.types.CTSoundType;

@ZenRegister
@ZenClass(value="contentcreator.block.GenericBlock")
public class BlockGeneric {
    private final Block block;

    private BlockGeneric(Block block) {
        this.block = block;
    }

    @ZenMethod
    public static BlockGeneric createPillar(IMaterial material, MapColor mapColor, String name) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericPillar(CraftTweakerMC.getMaterial((IMaterial)material), mapColor), name));
    }

    @ZenMethod
    public static BlockGeneric createPillar(IMaterial material, String name) {
        return BlockGeneric.createPillar(material, CraftTweakerMC.getMaterial((IMaterial)material).func_151565_r(), name);
    }

    @ZenMethod
    public static BlockGeneric createBlockFalling(String name) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericFalling(), name));
    }

    @ZenMethod
    public static BlockGeneric createBlockColored(IMaterial material, String name, @Optional boolean color) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericColored(CraftTweakerMC.getMaterial((IMaterial)material), color), name));
    }

    @ZenMethod
    public static BlockGeneric createFence(IMaterial material, MapColor mapColor, String name) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericFence(CraftTweakerMC.getMaterial((IMaterial)material), mapColor), name));
    }

    @ZenMethod
    public static BlockGeneric createFence(IMaterial material, String name) {
        return BlockGeneric.createFence(material, CraftTweakerMC.getMaterial((IMaterial)material).func_151565_r(), name);
    }

    @ZenMethod
    public static BlockGeneric createFenceGate(IMaterial material, MapColor mapColor, String name) {
        return new BlockGeneric(BlockGeneric.createBlock(new BlockGenericFenceGate(CraftTweakerMC.getMaterial((IMaterial)material), mapColor), name));
    }

    @ZenMethod
    public static BlockGeneric createFenceGate(IMaterial material, String name) {
        return BlockGeneric.createFenceGate(material, CraftTweakerMC.getMaterial((IMaterial)material).func_151565_r(), name);
    }

    @ZenMethod
    public static BlockGeneric createDoor(IMaterial material, String name) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericDoor(CraftTweakerMC.getMaterial((IMaterial)material)), name));
    }

    @ZenMethod
    public static BlockGeneric createPressurePlate(IMaterial material, int sensitivity, String name) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericPressurePlate(CraftTweakerMC.getMaterial((IMaterial)material), sensitivity), name));
    }

    @ZenMethod
    public static BlockGeneric createPressurePlateWeighted(IMaterial material, MapColor mapColor, int maxWeight, String name) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericPressurePlateWeighted(CraftTweakerMC.getMaterial((IMaterial)material), maxWeight, mapColor), name));
    }

    @ZenMethod
    public static BlockGeneric createPressurePlateWeighted(IMaterial material, int maxWeight, String name) {
        return BlockGeneric.createPressurePlateWeighted(material, CraftTweakerMC.getMaterial((IMaterial)material).func_151565_r(), maxWeight, name);
    }

    @ZenMethod
    public static BlockGeneric createButton(String name, boolean wooden, @Optional int tickrate, @Optional CTSoundEvent click, @Optional CTSoundEvent release) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericButton(wooden, tickrate).setClick(click).setRelease(release), name));
    }

    @ZenMethod
    public static BlockGeneric createCake(String name, @Optional int foodLevel, @Optional float saturation) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericCake(foodLevel, saturation), name));
    }

    @ZenMethod
    public static BlockGeneric createCrop(String name, String crop, @Optional int meta, @Optional int cropMinDrop, @Optional int cropMaxDrop) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericCrop(crop, meta, cropMinDrop, cropMaxDrop), name));
    }

    @ZenMethod
    public static BlockGeneric createCropRestrictedByBlock(String name, String crop, String block, @Optional int cropMeta, @Optional int blockMeta, @Optional int cropMinDrop, @Optional int cropMaxDrop) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericCropRestricted(crop, cropMeta, cropMinDrop, cropMaxDrop, block, blockMeta), name));
    }

    @ZenMethod
    public static BlockGeneric createCropRestrictedByOreDictionary(String name, String crop, String oreDictionary, @Optional int cropMeta, @Optional int cropMinDrop, @Optional int cropMaxDrop) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericCropRestricted(crop, cropMeta, cropMinDrop, cropMaxDrop, oreDictionary), name));
    }

    @ZenMethod
    public static BlockGeneric createStem(String name, String block, @Optional int meta) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)BlockGenericStem.create(block, meta), name));
    }

    @ZenMethod
    public static BlockGeneric createCropTall(String name, String crop, @Optional int meta, @Optional int cropMinDrop, @Optional int cropMaxDrop) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericCropTall(crop, meta, cropMinDrop, cropMaxDrop), name));
    }

    @ZenMethod
    public static BlockGeneric createCropTallRestrictedByBlock(String name, String crop, String block, @Optional int cropMeta, @Optional int blockMeta, @Optional int cropMinDrop, @Optional int cropMaxDrop) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericCropTallRestricted(crop, cropMeta, cropMinDrop, cropMaxDrop, block, blockMeta), name));
    }

    @ZenMethod
    public static BlockGeneric createCropTallRestrictedByOreDictionary(String name, String crop, String oreDictionary, @Optional int cropMeta, @Optional int cropMinDrop, @Optional int cropMaxDrop) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericCropTallRestricted(crop, cropMeta, cropMinDrop, cropMaxDrop, oreDictionary), name));
    }

    @ZenMethod
    public static BlockGeneric createCocoaCrop(String name, String crop, @Optional int meta, @Optional int cropMinDrop, @Optional int cropMaxDrop) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericCocoa(crop, meta, cropMinDrop, cropMaxDrop), name));
    }

    @ZenMethod
    public static BlockGeneric createHorizontal(IMaterial material, MapColor mapColor, String name) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericHorizontal(CraftTweakerMC.getMaterial((IMaterial)material), mapColor), name));
    }

    @ZenMethod
    public static BlockGeneric createHorizontal(IMaterial material, String name) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericHorizontal(CraftTweakerMC.getMaterial((IMaterial)material)), name));
    }

    @ZenMethod
    public static BlockGeneric createSlab(IMaterial material, MapColor mapColor, String name) {
        return new BlockGeneric((Block)new BlockGenericHalfSlab(CraftTweakerMC.getMaterial((IMaterial)material), mapColor, name));
    }

    @ZenMethod
    public static BlockGeneric createSlab(IMaterial material, String name) {
        return BlockGeneric.createSlab(material, CraftTweakerMC.getMaterial((IMaterial)material).func_151565_r(), name);
    }

    @ZenMethod
    public static BlockGeneric createStairs(String name, crafttweaker.api.block.IBlockState state) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericStairs(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state)), name));
    }

    @ZenMethod
    public static BlockGeneric createStairs(String name) {
        return BlockGeneric.createStairs(name, CraftTweakerMC.getBlockState((IBlockState)Blocks.field_150348_b.func_176223_P()));
    }

    @ZenMethod
    public static BlockGeneric createGlass(IMaterial material, String name, @Optional boolean ignoreSimilarity, @Optional boolean silkTouch) {
        return new BlockGeneric(BlockGeneric.createBlock((Block)new BlockGenericTransparent(CraftTweakerMC.getMaterial((IMaterial)material), ignoreSimilarity, silkTouch), name));
    }

    @ZenMethod
    public BlockGeneric setHardness(float hardness) {
        this.block.func_149711_c(hardness);
        return this;
    }

    @ZenMethod
    public BlockGeneric setUnbreakable() {
        this.block.func_149722_s();
        return this;
    }

    @ZenMethod
    public BlockGeneric setStrength(float hardness, float resistance) {
        this.block.func_149711_c(hardness).func_149752_b(resistance);
        return this;
    }

    @ZenMethod
    public BlockGeneric setLightOpacity(int opacity) {
        this.block.func_149713_g(opacity);
        return this;
    }

    @ZenMethod
    public BlockGeneric setLightLevel(int value) {
        this.block.func_149715_a((float)value);
        return this;
    }

    @ZenMethod
    public BlockGeneric setSlipperiness(float slipperiness) {
        this.block.setDefaultSlipperiness(slipperiness);
        return this;
    }

    @ZenMethod
    public BlockGeneric setHarvestLevel(String tool, int level) {
        this.block.setHarvestLevel(tool, level);
        return this;
    }

    @ZenMethod
    public BlockGeneric setSoundType(CTSoundType soundType) {
        ((IGenericBlock)this.block).setSoundType(soundType);
        return this;
    }

    @ZenMethod
    public void register() {
        ((IGenericBlock)this.block).create(CommonProxy.BLOCKS);
        CommonProxy.BLOCKS.add(this.block);
        Item item = ((IGenericBlock)this.block).createItem(this.block);
        if (item != null) {
            CommonProxy.ITEMBLOCKS.add(item);
        }
    }

    private static Block createBlock(Block block, String name) {
        return ((Block)block.setRegistryName("contentcreator", name)).func_149663_c("contentcreator." + name);
    }
}

