/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.main;

import austeretony.enchcontrol.common.command.EnumCommandArg;
import austeretony.enchcontrol.common.enchantment.EnchantmentWrapper;
import austeretony.enchcontrol.common.main.ECMain;
import austeretony.enchcontrol.common.reference.CommonReference;
import com.google.common.collect.HashMultimap;
import java.util.TreeSet;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public enum EnumChatMessage {
    UPDATE_MESSAGE,
    COMMAND_EC_HELP,
    COMMAND_EC_LIST_ALL,
    COMMAND_EC_FILE_ALL,
    COMMAND_EC_LIST_UNKNOWN,
    COMMAND_EC_FILE_UNKNOWN,
    COMMAND_EC_CLEAR,
    COMMAND_EC_RELOAD,
    COMMAND_EC_BACKUP,
    COMMAND_EC_UPDATE,
    COMMAND_EC_INFO,
    COMMAND_EC_EVAL,
    COMMAND_EC_ERR_NO_UNKNOWN_ENCHANTMENTS,
    COMMAND_EC_ERR_EXTERNAL_CONFIG_DISABLED,
    COMMAND_EC_ERR_DEBUG_MODE_DISABLED,
    COMMAND_EC_ERR_WRONG_EXPRESSION,
    COMMAND_EC_ERR_RUNNING_AT_DEDICATED_SERVER;

    public static final ITextComponent PREFIX;

    private static ITextComponent prefix() {
        return PREFIX.func_150259_f();
    }

    private String formatVersion(String input) {
        try {
            String[] splitted = input.split("[:]");
            return splitted[0] + " " + splitted[1] + " r-" + splitted[2];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return input;
        }
    }

    public void sendMessage(EntityPlayer player, String ... args) {
        switch (this) {
            case UPDATE_MESSAGE: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.update.newVersion", new Object[0]);
                TextComponentString msg2 = new TextComponentString(" " + this.formatVersion("1.1.5:beta:0") + " / " + this.formatVersion(args[0]));
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1).func_150257_a((ITextComponent)msg2));
                msg1 = new TextComponentTranslation("ec.update.projectPage", new Object[0]);
                msg2 = new TextComponentString(": ");
                TextComponentString msg3 = new TextComponentString("minecraft.curseforge.com");
                msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                msg3.func_150256_b().func_150238_a(TextFormatting.WHITE);
                msg3.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/enchantments-control"));
                CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                break;
            }
            case COMMAND_EC_HELP: {
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)new TextComponentTranslation("ec.command.help.title", new Object[0])));
                for (EnumCommandArg arg : EnumCommandArg.values()) {
                    if (arg == EnumCommandArg.HELP) continue;
                    TextComponentString msg1 = new TextComponentString("/ec " + (Object)((Object)arg));
                    TextComponentString msg2 = new TextComponentString(" - ");
                    msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                    msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    CommonReference.sendMessage(player, msg1.func_150257_a(msg2.func_150257_a((ITextComponent)new TextComponentTranslation("ec.command.help." + (Object)((Object)arg), new Object[0]))));
                }
                break;
            }
            case COMMAND_EC_LIST_ALL: {
                if (!args[0].equals("-r") && !args[0].equals("-nr")) {
                    TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.err.wrongArg", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                    CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                    break;
                }
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)new TextComponentTranslation("ec.command.list-all", new Object[0])));
                TreeSet<String> sortedModNames = new TreeSet<String>();
                HashMultimap wrappersByModNames = HashMultimap.create();
                boolean showRegistry = args[0].equals("-r");
                for (EnchantmentWrapper wrapper : EnchantmentWrapper.getWrappers()) {
                    String modName = ECMain.MODS_NAMES.get(wrapper.modid);
                    modName = modName == null ? "Undefined" : modName;
                    sortedModNames.add(modName);
                    wrappersByModNames.put((Object)modName, (Object)wrapper);
                }
                for (String s : sortedModNames) {
                    for (EnchantmentWrapper w : wrappersByModNames.get((Object)s)) {
                        TextComponentString regName;
                        TextComponentString regNameLog;
                        TextComponentString modLog = new TextComponentString("M: ");
                        modLog.func_150256_b().func_150238_a(TextFormatting.AQUA);
                        TextComponentTranslation mod = new TextComponentTranslation(s, new Object[0]);
                        mod.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        TextComponentString nameLog = new TextComponentString(", N: ");
                        nameLog.func_150256_b().func_150238_a(TextFormatting.AQUA);
                        TextComponentTranslation name = new TextComponentTranslation(w.getName(), new Object[0]);
                        name.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        if (showRegistry) {
                            regNameLog = new TextComponentString(", RN: ");
                            regName = new TextComponentString(w.registryName.toString());
                            regName.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        } else {
                            regNameLog = new TextComponentString("");
                            regName = new TextComponentString("");
                        }
                        CommonReference.sendMessage(player, modLog.func_150257_a((ITextComponent)mod).func_150257_a((ITextComponent)nameLog).func_150257_a((ITextComponent)name).func_150257_a((ITextComponent)regNameLog).func_150257_a((ITextComponent)regName));
                    }
                }
                break;
            }
            case COMMAND_EC_FILE_ALL: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.file-all", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_EC_LIST_UNKNOWN: {
                if (!args[0].equals("-r") && !args[0].equals("-nr")) {
                    TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.err.wrongArg", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                    CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                    break;
                }
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)new TextComponentTranslation("ec.command.list-unknown", new Object[0])));
                TreeSet<String> sortedModNames2 = new TreeSet<String>();
                HashMultimap wrappersByModNames2 = HashMultimap.create();
                boolean showRegistry2 = args[0].equals("-r");
                for (EnchantmentWrapper wrapper : EnchantmentWrapper.UNKNOWN) {
                    String modName = ECMain.MODS_NAMES.get(wrapper.modid);
                    modName = modName == null ? "Undefined" : modName;
                    sortedModNames2.add(modName);
                    wrappersByModNames2.put((Object)modName, (Object)wrapper);
                }
                for (String s : sortedModNames2) {
                    for (EnchantmentWrapper w : wrappersByModNames2.get((Object)s)) {
                        TextComponentString regName;
                        TextComponentString regNameLog;
                        TextComponentString modLog = new TextComponentString("M: ");
                        modLog.func_150256_b().func_150238_a(TextFormatting.AQUA);
                        TextComponentTranslation mod = new TextComponentTranslation(s, new Object[0]);
                        mod.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        TextComponentString nameLog = new TextComponentString(", N: ");
                        nameLog.func_150256_b().func_150238_a(TextFormatting.AQUA);
                        TextComponentTranslation name = new TextComponentTranslation(w.getName(), new Object[0]);
                        name.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        if (showRegistry2) {
                            regNameLog = new TextComponentString(", RN: ");
                            regName = new TextComponentString(w.registryName.toString());
                            regName.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        } else {
                            regNameLog = new TextComponentString("");
                            regName = new TextComponentString("");
                        }
                        CommonReference.sendMessage(player, modLog.func_150257_a((ITextComponent)mod).func_150257_a((ITextComponent)nameLog).func_150257_a((ITextComponent)name).func_150257_a((ITextComponent)regNameLog).func_150257_a((ITextComponent)regName));
                    }
                }
                break;
            }
            case COMMAND_EC_FILE_UNKNOWN: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.file-unknown", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_EC_CLEAR: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.clear", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_EC_RELOAD: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.reload", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_EC_BACKUP: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.backup", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_EC_UPDATE: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.update", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_EC_INFO: {
                ResourceLocation registryName = new ResourceLocation(args[0]);
                Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)registryName);
                if (ench != null) {
                    EnchantmentWrapper wrapper = EnchantmentWrapper.get(ench);
                    TextComponentTranslation msg1 = new TextComponentTranslation(wrapper.getName(), new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    TextComponentString msg2 = new TextComponentString(" / ");
                    msg2.func_150256_b().func_150238_a(TextFormatting.GREEN);
                    TextComponentString msg3 = new TextComponentString(args[0] + " ");
                    msg3.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    TextComponentTranslation msg4 = new TextComponentTranslation("ec.command.info", new Object[0]);
                    msg4.func_150256_b().func_150238_a(TextFormatting.GREEN);
                    CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1).func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3).func_150257_a((ITextComponent)msg4));
                    msg1 = new TextComponentTranslation("ec.command.info.status", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" ");
                    msg3 = new TextComponentTranslation(wrapper.isEnabled() ? "ec.command.info.status.enabled" : "ec.command.info.status.disabled", new Object[0]);
                    msg3.func_150256_b().func_150238_a(wrapper.isEnabled() ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                    msg1 = new TextComponentTranslation("ec.command.info.rarity", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" " + ench.func_77324_c().toString());
                    msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2));
                    msg1 = new TextComponentTranslation("ec.command.info.treasure", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" ");
                    msg3 = new TextComponentTranslation(wrapper.isTreasure() ? "ec.command.info.yes" : "ec.command.info.no", new Object[0]);
                    msg3.func_150256_b().func_150238_a(wrapper.isTreasure() ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                    msg1 = new TextComponentTranslation("ec.command.info.doubledPrice", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" ");
                    msg3 = new TextComponentTranslation(wrapper.shouldDoublePrice() ? "ec.command.info.yes" : "ec.command.info.no", new Object[0]);
                    msg3.func_150256_b().func_150238_a(wrapper.shouldDoublePrice() ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                    msg1 = new TextComponentTranslation("ec.command.info.curse", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" ");
                    msg3 = new TextComponentTranslation(wrapper.isCurse() ? "ec.command.info.yes" : "ec.command.info.no", new Object[0]);
                    msg3.func_150256_b().func_150238_a(wrapper.isCurse() ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                    msg1 = new TextComponentTranslation("ec.command.info.allowedOnBooks", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" ");
                    msg3 = new TextComponentTranslation(wrapper.isAllowedOnBooks() ? "ec.command.info.yes" : "ec.command.info.no", new Object[0]);
                    msg3.func_150256_b().func_150238_a(wrapper.isAllowedOnBooks() ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                    msg1 = new TextComponentTranslation("ec.command.info.levels", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" " + wrapper.getMinLevel() + " - " + wrapper.getMaxLevel());
                    msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2));
                    msg1 = new TextComponentTranslation("ec.command.info.evalsStatus", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" ");
                    msg3 = new TextComponentTranslation(wrapper.useCustomEvals() ? "ec.command.info.status.enabled" : "ec.command.info.status.disabled", new Object[0]);
                    msg3.func_150256_b().func_150238_a(wrapper.useCustomEvals() ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                    if (wrapper.useCustomEvals()) {
                        msg1 = new TextComponentTranslation("ec.command.info.evals", new Object[0]);
                        msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                        msg2 = new TextComponentString(" " + wrapper.getMinEnchantabilityEval() + " / " + wrapper.getMaxEnchantabilityEval());
                        msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2));
                    }
                    msg1 = new TextComponentTranslation("ec.command.info.enchantability", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    CommonReference.sendMessage(player, (ITextComponent)msg1);
                    for (int i = wrapper.getMinLevel(); i <= wrapper.getMaxLevel(); ++i) {
                        msg1 = new TextComponentString("Level " + i + ": ");
                        msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                        msg2 = new TextComponentString(wrapper.getMinEnchantability(i) + " - " + wrapper.getMaxEnchantability(i));
                        msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2));
                    }
                    msg1 = new TextComponentTranslation("ec.command.info.type", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" " + (ench.field_77351_y == null ? "NONE" : ench.field_77351_y.toString()));
                    msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2));
                    msg1 = new TextComponentTranslation("ec.command.info.slots", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    CommonReference.sendMessage(player, (ITextComponent)msg1);
                    for (EntityEquipmentSlot slot : ench.field_185263_a) {
                        CommonReference.sendMessage(player, (ITextComponent)new TextComponentString(slot.toString()));
                    }
                    msg1 = new TextComponentTranslation("ec.command.info.incompatStatus", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" ");
                    msg3 = new TextComponentTranslation(wrapper.getIncompatMode() == 0 ? "ec.command.info.incompatStatus.both" : "ec.command.info.incompatStatus.custom", new Object[0]);
                    msg3.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                    msg1 = new TextComponentTranslation("ec.command.info.incompat", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    CommonReference.sendMessage(player, (ITextComponent)msg1);
                    if (wrapper.hasIncompatibleEnchantments()) {
                        for (ResourceLocation l : wrapper.getIncompatibleEnchantments()) {
                            CommonReference.sendMessage(player, (ITextComponent)new TextComponentString(l.toString()));
                        }
                    }
                    if (!wrapper.hasIncompatibleEnchantments()) {
                        CommonReference.sendMessage(player, (ITextComponent)new TextComponentTranslation("ec.command.info.empty", new Object[0]));
                    }
                    msg1 = new TextComponentTranslation("ec.command.info.listStatus", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" ");
                    msg3 = new TextComponentTranslation(wrapper.getApplicabilityMode() == 0 ? "ec.command.info.incompatStatus.both" : "ec.command.info.incompatStatus.custom", new Object[0]);
                    msg3.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                    msg1 = new TextComponentTranslation("ec.command.info.listMode", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    msg2 = new TextComponentString(" ");
                    msg3 = new TextComponentTranslation(wrapper.getListMode() > 0 ? "ec.command.info.whitelist" : "ec.command.info.blacklist", new Object[0]);
                    msg3.func_150256_b().func_150238_a(wrapper.getListMode() > 0 ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED);
                    CommonReference.sendMessage(player, msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                    msg1 = new TextComponentTranslation("ec.command.info.itemsList", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    CommonReference.sendMessage(player, (ITextComponent)msg1);
                    if (wrapper.hasItemList()) {
                        for (ResourceLocation l : wrapper.getItemList()) {
                            CommonReference.sendMessage(player, (ITextComponent)new TextComponentString(l.toString()));
                        }
                    }
                    if (!wrapper.hasItemList()) {
                        CommonReference.sendMessage(player, (ITextComponent)new TextComponentTranslation("ec.command.info.empty", new Object[0]));
                    }
                    msg1 = new TextComponentTranslation("ec.command.info.desc", new Object[0]);
                    msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    CommonReference.sendMessage(player, (ITextComponent)msg1);
                    if (wrapper.hasDescription()) {
                        for (String s : wrapper.getDescription()) {
                            CommonReference.sendMessage(player, (ITextComponent)new TextComponentTranslation(s, new Object[0]));
                        }
                    }
                    if (wrapper.hasDescription()) break;
                    CommonReference.sendMessage(player, (ITextComponent)new TextComponentTranslation("ec.command.info.empty", new Object[0]));
                    break;
                }
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.err.unknownEnch", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                TextComponentString msg2 = new TextComponentString(" " + args[0]);
                msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1).func_150257_a((ITextComponent)msg2));
                break;
            }
            case COMMAND_EC_EVAL: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.eval", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                TextComponentString msg2 = new TextComponentString(" " + args[0]);
                msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                TextComponentString msg3 = new TextComponentString(" = ");
                msg3.func_150256_b().func_150238_a(TextFormatting.GREEN);
                TextComponentString msg4 = new TextComponentString(args[1]);
                msg4.func_150256_b().func_150238_a(TextFormatting.WHITE);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1).func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3).func_150257_a((ITextComponent)msg4));
                break;
            }
            case COMMAND_EC_ERR_NO_UNKNOWN_ENCHANTMENTS: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.err.noUnknown", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_EC_ERR_EXTERNAL_CONFIG_DISABLED: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.err.externalConfigDisabled", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_EC_ERR_DEBUG_MODE_DISABLED: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.err.debugModeDisabled", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_EC_ERR_WRONG_EXPRESSION: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.err.wrongExpression", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                TextComponentString msg2 = new TextComponentString(" " + args[0]);
                msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1).func_150257_a((ITextComponent)msg2));
                break;
            }
            case COMMAND_EC_ERR_RUNNING_AT_DEDICATED_SERVER: {
                TextComponentTranslation msg1 = new TextComponentTranslation("ec.command.err.runningDedicatedServer", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                CommonReference.sendMessage(player, EnumChatMessage.prefix().func_150257_a((ITextComponent)msg1));
            }
        }
    }

    static {
        PREFIX = new TextComponentString("[EC] ");
        PREFIX.func_150256_b().func_150238_a(TextFormatting.AQUA);
    }
}

