/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.main;

import austeretony.enchcontrol.client.event.EnchantmentDescriptionRenderer;
import austeretony.enchcontrol.common.command.CommandEC;
import austeretony.enchcontrol.common.config.ConfigLoader;
import austeretony.enchcontrol.common.enchantment.EnchantmentWrapper;
import austeretony.enchcontrol.common.reference.CommonReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="enchcontrol", name="Enchantments Control", version="1.1.5", certificateFingerprint="503a793335572ddd78512349bd8048f536a62fdb", updateJSON="https://raw.githubusercontent.com/AustereTony-MCMods/Enchantments-Control/info/mod_versions_forge.json", acceptedMinecraftVersions="[1.12.2]")
public class ECMain {
    public static final String MODID = "enchcontrol";
    public static final String NAME = "Enchantments Control";
    public static final String VERSION = "1.1.5";
    public static final String VERSION_CUSTOM = "1.1.5:beta:0";
    public static final String GAME_VERSION = "1.12.2";
    public static final String VERSIONS_FORGE_URL = "https://raw.githubusercontent.com/AustereTony-MCMods/Enchantments-Control/info/mod_versions_forge.json";
    public static final String PROJECT_LOCATION = "minecraft.curseforge.com";
    public static final String PROJECT_URL = "https://minecraft.curseforge.com/projects/enchantments-control";
    public static final Logger LOGGER = LogManager.getLogger((String)"Enchantments Control");
    public static final Map<String, String> MODS_NAMES = new HashMap<String, String>();

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            CommonReference.registerEvent(new EnchantmentDescriptionRenderer());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.collectModNames();
        this.removeUnloadedModdedEnchantments();
        if (event.getSide() == Side.CLIENT) {
            ConfigLoader.processEnchantmentDescriptionsSupport();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (event.getSide() == Side.SERVER) {
            ConfigLoader.runningAtDedicatedServer = true;
        }
        CommonReference.registerCommand(event, (ICommand)new CommandEC());
    }

    private void collectModNames() {
        for (ModContainer mod : Loader.instance().getModList()) {
            MODS_NAMES.put(mod.getModId(), mod.getName());
        }
    }

    private void removeUnloadedModdedEnchantments() {
        Iterator<EnchantmentWrapper> iterator = EnchantmentWrapper.getWrappers().iterator();
        while (iterator.hasNext()) {
            EnchantmentWrapper wrapper = iterator.next();
            if (MODS_NAMES.containsKey(wrapper.modid)) continue;
            iterator.remove();
        }
    }

    static {
        ConfigLoader.load();
    }
}

