/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public enum EnumConfigSettings {
    EXTERNAL_CONFIG(0, "main", "external_config", true),
    DEBUG_MODE(0, "main", "debug_mode", new boolean[0]),
    CUSTOM_LOCALIZATION(0, "main", "custom_localization", new boolean[0]),
    HIDE_CURSES(0, "tweaks", "hide_curses", new boolean[0]),
    NOTIFY_CURSED(0, "tweaks", "notify_cursed", new boolean[0]),
    ROMAN_NUMERALS(0, "tweaks", "roman_numerals", new boolean[0]),
    ENCHANTMENT_TABLE_LEVEL_CAP(1, "tweaks", "enchantment_table_level_cap", new boolean[0]),
    ANVIL_LEVEL_CAP(1, "tweaks", "anvil_level_cap", new boolean[0]),
    MERCHANT_DEALS_LEVEL_CAP(1, "tweaks", "merchant_deals_level_cap", new boolean[0]),
    DUNGEON_LOOT_LEVEL_CAP(1, "tweaks", "dungeon_loot_level_cap", new boolean[0]),
    CREATIVE_TAB_LEVEL_CAP(1, "tweaks", "creative_tab_level_cap", new boolean[0]),
    DESCRIPTIONS(0, "description", "enabled", new boolean[0]),
    DESCRIPTIONS_HINT(0, "description", "show_hint", new boolean[0]),
    DESCRIPTIONS_LOCATION(1, "description", "location", new boolean[0]),
    DESCRIPTIONS_SEPARATOR(2, "description", "separator", new boolean[0]),
    DESCRIPTIONS_FOR_BOOKS(0, "description", "for_books", new boolean[0]),
    DESCRIPTIONS_FOR_ITEMS(0, "description", "for_items", new boolean[0]),
    DESCRIPTIONS_SHOW_DOMAIN(0, "description", "show_domain", new boolean[0]),
    LOAD_ED_DESC(0, "mod_support", "load_enchantment_descriptions_desc", new boolean[0]),
    UPLOAD_DESC_TO_ED(0, "mod_support", "upload_desc_to_enchantment_descriptions", new boolean[0]),
    SUPPORT_THERMAL_EXPANSION(0, "mod_support", "thermal_expansion", new boolean[0]);

    public final int type;
    public final String configSection;
    public final String configKey;
    public final boolean exclude;
    private boolean enabled;
    private int intValue;
    private String strValue;

    private EnumConfigSettings(int type, String configSection, String configKey, boolean ... exclude) {
        this.type = type;
        this.configSection = configSection;
        this.configKey = configKey;
        this.exclude = exclude.length > 0 ? exclude[0] : false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String getStrValue() {
        return this.strValue;
    }

    private JsonElement getValue(JsonObject jsonObject) {
        return jsonObject.get(this.configSection).getAsJsonObject().get(this.configKey);
    }

    public void initByType(JsonObject jsonObject) {
        switch (this.type) {
            case 0: {
                this.enabled = this.getValue(jsonObject).getAsBoolean();
                break;
            }
            case 1: {
                this.intValue = this.getValue(jsonObject).getAsInt();
                break;
            }
            case 2: {
                this.strValue = this.getValue(jsonObject).getAsString();
            }
        }
    }

    public static void initAll(JsonObject config) {
        for (EnumConfigSettings enumSetting : EnumConfigSettings.values()) {
            if (enumSetting.exclude) continue;
            enumSetting.initByType(config);
        }
    }
}

